/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    public UUID a;
    @Nullable
    public Entity b;
    public boolean c;
    public boolean d;
    @Nullable
    private Entity e;
    protected boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> type, World world) {
        super(type, world);
    }

    public void c(@Nullable Entity entity) {
        if (entity != null) {
            this.a = entity.cG();
            this.b = entity;
        } else {
            this.a = null;
            this.b = null;
            this.projectileSource = null;
        }
        this.refreshProjectileSource(false);
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        if (fillCache) {
            this.p();
        }
        if (this.b != null && !this.b.dR() && this.projectileSource == null && (craftEntity = this.b.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    @Nullable
    public Entity p() {
        if (this.b != null && !this.b.dR()) {
            this.refreshProjectileSource(false);
            return this.b;
        }
        if (this.a != null) {
            this.b = this.b(this.a);
            this.refreshProjectileSource(false);
            return this.b;
        }
        return null;
    }

    @Nullable
    protected Entity b(UUID uuid) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return worldserver.a(uuid);
        }
        return null;
    }

    public Entity E() {
        return (Entity)MoreObjects.firstNonNull((Object)this.p(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.a != null) {
            nbt.a("Owner", this.a);
        }
        if (this.c) {
            nbt.a("LeftOwner", true);
        }
        nbt.a("HasBeenShot", this.d);
    }

    protected boolean e(Entity entity) {
        return entity.cG().equals(this.a);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Owner")) {
            this.c(nbt.a("Owner"));
            if (this instanceof EntityEnderPearl && this.dW() != null && this.dW().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && this.dW().paperConfig().misc.legacyEnderPearlBehavior) {
                this.a = null;
            }
        }
        this.c = nbt.q("LeftOwner");
        this.d = nbt.q("HasBeenShot");
    }

    protected void c(UUID uuid) {
        if (this.a != uuid) {
            this.a = uuid;
            this.b = this.b(uuid);
        }
    }

    @Override
    public void x(Entity original) {
        super.x(original);
        if (original instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)original;
            this.a = iprojectile.a;
            this.b = iprojectile.b;
        }
    }

    @Override
    public void h() {
        if (!this.d) {
            this.a(GameEvent.K, this.p());
            this.d = true;
        }
        if (!this.c) {
            this.c = this.m();
        }
        super.h();
    }

    private boolean m() {
        Entity entity = this.p();
        if (entity != null) {
            AxisAlignedBB axisalignedbb = this.cR().b(this.dz()).g(1.0);
            return entity.dg().db().filter(IEntitySelector.h).noneMatch(entity1 -> axisalignedbb.c(entity1.cR()));
        }
        return true;
    }

    public Vec3D d(double x2, double y2, double z2, float power, float uncertainty) {
        return new Vec3D(x2, y2, z2).d().b(this.ae.a(0.0, 0.0172275 * (double)uncertainty), this.ae.a(0.0, 0.0172275 * (double)uncertainty), this.ae.a(0.0, 0.0172275 * (double)uncertainty)).c((double)power);
    }

    public void c(double x2, double y2, double z2, float power, float uncertainty) {
        Vec3D vec3d = this.d(x2, y2, z2, power, uncertainty);
        this.h(vec3d);
        this.ar = true;
        double d3 = vec3d.i();
        this.v((float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.e, d3) * 57.2957763671875));
        this.N = this.dM();
        this.O = this.dO();
    }

    public void a(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f5 = -MathHelper.a(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((pitch + roll) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        this.c(f5, f6, f7, speed, divergence);
        Vec3D vec3d = shooter.ah();
        if (!shooter.dW().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.h(this.dz().b(vec3d.d, shooter.aJ() ? 0.0 : vec3d.e, vec3d.f));
        }
    }

    public static <T extends IProjectile> T a(a<T> creator, WorldServer world, ItemStack projectileStack, EntityLiving shooter, float roll, float power, float divergence) {
        return IProjectile.spawnProjectileFromRotationDelayed(creator, world, projectileStack, shooter, roll, power, divergence).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileFromRotationDelayed(a<T> creator, WorldServer world, ItemStack projectileStack, EntityLiving shooter, float roll, float power, float divergence) {
        return IProjectile.spawnProjectileDelayed(creator.create(world, shooter, projectileStack), world, projectileStack, iprojectile -> iprojectile.a(shooter, shooter.dO(), shooter.dM(), roll, power, divergence));
    }

    public static <T extends IProjectile> T a(a<T> creator, WorldServer world, ItemStack projectileStack, EntityLiving shooter, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return (T)IProjectile.a(creator.create(world, shooter, projectileStack), world, projectileStack, iprojectile -> iprojectile.c(velocityX, velocityY, velocityZ, power, divergence));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer world, ItemStack projectileStack, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return IProjectile.spawnProjectileUsingShootDelayed(projectile, world, projectileStack, velocityX, velocityY, velocityZ, power, divergence).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileUsingShootDelayed(T projectile, WorldServer world, ItemStack projectileStack, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return IProjectile.spawnProjectileDelayed(projectile, world, projectileStack, iprojectile -> projectile.c(velocityX, velocityY, velocityZ, power, divergence));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer world, ItemStack projectileStack) {
        return (T)IProjectile.a(projectile, world, projectileStack, iprojectile -> {});
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer world, ItemStack projectileStack, Consumer<T> beforeSpawn) {
        return IProjectile.spawnProjectileDelayed(projectile, world, projectileStack, beforeSpawn).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileDelayed(T projectile, WorldServer world, ItemStack projectileStack, Consumer<T> beforeSpawn) {
        beforeSpawn.accept(projectile);
        return new Delayed<T>(projectile, world, projectileStack);
    }

    public void b(WorldServer world, ItemStack projectileStack) {
        EntityArrow entityarrow;
        ItemStack itemstack1;
        EnchantmentManager.a(world, projectileStack, this, (Item item) -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (itemstack1 = (entityarrow = (EntityArrow)iProjectile).ea()) != null && !itemstack1.f() && !projectileStack.h().equals(itemstack1.h())) {
            Objects.requireNonNull(entityarrow);
            EnchantmentManager.a(world, itemstack1, this, entityarrow::b);
        }
    }

    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.d() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.b(movingobjectposition);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection b(MovingObjectPosition hitResult) {
        ProjectileDeflection projectiledeflection1;
        MovingObjectPositionBlock movingobjectpositionblock;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)hitResult;
            Entity entity = movingobjectpositionentity.a();
            ProjectileDeflection projectiledeflection = entity.a(this);
            if (projectiledeflection != ProjectileDeflection.a) {
                if (entity != this.e && this.a(projectiledeflection, entity, this.p(), false)) {
                    this.e = entity;
                }
                return projectiledeflection;
            }
        } else if (this.C() && hitResult instanceof MovingObjectPositionBlock && (movingobjectpositionblock = (MovingObjectPositionBlock)hitResult).f() && this.a(projectiledeflection1 = ProjectileDeflection.b, null, this.p(), false)) {
            this.h(this.dz().c(0.2));
            return projectiledeflection1;
        }
        this.a(hitResult);
        return ProjectileDeflection.a;
    }

    protected boolean C() {
        return false;
    }

    public boolean a(ProjectileDeflection deflection, @Nullable Entity deflector, @Nullable Entity owner, boolean fromAttack) {
        deflection.deflect(this, deflector, this.ae);
        if (!this.dW().C) {
            IProjectile iProjectile = this;
            if (iProjectile instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)iProjectile;
                arrow.setOwner(owner, false);
            } else {
                this.c(owner);
            }
            this.b(deflector, fromAttack);
        }
        return true;
    }

    protected void b(@Nullable Entity deflector, boolean fromAttack) {
    }

    protected void b(Item item) {
    }

    protected void a(MovingObjectPosition hitResult) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = hitResult.d();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)hitResult;
            Entity entity = movingobjectpositionentity.a();
            if (entity.aq().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                iprojectile.a(ProjectileDeflection.c, this.p(), this.p(), true);
            }
            this.a(movingobjectpositionentity);
            this.dW().a(GameEvent.J, hitResult.g(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)hitResult;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.b();
            this.dW().a(GameEvent.J, blockposition, GameEvent.a.a(this, this.dW().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity entityHitResult) {
    }

    protected void a(MovingObjectPositionBlock blockHitResult) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.dW().a_(blockHitResult.b());
        iblockdata.a(this.dW(), iblockdata, blockHitResult, this);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
        if (this.O == 0.0f && this.N == 0.0f) {
            double d3 = Math.sqrt(x2 * x2 + z2 * z2);
            this.w((float)(MathHelper.d(y2, d3) * 57.2957763671875));
            this.v((float)(MathHelper.d(x2, z2) * 57.2957763671875));
            this.O = this.dO();
            this.N = this.dM();
            this.b(this.dB(), this.dD(), this.dH(), this.dM(), this.dO());
        }
    }

    public boolean b(Entity entity) {
        if (!entity.bG()) {
            return false;
        }
        Entity entity1 = this.p();
        if (entity1 instanceof EntityPlayer && entity instanceof EntityPlayer) {
            Player collided = (Player)entity.getBukkitEntity();
            Player shooter = (Player)entity1.getBukkitEntity();
            if (!shooter.canSee(collided)) {
                return false;
            }
        }
        return entity1 == null || this.c || !entity1.z(entity);
    }

    protected void F() {
        Vec3D vec3d = this.dz();
        double d0 = vec3d.i();
        this.w(IProjectile.f(this.O, (float)(MathHelper.d(vec3d.e, d0) * 57.2957763671875)));
        this.v(IProjectile.f(this.N, (float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875)));
    }

    protected static float f(float prevRot, float newRot) {
        prevRot += (float)Math.round((newRot - prevRot) / 360.0f) * 360.0f;
        return MathHelper.h(0.2f, prevRot, newRot);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        Entity entity = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, entity == null ? 0 : entity.ar());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Entity entity = this.dW().a(packet.p());
        if (entity != null) {
            this.c(entity);
        }
    }

    @Override
    public boolean c(WorldServer world, BlockPosition pos) {
        Entity entity = this.p();
        return entity instanceof EntityHuman ? entity.c(world, pos) : entity == null || world.N().b(GameRules.c);
    }

    public boolean a(WorldServer world) {
        return this.aq().a(TagsEntity.g) && world.N().b(GameRules.g);
    }

    @Override
    public boolean bH() {
        return this.aq().a(TagsEntity.H);
    }

    @Override
    public float bS() {
        return this.bH() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a_(EntityLiving target, DamageSource source) {
        double d0 = this.dz().d;
        double d1 = this.dz().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    @Override
    public int bX() {
        return 2;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (!this.d(source)) {
            this.bD();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }

    public record Delayed<T extends IProjectile>(T projectile, WorldServer world, ItemStack projectileStack) {
        public boolean attemptSpawn() {
            if (!this.world.b((Entity)this.projectile)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn() {
            this.attemptSpawn();
            return this.projectile();
        }

        public boolean attemptSpawn(CreatureSpawnEvent.SpawnReason reason) {
            if (!this.world.addFreshEntity((Entity)this.projectile, reason)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn(CreatureSpawnEvent.SpawnReason reason) {
            this.attemptSpawn(reason);
            return this.projectile();
        }
    }
}

