/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class ProjectileHelper {
    private static final float a = 0.3f;

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate) {
        Vec3D vec3 = entity.dz();
        World level = entity.dW();
        Vec3D vec32 = entity.du();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.3f, RayTrace.BlockCollisionOption.a);
    }

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate, RayTrace.BlockCollisionOption raycastShapeType) {
        Vec3D vec3 = entity.dz();
        World level = entity.dW();
        Vec3D vec32 = entity.du();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.3f, raycastShapeType);
    }

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate, double range) {
        Vec3D vec3 = entity.g(0.0f).c(range);
        World level = entity.dW();
        Vec3D vec32 = entity.bF();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.0f, RayTrace.BlockCollisionOption.a);
    }

    private static MovingObjectPosition a(Vec3D pos, Entity entity, Predicate<Entity> predicate, Vec3D velocity, World world, float margin, RayTrace.BlockCollisionOption raycastShapeType) {
        MovingObjectPositionEntity hitResult2;
        Vec3D vec3 = pos.e(velocity);
        MovingObjectPosition hitResult = world.b(new RayTrace(pos, vec3, raycastShapeType, RayTrace.FluidCollisionOption.a, entity));
        if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) {
            vec3 = hitResult.g();
        }
        if ((hitResult2 = ProjectileHelper.a(world, entity, pos, vec3, entity.cR().b(velocity).g(1.0), predicate, margin)) != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    @Nullable
    public static MovingObjectPositionEntity a(Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate, double maxDistance) {
        World level = entity.dW();
        double d2 = maxDistance;
        Entity entity2 = null;
        Vec3D vec3 = null;
        for (Entity entity3 : level.a(entity, box, predicate)) {
            Vec3D vec32;
            double e2;
            AxisAlignedBB aABB = entity3.cR().g(entity3.bS());
            Optional<Vec3D> optional = aABB.b(min, max);
            if (aABB.d(min)) {
                if (!(d2 >= 0.0)) continue;
                entity2 = entity3;
                vec3 = optional.orElse(min);
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((e2 = min.g(vec32 = optional.get())) < d2) && d2 != 0.0) continue;
            if (entity3.dg() == entity.dg()) {
                if (d2 != 0.0) continue;
                entity2 = entity3;
                vec3 = vec32;
                continue;
            }
            entity2 = entity3;
            vec3 = vec32;
            d2 = e2;
        }
        if (entity2 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(entity2, vec3);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World world, Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate) {
        return ProjectileHelper.a(world, entity, min, max, box, predicate, 0.3f);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World world, Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate, float margin) {
        double d2 = Double.MAX_VALUE;
        Optional<Object> optional = Optional.empty();
        Entity entity2 = null;
        for (Entity entity3 : world.a(entity, box, predicate)) {
            double e2;
            AxisAlignedBB aABB = entity3.cR().g(margin);
            Optional<Vec3D> optional2 = aABB.b(min, max);
            if (!optional2.isPresent() || !((e2 = min.g(optional2.get())) < d2)) continue;
            entity2 = entity3;
            d2 = e2;
            optional = optional2;
        }
        if (entity2 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(entity2, (Vec3D)optional.get());
    }

    public static void a(Entity entity, float delta) {
        Vec3D vec3 = entity.dz();
        if (vec3.h() == 0.0) {
            return;
        }
        double d2 = vec3.i();
        entity.v((float)(MathHelper.d(vec3.f, vec3.d) * 57.2957763671875) + 90.0f);
        entity.w((float)(MathHelper.d(d2, vec3.e) * 57.2957763671875) - 90.0f);
        while (entity.dO() - entity.O < -180.0f) {
            entity.O -= 360.0f;
        }
        while (entity.dO() - entity.O >= 180.0f) {
            entity.O += 360.0f;
        }
        while (entity.dM() - entity.N < -180.0f) {
            entity.N -= 360.0f;
        }
        while (entity.dM() - entity.N >= 180.0f) {
            entity.N += 360.0f;
        }
        entity.w(MathHelper.h(delta, entity.O, entity.dO()));
        entity.v(MathHelper.h(delta, entity.N, entity.dM()));
    }

    public static EnumHand a(EntityLiving entity, Item item) {
        return entity.eZ().a(item) ? EnumHand.a : EnumHand.b;
    }

    public static EntityArrow a(EntityLiving entity, ItemStack stack, float damageModifier, @Nullable ItemStack bow) {
        ItemArrow arrowItem = (ItemArrow)(stack.h() instanceof ItemArrow ? stack.h() : Items.oS);
        EntityArrow abstractArrow = arrowItem.a(entity.dW(), stack, entity, bow);
        abstractArrow.a(damageModifier);
        return abstractArrow;
    }
}

