/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindCharge
extends EntityFireball
implements ItemSupplier {
    public static final ExplosionDamageCalculator d = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.e.a(TagsBlock.cB).map(Function.identity()));
    public static final double e = 0.25;

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> type, World world) {
        super((EntityTypes<? extends EntityFireball>)type, world);
        this.c = 0.0;
    }

    public AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> type, World world, Entity owner, double x2, double y2, double z2) {
        super(type, x2, y2, z2, world);
        this.c(owner);
        this.c = 0.0;
    }

    AbstractWindCharge(EntityTypes<? extends AbstractWindCharge> type, double x2, double y2, double z2, Vec3D velocity, World world) {
        super(type, x2, y2, z2, velocity, world);
        this.c = 0.0;
    }

    @Override
    protected AxisAlignedBB ax() {
        float f2 = this.aq().n().a() / 2.0f;
        float f1 = this.aq().n().b();
        float f22 = 0.15f;
        return new AxisAlignedBB(this.du().d - (double)f2, this.du().e - (double)0.15f, this.du().f - (double)f2, this.du().d + (double)f2, this.du().e - (double)0.15f + (double)f1, this.du().f + (double)f2);
    }

    @Override
    public boolean i(Entity other) {
        return other instanceof AbstractWindCharge ? false : super.i(other);
    }

    @Override
    public boolean b(Entity entity) {
        return entity instanceof AbstractWindCharge ? false : (entity.aq() == EntityTypes.S ? false : super.b(entity));
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        World world = this.dW();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            EntityLiving entityliving1;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = this.p();
            EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
            EntityLiving entityliving2 = entityliving;
            Entity entity1 = entityHitResult.a();
            if (entityliving2 != null) {
                entityliving2.B(entity1);
            }
            if (entity1.a(worldserver, damagesource = this.dX().c((Entity)this, entityliving2), 1.0f) && entity1 instanceof EntityLiving) {
                EntityLiving entityliving3 = (EntityLiving)entity1;
                EnchantmentManager.a(worldserver, (Entity)entityliving3, damagesource);
            }
            this.a(this.du());
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
    }

    public abstract void a(Vec3D var1);

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        if (!this.dW().C) {
            BaseBlockPosition baseblockposition = blockHitResult.c().q();
            Vec3D vec3d = Vec3D.a(baseblockposition).d(0.25, 0.25, 0.25);
            Vec3D vec3d1 = blockHitResult.g().e(vec3d);
            this.a(vec3d1);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.dW().C) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected boolean m() {
        return false;
    }

    @Override
    public ItemStack l() {
        return ItemStack.j;
    }

    @Override
    protected float t() {
        return 1.0f;
    }

    @Override
    protected float u() {
        return this.t();
    }

    @Override
    @javax.annotation.Nullable
    protected ParticleParam s() {
        return null;
    }

    @Override
    public void h() {
        if (!this.dW().C && this.dC() > this.dW().am() + 30) {
            this.a(this.du());
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
        } else {
            super.h();
        }
    }
}

