/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> i = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> j = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.b);
    public static final int a = 0;
    public static final int b = 1;
    private static final int k = 60;
    private static final float l = 0.3926991f;
    public static final double c = 0.7853981852531433;
    public static final int d = 60;
    private final float[] m = new float[2];
    private float n;
    private float o;
    private float p;
    private int q;
    private double r;
    private double s;
    private double t;
    private double u;
    private double ay;
    private boolean az;
    private boolean aA;
    private boolean aB;
    private boolean aC;
    private double aD;
    private float aE;
    public EnumStatus aF;
    private EnumStatus aG;
    private double aH;
    private boolean aI;
    private boolean aJ;
    private float aK;
    private float aL;
    private float aM;
    @Nullable
    private Leashable.a aN;
    private final Supplier<Item> aO;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> type, World world, Supplier<Item> itemSupplier) {
        super(type, world);
        this.aO = itemSupplier;
        this.I = true;
    }

    public void p(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(h, false);
        builder.a(i, false);
        builder.a(j, 0);
    }

    @Override
    public boolean i(Entity other) {
        return AbstractBoat.a(this, other);
    }

    public static boolean a(Entity entity, Entity other) {
        return (other.bN() || other.bI()) && !entity.z(other);
    }

    @Override
    public boolean bN() {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.j(super.a(portalAxis, portalRect));
    }

    protected abstract double b(EntitySize var1);

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = this.s();
        if (this.cZ().size() > 1) {
            int i2 = this.cZ().indexOf(passenger);
            f1 = i2 == 0 ? 0.2f : -0.6f;
            if (passenger instanceof EntityAnimal) {
                f1 += 0.2f;
            }
        }
        return new Vec3D(0.0, this.b(dimensions), f1).b(-this.dM() * ((float)Math.PI / 180));
    }

    @Override
    public void l(boolean drag) {
        if (!this.dW().C) {
            this.aI = true;
            this.aJ = drag;
            if (this.K() == 0) {
                this.m(60);
            }
        }
        this.dW().a(Particles.an, this.dB() + (double)this.ae.i(), this.dD() + 0.7, this.dH() + (double)this.ae.i(), 0.0, 0.0, 0.0);
        if (this.ae.a(20) == 0) {
            this.dW().a(this.dB(), this.dD(), this.dH(), this.aW(), this.dn(), 1.0f, 0.8f + 0.4f * this.ae.i(), false);
            this.a(GameEvent.O, (Entity)this.cX());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.dW().paperConfig().collisions.allowVehicleCollisions && this.dW().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof AbstractBoat) {
            if (entity.cR().b < this.cR().e) {
                if (!this.z(entity)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                    this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.h(entity);
            }
        } else if (entity.cR().b <= this.cR().b) {
            if (!this.z(entity)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.h(entity);
        }
    }

    @Override
    public void p(float yaw) {
        this.l(-this.O());
        this.d(10);
        this.b(this.L() * 11.0f);
    }

    @Override
    public boolean bH() {
        return !this.dR();
    }

    @Override
    public void f_() {
        this.q = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.r = x2;
        this.s = y2;
        this.t = z2;
        this.u = yaw;
        this.ay = pitch;
        this.q = interpolationSteps;
    }

    @Override
    public double R_() {
        return this.q > 0 ? this.r : this.dB();
    }

    @Override
    public double S_() {
        return this.q > 0 ? this.s : this.dD();
    }

    @Override
    public double g_() {
        return this.q > 0 ? this.t : this.dH();
    }

    @Override
    public float r_() {
        return this.q > 0 ? (float)this.ay : this.dO();
    }

    @Override
    public float h_() {
        return this.q > 0 ? (float)this.u : this.dM();
    }

    @Override
    public EnumDirection cP() {
        return this.cO().h();
    }

    @Override
    public void h() {
        this.aG = this.aF;
        this.aF = this.F();
        this.o = this.aF != EnumStatus.b && this.aF != EnumStatus.c ? 0.0f : (this.o += 1.0f);
        if (!this.dW().C && this.o >= 60.0f) {
            this.bP();
        }
        if (this.N() > 0) {
            this.d(this.N() - 1);
        }
        if (this.L() > 0.0f) {
            this.b(this.L() - 1.0f);
        }
        super.h();
        this.E();
        if (this.di()) {
            if (!(this.da() instanceof EntityHuman)) {
                this.b(false, false);
            }
            this.I();
            if (this.dW().C) {
                this.J();
                this.dW().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dz());
        } else {
            this.h(Vec3D.c);
        }
        CraftServer server = this.dW().getCraftServer();
        CraftWorld bworld = this.dW().getWorld();
        Location to = CraftLocation.toBukkit(this.du(), (org.bukkit.World)bworld, this.dM(), this.dO());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.aK();
        this.aK();
        this.D();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect soundeffect;
                if (!this.bb() && (double)(this.m[i2] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.m[i2] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundeffect = this.l()) != null) {
                    Vec3D vec3d = this.g(1.0f);
                    double d0 = i2 == 1 ? -vec3d.f : vec3d.f;
                    double d1 = i2 == 1 ? vec3d.d : -vec3d.d;
                    this.dW().a((EntityHuman)null, this.dB() + d0, this.dD(), this.dH() + d1, soundeffect, this.dn(), 1.0f, 0.8f + 0.4f * this.ae.i());
                }
                int n2 = i2;
                this.m[n2] = this.m[n2] + 0.3926991f;
                continue;
            }
            this.m[i2] = 0.0f;
        }
        List<Entity> list = this.dW().a((Entity)this, this.cR().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.dW().C && !(this.cX() instanceof EntityHuman);
            for (Entity entity : list) {
                if (entity.y(this)) continue;
                if (flag && this.cZ().size() < this.t() && !entity.bZ() && this.b(entity) && entity instanceof EntityLiving && !(entity instanceof EntityWaterAnimal) && !(entity instanceof EntityHuman) && !(entity instanceof Creaking)) {
                    entity.n(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void D() {
        if (this.dW().C) {
            int i2 = this.K();
            this.aK = i2 > 0 ? (this.aK += 0.05f) : (this.aK -= 0.1f);
            this.aK = MathHelper.a(this.aK, 0.0f, 1.0f);
            this.aM = this.aL;
            this.aL = 10.0f * (float)Math.sin(0.5f * (float)this.dW().ac()) * this.aK;
        } else {
            int i3;
            if (!this.aI) {
                this.m(0);
            }
            if ((i3 = this.K()) > 0) {
                this.m(--i3);
                int j2 = 60 - i3 - 1;
                if (j2 > 0 && i3 == 0) {
                    this.m(0);
                    Vec3D vec3d = this.dz();
                    if (this.aJ) {
                        this.h(vec3d.b(0.0, -0.7, 0.0));
                        this.bP();
                    } else {
                        this.n(vec3d.d, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, vec3d.f);
                    }
                }
                this.aI = false;
            }
        }
    }

    @Nullable
    protected SoundEffect l() {
        switch (this.F().ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return SoundEffects.cm;
            }
            case 3: {
                return SoundEffects.cl;
            }
        }
        return null;
    }

    private void E() {
        if (this.q > 0) {
            this.a(this.q, this.r, this.s, this.t, this.u, this.ay);
            --this.q;
        }
    }

    public void b(boolean left, boolean right) {
        this.al.a(h, left);
        this.al.a(i, right);
    }

    public float a(int paddle, float tickDelta) {
        return this.c(paddle) ? MathHelper.b(this.m[paddle] - 0.3926991f, this.m[paddle], tickDelta) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a T_() {
        return this.aN;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.aN = leashData;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.88f * this.cS(), this.dr() * 0.64f);
    }

    @Override
    public void b(Entity leashHolder, float distance) {
        Vec3D vec3d = leashHolder.du().d(this.du()).d().c((double)distance - 6.0);
        Vec3D vec3d1 = this.dz();
        boolean flag = vec3d1.b(vec3d) > 0.0;
        this.h(vec3d1.e(vec3d.c(flag ? (double)0.15f : (double)0.2f)));
    }

    public EnumStatus F() {
        EnumStatus abstractboat_enumstatus = this.H();
        if (abstractboat_enumstatus != null) {
            this.aD = this.cR().e;
            return abstractboat_enumstatus;
        }
        if (this.G()) {
            return EnumStatus.a;
        }
        float f2 = this.p();
        if (f2 > 0.0f) {
            this.aE = f2;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float m() {
        AxisAlignedBB axisalignedbb = this.cR();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(axisalignedbb.e - this.aH);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (int k1 = k2; k1 < l2; ++k1) {
            float f2 = 0.0f;
            block1: for (int l1 = i2; l1 < j2; ++l1) {
                int i22 = i1;
                while (true) {
                    if (i22 >= j1) {
                        continue block1;
                    }
                    blockposition_mutableblockposition.d(l1, k1, i22);
                    Fluid fluid = this.dW().b_(blockposition_mutableblockposition);
                    if (fluid.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluid.a(this.dW(), blockposition_mutableblockposition));
                    }
                    if (f2 >= 1.0f) continue block0;
                    ++i22;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)blockposition_mutableblockposition.v() + f2;
        }
        return l2 + 1;
    }

    public float p() {
        AxisAlignedBB axisalignedbb = this.cR();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 0.001, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
        int i2 = MathHelper.a(axisalignedbb1.a) - 1;
        int j2 = MathHelper.c(axisalignedbb1.d) + 1;
        int k2 = MathHelper.a(axisalignedbb1.b) - 1;
        int l2 = MathHelper.c(axisalignedbb1.e) + 1;
        int i1 = MathHelper.a(axisalignedbb1.c) - 1;
        int j1 = MathHelper.c(axisalignedbb1.f) + 1;
        VoxelShape voxelshape = VoxelShapes.a(axisalignedbb1);
        float f2 = 0.0f;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = i1; i22 < j1; ++i22) {
                int j22 = (l1 != i2 && l1 != j2 - 1 ? 0 : 1) + (i22 != i1 && i22 != j1 - 1 ? 0 : 1);
                if (j22 == 2) continue;
                for (int k22 = k2; k22 < l2; ++k22) {
                    if (j22 > 0 && (k22 == k2 || k22 == l2 - 1)) continue;
                    blockposition_mutableblockposition.d(l1, k22, i22);
                    IBlockData iblockdata = this.dW().a_(blockposition_mutableblockposition);
                    if (iblockdata.b() instanceof BlockWaterLily || !VoxelShapes.c(iblockdata.g(this.dW(), blockposition_mutableblockposition).a(l1, (double)k22, (double)i22), voxelshape, OperatorBoolean.i)) continue;
                    f2 += iblockdata.b().g();
                    ++k1;
                }
            }
        }
        return f2 / (float)k1;
    }

    private boolean G() {
        AxisAlignedBB axisalignedbb = this.cR();
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.b + 0.001);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        this.aD = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dW().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a)) continue;
                    float f2 = (float)l1 + fluid.a(this.dW(), blockposition_mutableblockposition);
                    this.aD = Math.max((double)f2, this.aD);
                    flag |= axisalignedbb.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus H() {
        AxisAlignedBB axisalignedbb = this.cR();
        double d0 = axisalignedbb.e + 0.001;
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.e);
        int l2 = MathHelper.c(d0);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    blockposition_mutableblockposition.d(k1, l1, i22);
                    Fluid fluid = this.dW().b_(blockposition_mutableblockposition);
                    if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a(this.dW(), blockposition_mutableblockposition)))) continue;
                    if (!fluid.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    private void I() {
        double d0 = -this.be();
        double d1 = 0.0;
        this.n = 0.05f;
        if (this.aG == EnumStatus.e && this.aF != EnumStatus.e && this.aF != EnumStatus.d) {
            this.aD = this.e(1.0);
            double d2 = (double)(this.m() - this.ds()) + 0.101;
            if (this.dW().a((Entity)this, this.cR().d(0.0, d2 - this.dD(), 0.0))) {
                this.a(EnumMoveType.a, new Vec3D(0.0, d2 - this.dD(), 0.0));
                this.h(this.dz().d(1.0, 0.0, 1.0));
                this.aH = 0.0;
            }
            this.aF = EnumStatus.a;
        } else {
            if (this.aF == EnumStatus.a) {
                d1 = (this.aD - this.dD()) / (double)this.ds();
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.c) {
                d0 = -7.0E-4;
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.b) {
                d1 = 0.01f;
                this.n = 0.45f;
            } else if (this.aF == EnumStatus.e) {
                this.n = 0.9f;
            } else if (this.aF == EnumStatus.d) {
                this.n = this.aE;
                if (this.cX() instanceof EntityHuman) {
                    this.aE /= 2.0f;
                }
            }
            Vec3D vec3d = this.dz();
            this.n(vec3d.d * (double)this.n, vec3d.e + d0, vec3d.f * (double)this.n);
            this.p *= this.n;
            if (d1 > 0.0) {
                Vec3D vec3d1 = this.dz();
                this.n(vec3d1.d, (vec3d1.e + d1 * (this.bd() / 0.65)) * 0.75, vec3d1.f);
            }
        }
    }

    private void J() {
        if (this.ca()) {
            float f2 = 0.0f;
            if (this.az) {
                this.p -= 1.0f;
            }
            if (this.aA) {
                this.p += 1.0f;
            }
            if (this.aA != this.az && !this.aB && !this.aC) {
                f2 += 0.005f;
            }
            this.v(this.dM() + this.p);
            if (this.aB) {
                f2 += 0.04f;
            }
            if (this.aC) {
                f2 -= 0.005f;
            }
            this.h(this.dz().b(MathHelper.a(-this.dM() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dM() * ((float)Math.PI / 180)) * f2));
            this.b(this.aA && !this.az || this.aB, this.az && !this.aA || this.aB);
        }
    }

    protected float s() {
        return 0.0f;
    }

    public boolean b(Entity entity) {
        return entity.dr() < this.dr();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (!passenger.aq().a(TagsEntity.s)) {
            passenger.v(passenger.dM() + this.p);
            passenger.q(passenger.cA() + this.p);
            this.c(passenger);
            if (passenger instanceof EntityAnimal && this.cZ().size() == this.t()) {
                int i2 = passenger.ar() % 2 == 0 ? 90 : 270;
                passenger.r(((EntityAnimal)passenger).aX + (float)i2);
                passenger.q(passenger.cA() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = AbstractBoat.a(this.dr() * MathHelper.g, (double)passenger.dr(), passenger.dM());
        double d0 = this.dB() + vec3d.d;
        double d1 = this.dH() + vec3d.f;
        BlockPosition blockposition = BlockPosition.a(d0, this.cR().e, d1);
        BlockPosition blockposition1 = blockposition.e();
        if (!this.dW().z(blockposition1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.dW().j(blockposition);
            if (DismountUtil.a(d2)) {
                list.add(new Vec3D(d0, (double)blockposition.v() + d2, d1));
            }
            if (DismountUtil.a(d3 = this.dW().j(blockposition1))) {
                list.add(new Vec3D(d0, (double)blockposition1.v() + d3, d1));
            }
            for (EntityPose entitypose : passenger.fO()) {
                for (Vec3D vec3d1 : list) {
                    if (!DismountUtil.a(this.dW(), vec3d1, passenger, entitypose)) continue;
                    passenger.b(entitypose);
                    return vec3d1;
                }
            }
        }
        return super.b(passenger);
    }

    protected void c(Entity passenger) {
        passenger.r(this.dM());
        float f2 = MathHelper.h(passenger.dM() - this.dM());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        passenger.N += f1 - f2;
        passenger.v(passenger.dM() + f1 - f2);
        passenger.q(passenger.dM());
    }

    @Override
    public void k(Entity passenger) {
        this.c(passenger);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        this.a(nbt, this.aN);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.aN = this.c(nbt);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.a(player, hand);
        return enuminteractionresult != EnumInteractionResult.e ? enuminteractionresult : (EnumInteractionResult)((Object)(!player.fY() && this.o < 60.0f && (this.dW().C || player.n(this)) ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (!this.dW().C && entity_removalreason.a() && this.P_()) {
            this.a(true, true);
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        this.aH = this.dz().e;
        if (!this.bZ()) {
            if (onGround) {
                this.k();
            } else if (!this.dW().b_(this.dw().e()).a(TagsFluid.a) && heightDifference < 0.0) {
                this.Z -= (float)heightDifference;
            }
        }
    }

    public boolean c(int paddle) {
        return this.al.a(paddle == 0 ? h : i) != false && this.cX() != null;
    }

    private void m(int bubbleWobbleTicks) {
        this.al.a(j, bubbleWobbleTicks);
    }

    private int K() {
        return this.al.a(j);
    }

    public float a(float tickDelta) {
        return MathHelper.h(tickDelta, this.aM, this.aL);
    }

    @Override
    protected boolean r(Entity passenger) {
        return this.cZ().size() < this.t() && !this.a(TagsFluid.a);
    }

    protected int t() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving cX() {
        EntityLiving entityliving1;
        Entity entity = this.da();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : super.cX();
        return entityliving;
    }

    public void a(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.az = pressingLeft;
        this.aA = pressingRight;
        this.aB = pressingForward;
        this.aC = pressingBack;
    }

    @Override
    public boolean bo() {
        return this.aF == EnumStatus.b || this.aF == EnumStatus.c;
    }

    @Override
    public final Item u() {
        return this.aO.get();
    }

    @Override
    public final ItemStack dJ() {
        return new ItemStack(this.aO.get());
    }

    public static enum EnumStatus {
        a,
        b,
        c,
        d,
        e;

    }
}

