/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Map;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D b = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.k);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> i = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float a = 0.95f;
    private boolean j;
    private boolean k;
    private final MinecartBehavior l;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> m = SystemUtils.a(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.q();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.q();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.q();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.q();
        BaseBlockPosition baseblockposition4 = baseblockposition.p();
        BaseBlockPosition baseblockposition5 = baseblockposition1.p();
        BaseBlockPosition baseblockposition6 = baseblockposition2.p();
        BaseBlockPosition baseblockposition7 = baseblockposition3.p();
        enummap.put(BlockPropertyTrackPosition.a, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.b, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.c, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.d, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.e, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.f, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.g, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.h, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.i, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.j, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public Double maxSpeed;
    public TriState frictionState = TriState.NOT_SET;

    protected EntityMinecartAbstract(EntityTypes<?> type, World world) {
        super(type, world);
        this.I = true;
        this.l = EntityMinecartAbstract.b(world) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World world, double x2, double y2, double z2) {
        this(type, world);
        this.p(x2, y2, z2);
    }

    public void p(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.K = x2;
        this.L = y2;
        this.M = z2;
    }

    @Nullable
    public static <T extends EntityMinecartAbstract> T a(World world, double x2, double y2, double z2, EntityTypes<T> type, EntitySpawnReason reason, ItemStack stack, @Nullable EntityHuman player) {
        EntityMinecartAbstract t0 = (EntityMinecartAbstract)type.a(world, reason);
        if (t0 != null) {
            t0.p(x2, y2, z2);
            EntityTypes.a(world, stack, player).accept(t0);
            MinecartBehavior minecartbehavior = t0.l();
            if (minecartbehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                BlockPosition blockposition = t0.p();
                IBlockData iblockdata = world.a_(blockposition);
                newminecartbehavior.a(blockposition, iblockdata, true);
            }
        }
        return (T)t0;
    }

    public MinecartBehavior l() {
        return this.l;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, Block.j(Blocks.a.m()));
        builder.a(d, 6);
        builder.a(h, false);
    }

    @Override
    public boolean i(Entity other) {
        boolean collides = AbstractBoat.a(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.j(super.a(portalAxis, portalRect));
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        boolean flag = passenger instanceof EntityVillager || passenger instanceof EntityVillagerTrader;
        return flag ? b : super.a(passenger, dimensions, scaleFactor);
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cP();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dw();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = passenger.fO();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = passenger.a(entitypose);
            float f2 = Math.min(entitysize.a(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)i.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v() + i2, blockposition.w() + aint2[1]);
                    double d0 = this.dW().a(DismountUtil.a((IBlockAccess)this.dW(), (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.dW(), blockposition_mutableblockposition.e()));
                    if (!DismountUtil.a(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b(), f2);
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.a(this.dW(), passenger, axisalignedbb.c(vec3d))) continue;
                    passenger.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cR().e;
        blockposition_mutableblockposition.b((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            int l2;
            double d3;
            double d2 = passenger.a(entitypose1).b();
            if (!(d1 + d2 <= (d3 = DismountUtil.a(blockposition_mutableblockposition, l2 = MathHelper.c(d1 - (double)blockposition_mutableblockposition.v() + d2), (BlockPosition blockposition1) -> this.dW().a_((BlockPosition)blockposition1).g(this.dW(), (BlockPosition)blockposition1))))) continue;
            passenger.b(entitypose1);
            break;
        }
        return super.b(passenger);
    }

    @Override
    protected float aT() {
        IBlockData iblockdata = this.dW().a_(this.dw());
        return iblockdata.a(TagsBlock.P) ? 1.0f : super.aT();
    }

    @Override
    public void p(float yaw) {
        this.l(-this.O());
        this.d(10);
        this.b(this.L() + this.L() * 10.0f);
    }

    @Override
    public boolean bH() {
        return !this.dR();
    }

    public static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return m.get(shape);
    }

    @Override
    public EnumDirection cP() {
        return this.l.q();
    }

    @Override
    protected double bd() {
        return this.bj() ? 0.005 : 0.04;
    }

    @Override
    public void h() {
        double prevX = this.dB();
        double prevY = this.dD();
        double prevZ = this.dH();
        float prevYaw = this.dM();
        float prevPitch = this.dO();
        if (this.N() > 0) {
            this.d(this.N() - 1);
        }
        if (this.L() > 0.0f) {
            this.b(this.L() - 1.0f);
        }
        this.aA();
        this.l.g();
        CraftWorld bworld = this.dW().getWorld();
        Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.du(), (org.bukkit.World)bworld, this.dM(), this.dO());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        this.dW().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (!from.equals((Object)to)) {
            this.dW().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
        }
        this.bq();
        if (this.bx()) {
            this.aE();
            this.Z *= 0.5f;
        }
        this.ak = false;
    }

    public boolean m() {
        return this.ak;
    }

    public BlockPosition p() {
        int i2 = MathHelper.a(this.dB());
        int j2 = MathHelper.a(this.dD());
        int k2 = MathHelper.a(this.dH());
        if (EntityMinecartAbstract.b(this.dW())) {
            double d0 = this.dD() - 0.1 - (double)1.0E-5f;
            if (this.dW().a_(BlockPosition.a((double)i2, d0, (double)k2)).a(TagsBlock.P)) {
                j2 = MathHelper.a(d0);
            }
        } else if (this.dW().a_(new BlockPosition(i2, j2 - 1, k2)).a(TagsBlock.P)) {
            --j2;
        }
        return new BlockPosition(i2, j2, k2);
    }

    protected double a(WorldServer world) {
        return this.l.b(world);
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    @Override
    public void a(int step, double x2, double y2, double z2, double yaw, double pitch) {
        super.a(step, x2, y2, z2, yaw, pitch);
    }

    @Override
    public void bf() {
        super.bf();
    }

    @Override
    public void ay() {
        super.ay();
    }

    @Override
    public boolean bq() {
        return super.bq();
    }

    @Override
    public Vec3D ah() {
        return this.l.c(super.ah());
    }

    @Override
    public void f_() {
        this.l.a();
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.l.a(x2, y2, z2, yaw, pitch, interpolationSteps);
    }

    @Override
    public double R_() {
        return this.l.b();
    }

    @Override
    public double S_() {
        return this.l.c();
    }

    @Override
    public double g_() {
        return this.l.d();
    }

    @Override
    public float r_() {
        return this.l.e();
    }

    @Override
    public float h_() {
        return this.l.f();
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.l.a(x2, y2, z2);
    }

    protected void b(WorldServer world) {
        this.l.a(world);
    }

    protected void e(WorldServer world) {
        double d0 = this.a(world);
        Vec3D vec3d = this.dz();
        this.n(MathHelper.a(vec3d.d, -d0, d0), vec3d.e, MathHelper.a(vec3d.f, -d0, d0));
        if (this.aJ()) {
            this.h(new Vec3D(this.dz().d * this.derailedX, this.dz().e * this.derailedY, this.dz().f * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dz());
        if (!this.aJ()) {
            this.h(new Vec3D(this.dz().d * this.flyingX, this.dz().e * this.flyingY, this.dz().f * this.flyingZ));
        }
    }

    protected double a(BlockPosition pos, BlockPropertyTrackPosition shape, double remainingMovement) {
        return this.l.a(pos, shape, remainingMovement);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (EntityMinecartAbstract.b(this.dW())) {
            Vec3D vec3d1 = this.du().e(movement);
            super.a(type, movement);
            boolean flag = this.l.i();
            if (flag) {
                super.a(type, vec3d1.d(this.du()));
            }
            if (type.equals((Object)EnumMoveType.c)) {
                this.j = false;
            }
        } else {
            super.a(type, movement);
            this.aK();
        }
    }

    @Override
    public void aK() {
        if (!EntityMinecartAbstract.b(this.dW())) {
            this.a(this.du(), this.du());
        } else {
            super.aK();
        }
    }

    @Override
    public boolean cq() {
        return this.j;
    }

    public void a(boolean onRail) {
        this.j = onRail;
    }

    public boolean s() {
        return this.k;
    }

    public void b(boolean yawFlipped) {
        this.k = yawFlipped;
    }

    public Vec3D a(BlockPosition railPos) {
        IBlockData iblockdata = this.dW().a_(railPos);
        if (iblockdata.a(Blocks.bw) && iblockdata.c(BlockPoweredRail.f).booleanValue()) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).c());
            if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                if (this.b(railPos.h())) {
                    return new Vec3D(1.0, 0.0, 0.0);
                }
                if (this.b(railPos.i())) {
                    return new Vec3D(-1.0, 0.0, 0.0);
                }
            } else if (blockpropertytrackposition == BlockPropertyTrackPosition.a) {
                if (this.b(railPos.f())) {
                    return new Vec3D(0.0, 0.0, 1.0);
                }
                if (this.b(railPos.g())) {
                    return new Vec3D(0.0, 0.0, -1.0);
                }
            }
            return Vec3D.c;
        }
        return Vec3D.c;
    }

    public boolean b(BlockPosition pos) {
        return this.dW().a_(pos).d(this.dW(), pos);
    }

    protected Vec3D a(Vec3D velocity) {
        double d0 = this.l.r();
        Vec3D vec3d1 = velocity.d(d0, 0.0, d0);
        if (this.bj()) {
            vec3d1 = vec3d1.c((double)0.95f);
        }
        return vec3d1;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.q("CustomDisplayTile")) {
            this.c(GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p("DisplayState")));
            this.c(nbt.h("DisplayOffset"));
        }
        this.k = nbt.q("FlippedRotation");
        this.ak = nbt.q("HasTicked");
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.A()) {
            nbt.a("CustomDisplayTile", true);
            nbt.a("DisplayState", GameProfileSerializer.a(this.t()));
            nbt.a("DisplayOffset", this.y());
        }
        nbt.a("FlippedRotation", this.k);
        nbt.a("HasTicked", this.ak);
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!(this.dW().C || entity.ad || this.ad)) {
            if (!this.dW().paperConfig().collisions.allowVehicleCollisions && this.dW().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.y(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.dW().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.dB() - this.dB();
                double d2 = d0 * d0 + (d1 = entity.dH() - this.dH()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        EntityMinecartAbstract entityminecartabstract = (EntityMinecartAbstract)entity;
                        this.a(entityminecartabstract, d0, d1);
                    } else {
                        this.j(-d0, 0.0, -d1);
                        entity.j(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    private void a(EntityMinecartAbstract entity, double xDiff, double zDiff) {
        double d3;
        double d2;
        if (EntityMinecartAbstract.b(this.dW())) {
            d2 = this.dz().d;
            d3 = this.dz().f;
        } else {
            d2 = entity.dB() - this.dB();
            d3 = entity.dH() - this.dH();
        }
        Vec3D vec3d = new Vec3D(d2, 0.0, d3).d();
        Vec3D vec3d1 = new Vec3D(MathHelper.b(this.dM() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dM() * ((float)Math.PI / 180))).d();
        double d4 = Math.abs(vec3d.b(vec3d1));
        if (d4 >= (double)0.8f || EntityMinecartAbstract.b(this.dW())) {
            Vec3D vec3d2 = this.dz();
            Vec3D vec3d3 = entity.dz();
            if (entity.E() && !this.E()) {
                this.h(vec3d2.d(0.2, 1.0, 0.2));
                this.j(vec3d3.d - xDiff, 0.0, vec3d3.f - zDiff);
                entity.h(vec3d3.d(0.95, 1.0, 0.95));
            } else if (!entity.E() && this.E()) {
                entity.h(vec3d3.d(0.2, 1.0, 0.2));
                entity.j(vec3d2.d + xDiff, 0.0, vec3d2.f + zDiff);
                this.h(vec3d2.d(0.95, 1.0, 0.95));
            } else {
                double d5 = (vec3d3.d + vec3d2.d) / 2.0;
                double d6 = (vec3d3.f + vec3d2.f) / 2.0;
                this.h(vec3d2.d(0.2, 1.0, 0.2));
                this.j(d5 - xDiff, 0.0, d6 - zDiff);
                entity.h(vec3d3.d(0.2, 1.0, 0.2));
                entity.j(d5 + xDiff, 0.0, d6 + zDiff);
            }
        }
    }

    public IBlockData t() {
        return !this.A() ? this.w() : Block.a(this.au().a(c));
    }

    public IBlockData w() {
        return Blocks.a.m();
    }

    public int y() {
        return !this.A() ? this.z() : this.au().a(d).intValue();
    }

    public int z() {
        return 6;
    }

    public void c(IBlockData state) {
        this.au().a(c, Block.j(state));
        this.r(true);
    }

    public void c(int offset) {
        this.au().a(d, offset);
        this.r(true);
    }

    public boolean A() {
        return this.au().a(h);
    }

    public void r(boolean present) {
        this.au().a(h, present);
    }

    public static boolean b(World world) {
        return world.J().b(FeatureFlags.e);
    }

    @Override
    public abstract ItemStack dJ();

    public boolean D() {
        return false;
    }

    public boolean E() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public Item publicGetDropItem() {
        return this.u();
    }
}

