/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte b = 10;
    private static final String c = "explosion_power";
    private static final float d = 4.0f;
    public int h = -1;
    public float i = 4.0f;
    public boolean isIncendiary = false;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> type, World world) {
        super(type, world);
    }

    @Override
    public IBlockData w() {
        return Blocks.cr.m();
    }

    @Override
    public void h() {
        double d0;
        super.h();
        if (this.h > 0) {
            if (this.dW().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dD() > (double)v2)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.h;
            this.dW().a(Particles.af, this.dB(), this.dD() + 0.5, this.dH(), 0.0, 0.0, 0.0);
        } else if (this.h == 0) {
            this.h(this.dz().j());
        }
        if (this.P && (d0 = this.dz().j()) >= (double)0.01f) {
            this.h(d0);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        EntityArrow entityarrow;
        Entity entity = source.c();
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).bY()) {
            DamageSource damagesource1 = this.dX().d(this, source.d());
            this.a(damagesource1, entityarrow.dz().h());
        }
        return super.a(world, source, amount);
    }

    @Override
    public void a(WorldServer world, DamageSource damageSource) {
        double d0 = this.dz().j();
        if (!EntityMinecartTNT.e(damageSource) && d0 < (double)0.01f) {
            this.a(world, this.u());
        } else if (this.h < 0) {
            this.v();
            this.h = this.ae.a(20) + this.ae.a(20);
        }
    }

    @Override
    protected Item u() {
        return Items.oi;
    }

    @Override
    public ItemStack dJ() {
        return new ItemStack(Items.oi);
    }

    public void h(double power) {
        this.a((DamageSource)null, power);
    }

    protected void a(@Nullable DamageSource damageSource, double power) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            double d1 = Math.min(Math.sqrt(power), 5.0);
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.i + this.ae.j() * 1.5 * d1), this.isIncendiary);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.h = -1;
                return;
            }
            worldserver.a(this, damageSource, null, this.dB(), this.dD(), this.dH(), event.getRadius(), event.getFire(), World.a.d);
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0f) {
            float f2 = fallDistance / 10.0f;
            this.h((double)(f2 * f2));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void a(int x2, int y2, int z2, boolean powered) {
        if (powered && this.h < 0) {
            this.v();
        }
    }

    @Override
    public void b(byte status) {
        if (status == 10) {
            this.v();
        } else {
            super.b(status);
        }
    }

    public void v() {
        this.h = 80;
        if (!this.dW().C) {
            this.dW().a((Entity)this, (byte)10);
            if (!this.bb()) {
                this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.zX, SoundCategory.e, 1.0f, 1.0f);
            }
        }
    }

    public int x() {
        return this.h;
    }

    public boolean B() {
        return this.h > -1;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return this.B() && (blockState.a(TagsBlock.P) || world.a_(pos.d()).a(TagsBlock.P)) ? 0.0f : super.a(explosion, world, pos, blockState, fluidState, max);
    }

    @Override
    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return this.B() && (state.a(TagsBlock.P) || world.a_(pos.d()).a(TagsBlock.P)) ? false : super.a(explosion, world, pos, state, explosionPower);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("TNTFuse", 99)) {
            this.h = nbt.h("TNTFuse");
        }
        if (nbt.b(c, 99)) {
            this.i = MathHelper.a(nbt.j(c), 0.0f, 128.0f);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("TNTFuse", this.h);
        if (this.i != 4.0f) {
            nbt.a(c, this.i);
        }
    }

    @Override
    boolean a(DamageSource source) {
        return EntityMinecartTNT.e(source);
    }

    private static boolean e(DamageSource source) {
        return source.a(DamageTypeTags.i) || source.a(DamageTypeTags.l);
    }
}

