/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagUniverse;

public final class FeatureFlagSet {
    private static final FeatureFlagSet b = new FeatureFlagSet(null, 0L);
    public static final int a = 64;
    @Nullable
    private final FeatureFlagUniverse c;
    private final long d;

    private FeatureFlagSet(@Nullable FeatureFlagUniverse universe, long featuresMask) {
        this.c = universe;
        this.d = featuresMask;
    }

    static FeatureFlagSet a(FeatureFlagUniverse universe, Collection<FeatureFlag> features) {
        if (features.isEmpty()) {
            return b;
        }
        long l2 = FeatureFlagSet.a(universe, 0L, features);
        return new FeatureFlagSet(universe, l2);
    }

    public static FeatureFlagSet a() {
        return b;
    }

    public static FeatureFlagSet a(FeatureFlag feature) {
        return new FeatureFlagSet(feature.a, feature.b);
    }

    public static FeatureFlagSet a(FeatureFlag feature1, FeatureFlag ... features) {
        long l2 = features.length == 0 ? feature1.b : FeatureFlagSet.a(feature1.a, feature1.b, Arrays.asList(features));
        return new FeatureFlagSet(feature1.a, l2);
    }

    private static long a(FeatureFlagUniverse universe, long featuresMask, Iterable<FeatureFlag> newFeatures) {
        for (FeatureFlag featureFlag : newFeatures) {
            if (universe != featureFlag.a) {
                throw new IllegalStateException("Mismatched feature universe, expected '" + String.valueOf(universe) + "', but got '" + String.valueOf(featureFlag.a) + "'");
            }
            featuresMask |= featureFlag.b;
        }
        return featuresMask;
    }

    public boolean b(FeatureFlag feature) {
        if (this.c != feature.a) {
            return false;
        }
        return (this.d & feature.b) != 0L;
    }

    public boolean b() {
        return this.equals(b);
    }

    public boolean a(FeatureFlagSet features) {
        if (this.c == null) {
            return true;
        }
        if (this.c != features.c) {
            return false;
        }
        return (this.d & (features.d ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public boolean b(FeatureFlagSet features) {
        if (this.c == null || features.c == null || this.c != features.c) {
            return false;
        }
        return (this.d & features.d) != 0L;
    }

    public FeatureFlagSet c(FeatureFlagSet features) {
        if (this.c == null) {
            return features;
        }
        if (features.c == null) {
            return this;
        }
        if (this.c != features.c) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.c) + "' != '" + String.valueOf(features.c) + "'");
        }
        return new FeatureFlagSet(this.c, this.d | features.d);
    }

    public FeatureFlagSet d(FeatureFlagSet features) {
        if (this.c == null || features.c == null) {
            return this;
        }
        if (this.c != features.c) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.c) + "' != '" + String.valueOf(features.c) + "'");
        }
        long l2 = this.d & (features.d ^ 0xFFFFFFFFFFFFFFFFL);
        if (l2 == 0L) {
            return b;
        }
        return new FeatureFlagSet(this.c, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FeatureFlagSet)) return false;
        FeatureFlagSet featureFlagSet = (FeatureFlagSet)object;
        if (this.c != featureFlagSet.c) return false;
        if (this.d != featureFlagSet.d) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return (int)HashCommon.mix((long)this.d);
    }
}

