/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.level.World;

public final class FoodInfo
extends Record
implements ConsumableListener {
    private final int c;
    private final float d;
    private final boolean e;
    public static final Codec<FoodInfo> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.l.fieldOf("nutrition").forGetter(FoodInfo::a), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodInfo::b), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodInfo::c)).apply((Applicative)instance, FoodInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodInfo> b = StreamCodec.a(ByteBufCodecs.h, FoodInfo::a, ByteBufCodecs.l, FoodInfo::b, ByteBufCodecs.b, FoodInfo::c, FoodInfo::new);

    public FoodInfo(int nutrition, float saturation, boolean canAlwaysEat) {
        this.c = nutrition;
        this.d = saturation;
        this.e = canAlwaysEat;
    }

    @Override
    public void a(World world, EntityLiving user, ItemStack stack, Consumable consumable) {
        RandomSource randomsource = user.dZ();
        world.a((EntityHuman)null, user.dB(), user.dD(), user.dH(), consumable.e().a(), SoundCategory.g, 1.0f, randomsource.a(1.0f, 0.4f));
        if (user instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)user;
            entityhuman.gt().eat(this, stack, (EntityPlayer)entityhuman);
            world.a((EntityHuman)null, entityhuman.dB(), entityhuman.dD(), entityhuman.dH(), SoundEffects.uD, SoundCategory.h, 0.5f, MathHelper.b(randomsource, 0.9f, 1.0f));
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FoodInfo.class, "nutrition;saturation;canAlwaysEat", "c", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FoodInfo.class, "nutrition;saturation;canAlwaysEat", "c", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FoodInfo.class, "nutrition;saturation;canAlwaysEat", "c", "d", "e"}, this, o2);
    }

    public int a() {
        return this.c;
    }

    public float b() {
        return this.d;
    }

    public boolean c() {
        return this.e;
    }

    public static class a {
        private int a;
        private float b;
        private boolean c;

        public a a(int nutrition) {
            this.a = nutrition;
            return this;
        }

        public a a(float saturationModifier) {
            this.b = saturationModifier;
            return this;
        }

        public a a() {
            this.c = true;
            return this;
        }

        public FoodInfo b() {
            float f2 = FoodConstants.a(this.a, this.b);
            return new FoodInfo(this.a, f2, this.c);
        }
    }
}

