/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodMetaData {
    public int a = 20;
    public float b = 5.0f;
    public float c;
    private int d;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    private void b(int nutrition, float saturation) {
        this.a = MathHelper.a(nutrition + this.a, 0, 20);
        this.b = MathHelper.a(saturation + this.b, 0.0f, (float)this.a);
    }

    public void a(int food, float saturationModifier) {
        this.b(food, FoodConstants.a(food, saturationModifier));
    }

    public void a(FoodInfo foodComponent) {
        this.b(foodComponent.a(), foodComponent.b());
    }

    public void eat(FoodInfo foodinfo, ItemStack itemstack, EntityPlayer entityplayer) {
        int oldFoodLevel = this.a;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityplayer, foodinfo.a() + oldFoodLevel, itemstack);
        if (!event.isCancelled()) {
            this.b(event.getFoodLevel() - oldFoodLevel, foodinfo.b());
        }
        entityplayer.getBukkitEntity().sendHealthUpdate();
    }

    public void a(EntityPlayer player) {
        boolean flag;
        WorldServer worldserver = player.y();
        EnumDifficulty enumdifficulty = worldserver.al();
        if (this.c > 4.0f) {
            this.c -= 4.0f;
            if (this.b > 0.0f) {
                this.b = Math.max(this.b - 1.0f, 0.0f);
            } else if (enumdifficulty != EnumDifficulty.a) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(player, Math.max(this.a - 1, 0));
                if (!event.isCancelled()) {
                    this.a = event.getFoodLevel();
                }
                player.f.b(new PacketPlayOutUpdateHealth(player.getBukkitEntity().getScaledHealth(), this.a, this.b));
            }
        }
        if ((flag = worldserver.N().b(GameRules.k)) && this.b > 0.0f && player.gu() && this.a >= 20) {
            ++this.d;
            if (this.d >= this.saturatedRegenRate) {
                float f2 = Math.min(this.b, 6.0f);
                player.heal(f2 / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED, true);
                player.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.d = 0;
            }
        } else if (flag && this.a >= 18 && player.gu()) {
            ++this.d;
            if (this.d >= this.unsaturatedRegenRate) {
                player.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                player.causeFoodExhaustion(player.dW().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.d = 0;
            }
        } else if (this.a <= 0) {
            ++this.d;
            if (this.d >= this.starvationRate) {
                if (player.eE() > 10.0f || enumdifficulty == EnumDifficulty.d || player.eE() > 1.0f && enumdifficulty == EnumDifficulty.c) {
                    player.a(worldserver, player.dX().j(), 1.0f);
                }
                this.d = 0;
            }
        } else {
            this.d = 0;
        }
    }

    public void a(NBTTagCompound nbt) {
        if (nbt.b("foodLevel", 99)) {
            this.a = nbt.h("foodLevel");
            this.d = nbt.h("foodTickTimer");
            this.b = nbt.j("foodSaturationLevel");
            this.c = nbt.j("foodExhaustionLevel");
        }
    }

    public void b(NBTTagCompound nbt) {
        nbt.a("foodLevel", this.a);
        nbt.a("foodTickTimer", this.d);
        nbt.a("foodSaturationLevel", this.b);
        nbt.a("foodExhaustionLevel", this.c);
    }

    public int a() {
        return this.a;
    }

    public boolean b() {
        return this.a < 20;
    }

    public void a(float exhaustion) {
        this.c = Math.min(this.c + exhaustion, 40.0f);
    }

    public float c() {
        return this.b;
    }

    public void a(int foodLevel) {
        this.a = foodLevel;
    }

    public void b(float saturationLevel) {
        this.b = saturationLevel;
    }
}

