/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger m = LogUtils.getLogger();
    public static final int a = -999;
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 0;
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = Integer.MAX_VALUE;
    public static final int i = 9;
    public static final int j = 18;
    public NonNullList<net.minecraft.world.item.ItemStack> n = NonNullList.a();
    public NonNullList<Slot> k = NonNullList.a();
    public List<ContainerProperty> o = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack p = net.minecraft.world.item.ItemStack.j;
    public NonNullList<net.minecraft.world.item.ItemStack> q = NonNullList.a();
    public IntList r = new IntArrayList();
    private net.minecraft.world.item.ItemStack s = net.minecraft.world.item.ItemStack.j;
    private int t;
    @Nullable
    private final Containers<?> u;
    public final int l;
    public int v = -1;
    public int w;
    public final Set<Slot> x = Sets.newHashSet();
    private final List<ICrafting> y = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer z;
    private boolean A;
    public boolean checkReachable = true;
    private IChatBaseComponent title;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        if (this.title == null) {
            return IChatBaseComponent.b("");
        }
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    protected Container(@Nullable Containers<?> type, int syncId) {
        this.u = type;
        this.l = syncId;
    }

    protected void a(IInventory playerInventory, int left, int y2) {
        for (int k2 = 0; k2 < 9; ++k2) {
            this.a(new Slot(playerInventory, k2, left + k2 * 18, y2));
        }
    }

    protected void b(IInventory playerInventory, int left, int top) {
        for (int k2 = 0; k2 < 3; ++k2) {
            for (int l2 = 0; l2 < 9; ++l2) {
                this.a(new Slot(playerInventory, l2 + (k2 + 1) * 9, left + l2 * 18, top + k2 * 18));
            }
        }
    }

    protected void c(IInventory playerInventory, int left, int top) {
        this.b(playerInventory, left, top);
        boolean flag = true;
        boolean flag1 = true;
        this.a(playerInventory, left, top + 58);
    }

    protected static boolean a(ContainerAccess context, EntityHuman player, Block block) {
        return context.a((World world, BlockPosition blockposition) -> !world.a_((BlockPosition)blockposition).a(block) ? false : player.a((BlockPosition)blockposition, 4.0), true);
    }

    public Containers<?> a() {
        if (this.u == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.u;
    }

    protected static void a(IInventory inventory, int expectedSize) {
        int j2 = inventory.b();
        if (j2 < expectedSize) {
            throw new IllegalArgumentException("Container size " + j2 + " is smaller than expected " + expectedSize);
        }
    }

    protected static void a(IContainerProperties data, int expectedCount) {
        int j2 = data.a();
        if (j2 < expectedCount) {
            throw new IllegalArgumentException("Container data count " + j2 + " is smaller than expected " + expectedCount);
        }
    }

    public boolean a(int slot) {
        return slot == -1 || slot == -999 || slot < this.k.size();
    }

    protected Slot a(Slot slot) {
        slot.d = this.k.size();
        this.k.add(slot);
        this.n.add(net.minecraft.world.item.ItemStack.j);
        this.q.add(net.minecraft.world.item.ItemStack.j);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty property) {
        this.o.add(property);
        this.r.add(0);
        return property;
    }

    protected void a(IContainerProperties propertyDelegate) {
        for (int i2 = 0; i2 < propertyDelegate.a(); ++i2) {
            this.a(ContainerProperty.a(propertyDelegate, i2));
        }
    }

    public void a(ICrafting listener) {
        if (!this.y.contains(listener)) {
            this.y.add(listener);
            this.d();
        }
    }

    public void a(ContainerSynchronizer handler) {
        this.z = handler;
        this.b();
    }

    public void b() {
        int i2;
        int j2 = this.k.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.q.set(i2, this.k.get(i2).g().v());
        }
        this.s = this.g().v();
        j2 = this.o.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.r.set(i2, this.o.get(i2).b());
        }
        if (this.z != null) {
            this.z.a(this, this.q, this.s, this.r.toIntArray());
            this.z.sendOffHandSlotChange();
        }
    }

    public void broadcastCarriedItem() {
        this.s = this.g().v();
        if (this.z != null) {
            this.z.a(this, this.s);
        }
    }

    public void b(ICrafting listener) {
        this.y.remove(listener);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.a();
        for (Slot slot : this.k) {
            nonnulllist.add(slot.g());
        }
        return nonnulllist;
    }

    public void d() {
        int i2;
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::v);
            this.a(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.b(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.l();
        for (i2 = 0; i2 < this.o.size(); ++i2) {
            ContainerProperty containerproperty = this.o.get(i2);
            int j2 = containerproperty.b();
            if (containerproperty.c()) {
                this.d(i2, j2);
            }
            this.e(i2, j2);
        }
    }

    public void e() {
        int i2;
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            Objects.requireNonNull(itemstack);
            this.a(i2, itemstack, itemstack::v);
        }
        for (i2 = 0; i2 < this.o.size(); ++i2) {
            ContainerProperty containerproperty = this.o.get(i2);
            if (!containerproperty.c()) continue;
            this.d(i2, containerproperty.b());
        }
        this.b();
    }

    private void d(int index, int value) {
        for (ICrafting icrafting : this.y) {
            icrafting.a(this, index, value);
        }
    }

    private void a(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.n.get(slot);
        if (!net.minecraft.world.item.ItemStack.a(itemstack1, stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.n.set(slot, itemstack2);
            for (ICrafting icrafting : this.y) {
                icrafting.slotChanged(this, slot, itemstack1, itemstack2);
            }
        }
    }

    private void b(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1;
        if (!this.A && !net.minecraft.world.item.ItemStack.a(itemstack1 = this.q.get(slot), stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.q.set(slot, itemstack2);
            if (this.z != null) {
                this.z.a(this, slot, itemstack2);
            }
        }
    }

    private void e(int id, int value) {
        int k2;
        if (!this.A && (k2 = this.r.getInt(id)) != value) {
            this.r.set(id, value);
            if (this.z != null) {
                this.z.a(this, id, value);
            }
        }
    }

    private void l() {
        if (!this.A && !net.minecraft.world.item.ItemStack.a(this.g(), this.s)) {
            this.s = this.g().v();
            if (this.z != null) {
                this.z.a(this, this.s);
            }
        }
    }

    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        this.q.set(slot, stack.v());
    }

    public void b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot >= 0 && slot < this.q.size()) {
            this.q.set(slot, stack);
        } else {
            m.debug("Incorrect slot index: {} available slots: {}", (Object)slot, (Object)this.q.size());
        }
    }

    public void a(net.minecraft.world.item.ItemStack stack) {
        this.s = stack.v();
    }

    public boolean a(EntityHuman player, int id) {
        return false;
    }

    public Slot b(int index) {
        return this.k.get(index);
    }

    public abstract net.minecraft.world.item.ItemStack b(EntityHuman var1, int var2);

    public void a(int slot, int selectedStack) {
        if (slot >= 0 && slot < this.k.size()) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(slot).g();
            BundleItem.a(itemstack, selectedStack);
        }
    }

    public void a(int slotIndex, int button, InventoryClickType actionType, EntityHuman player) {
        try {
            this.b(slotIndex, button, actionType, player);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Container click");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Click info");
            crashreportsystemdetails.a("Menu Type", () -> this.u != null ? BuiltInRegistries.p.b(this.u).toString() : "<no type>");
            crashreportsystemdetails.a("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.a("Slot Count", this.k.size());
            crashreportsystemdetails.a("Slot", slotIndex);
            crashreportsystemdetails.a("Button", button);
            crashreportsystemdetails.a("Type", (Object)actionType);
            throw new ReportedException(crashreport);
        }
    }

    private void b(int slotIndex, int button, InventoryClickType actionType, EntityHuman player) {
        block47: {
            block60: {
                int k2;
                block59: {
                    block55: {
                        net.minecraft.world.item.ItemStack itemstack;
                        Slot slot;
                        net.minecraft.world.item.ItemStack itemstack42;
                        PlayerInventory playerinventory;
                        block58: {
                            block57: {
                                block56: {
                                    block52: {
                                        ClickAction clickaction;
                                        block54: {
                                            block53: {
                                                block51: {
                                                    block45: {
                                                        block50: {
                                                            net.minecraft.world.item.ItemStack itemstack2;
                                                            block49: {
                                                                block48: {
                                                                    block46: {
                                                                        playerinventory = player.gi();
                                                                        if (actionType != InventoryClickType.f) break block45;
                                                                        int i1 = this.w;
                                                                        this.w = Container.d(button);
                                                                        if (i1 == 1 && this.w == 2 || i1 == this.w) break block46;
                                                                        this.f();
                                                                        break block47;
                                                                    }
                                                                    if (!this.g().f()) break block48;
                                                                    this.f();
                                                                    break block47;
                                                                }
                                                                if (this.w != 0) break block49;
                                                                this.v = Container.c(button);
                                                                if (Container.a(this.v, player)) {
                                                                    this.w = 1;
                                                                    this.x.clear();
                                                                } else {
                                                                    this.f();
                                                                }
                                                                break block47;
                                                            }
                                                            if (this.w != 1) break block50;
                                                            if (slotIndex < 0) {
                                                                return;
                                                            }
                                                            Slot slot2 = this.k.get(slotIndex);
                                                            if (!Container.a(slot2, itemstack2 = this.g(), true) || !slot2.a(itemstack2) || this.v != 2 && itemstack2.L() <= this.x.size() || !this.b(slot2)) break block47;
                                                            this.x.add(slot2);
                                                            break block47;
                                                        }
                                                        if (this.w == 2) {
                                                            if (!this.x.isEmpty()) {
                                                                boolean needsUpdate;
                                                                if (this.x.size() == 1) {
                                                                    int k3 = this.x.iterator().next().d;
                                                                    this.f();
                                                                    this.b(k3, this.v, InventoryClickType.a, player);
                                                                    return;
                                                                }
                                                                net.minecraft.world.item.ItemStack itemstack1 = this.g().v();
                                                                if (itemstack1.f()) {
                                                                    this.f();
                                                                    return;
                                                                }
                                                                int l2 = this.g().L();
                                                                Iterator<Slot> iterator = this.x.iterator();
                                                                HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                                while (iterator.hasNext()) {
                                                                    Slot slot1 = iterator.next();
                                                                    net.minecraft.world.item.ItemStack itemstack2 = this.g();
                                                                    if (slot1 == null || !Container.a(slot1, itemstack2, true) || !slot1.a(itemstack2) || this.v != 2 && itemstack2.L() < this.x.size() || !this.b(slot1)) continue;
                                                                    int j1 = slot1.h() ? slot1.g().L() : 0;
                                                                    int k1 = Math.min(itemstack1.k(), slot1.a_(itemstack1));
                                                                    int l1 = Math.min(Container.a(this.x, this.v, itemstack1) + j1, k1);
                                                                    l2 -= l1 - j1;
                                                                    draggedSlots.put(slot1.d, itemstack1.c(l1));
                                                                }
                                                                InventoryView view = this.getBukkitView();
                                                                CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack1);
                                                                newcursor.setAmount(l2);
                                                                HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                                for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                    eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                                }
                                                                net.minecraft.world.item.ItemStack oldCursor = this.g();
                                                                this.b(CraftItemStack.asNMSCopy(newcursor));
                                                                InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.v == 1, eventmap);
                                                                player.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                                                                boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                                if (event.getResult() != Event.Result.DENY) {
                                                                    for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                        view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                    }
                                                                    if (this.g() != null) {
                                                                        this.b(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                        needsUpdate = true;
                                                                    }
                                                                } else {
                                                                    this.b(oldCursor);
                                                                }
                                                                if (needsUpdate && player instanceof EntityPlayer) {
                                                                    this.b();
                                                                }
                                                            }
                                                            this.f();
                                                        } else {
                                                            this.f();
                                                        }
                                                        break block47;
                                                    }
                                                    if (this.w == 0) break block51;
                                                    this.f();
                                                    break block47;
                                                }
                                                if (actionType != InventoryClickType.a && actionType != InventoryClickType.b || button != 0 && button != 1) break block52;
                                                ClickAction clickAction = clickaction = button == 0 ? ClickAction.a : ClickAction.b;
                                                if (slotIndex != -999) break block53;
                                                if (this.g().f()) break block47;
                                                if (clickaction == ClickAction.a) {
                                                    net.minecraft.world.item.ItemStack carried = this.g();
                                                    this.b(net.minecraft.world.item.ItemStack.j);
                                                    player.a(carried, true);
                                                } else {
                                                    player.a(this.g().a(1), true);
                                                }
                                                break block47;
                                            }
                                            if (actionType != InventoryClickType.b) break block54;
                                            if (slotIndex < 0) {
                                                return;
                                            }
                                            Slot slot3 = this.k.get(slotIndex);
                                            if (!slot3.a(player)) {
                                                return;
                                            }
                                            net.minecraft.world.item.ItemStack itemstack3 = this.b(player, slotIndex);
                                            while (!itemstack3.f() && net.minecraft.world.item.ItemStack.b(slot3.g(), itemstack3)) {
                                                itemstack3 = this.b(player, slotIndex);
                                            }
                                            break block47;
                                        }
                                        if (slotIndex < 0) {
                                            return;
                                        }
                                        Slot slot4 = this.k.get(slotIndex);
                                        net.minecraft.world.item.ItemStack itemstack5 = slot4.g();
                                        net.minecraft.world.item.ItemStack itemstack3 = this.g();
                                        player.a(itemstack3, slot4.g(), clickaction);
                                        if (!this.a(player, clickaction, slot4, itemstack5, itemstack3)) {
                                            if (itemstack5.f()) {
                                                if (!itemstack3.f()) {
                                                    int i2 = clickaction == ClickAction.a ? itemstack3.L() : 1;
                                                    this.b(slot4.b(itemstack3, i2));
                                                }
                                            } else if (slot4.a(player)) {
                                                if (itemstack3.f()) {
                                                    int i2 = clickaction == ClickAction.a ? itemstack5.L() : (itemstack5.L() + 1) / 2;
                                                    Optional<net.minecraft.world.item.ItemStack> optional = slot4.a(i2, Integer.MAX_VALUE, player);
                                                    optional.ifPresent(itemstack4 -> {
                                                        this.b((net.minecraft.world.item.ItemStack)itemstack4);
                                                        slot4.a(player, (net.minecraft.world.item.ItemStack)itemstack4);
                                                    });
                                                } else if (slot4.a(itemstack3)) {
                                                    if (net.minecraft.world.item.ItemStack.c(itemstack5, itemstack3)) {
                                                        int i2 = clickaction == ClickAction.a ? itemstack3.L() : 1;
                                                        this.b(slot4.b(itemstack3, i2));
                                                    } else if (itemstack3.L() <= slot4.a_(itemstack3)) {
                                                        this.b(itemstack5);
                                                        slot4.e(itemstack3);
                                                    }
                                                } else if (net.minecraft.world.item.ItemStack.c(itemstack5, itemstack3)) {
                                                    Optional<net.minecraft.world.item.ItemStack> optional1 = slot4.a(itemstack5.L(), itemstack3.k() - itemstack3.L(), player);
                                                    optional1.ifPresent(itemstack4 -> {
                                                        itemstack3.g(itemstack4.L());
                                                        slot4.a(player, (net.minecraft.world.item.ItemStack)itemstack4);
                                                    });
                                                }
                                            }
                                        }
                                        slot4.c();
                                        if (!(player instanceof EntityPlayer) || slot4.a() == 64) break block47;
                                        ((EntityPlayer)player).f.b(new PacketPlayOutSetSlot(this.l, this.k(), slot4.d, slot4.g()));
                                        if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                            ((EntityPlayer)player).f.b(new PacketPlayOutSetSlot(this.l, this.k(), 0, this.b(0).g()));
                                        }
                                        break block47;
                                    }
                                    if (actionType != InventoryClickType.c || (button < 0 || button >= 9) && button != 40) break block55;
                                    if (slotIndex < 0) {
                                        return;
                                    }
                                    itemstack42 = playerinventory.a(button);
                                    slot = this.k.get(slotIndex);
                                    itemstack = slot.g();
                                    if (itemstack42.f() && itemstack.f()) break block47;
                                    if (!itemstack42.f()) break block56;
                                    if (!slot.a(player)) break block47;
                                    playerinventory.a(button, itemstack);
                                    slot.b(itemstack.L());
                                    slot.e(net.minecraft.world.item.ItemStack.j);
                                    slot.a(player, itemstack);
                                    break block47;
                                }
                                if (!itemstack.f()) break block57;
                                if (!slot.a(itemstack42)) break block47;
                                int j2 = slot.a_(itemstack42);
                                if (itemstack42.L() > j2) {
                                    slot.e(itemstack42.a(j2));
                                } else {
                                    playerinventory.a(button, net.minecraft.world.item.ItemStack.j);
                                    slot.e(itemstack42);
                                }
                                break block47;
                            }
                            if (!slot.a(player) || !slot.a(itemstack42)) break block47;
                            int j2 = slot.a_(itemstack42);
                            if (itemstack42.L() <= j2) break block58;
                            slot.e(itemstack42.a(j2));
                            slot.a(player, itemstack);
                            if (playerinventory.f(itemstack)) break block47;
                            player.a(itemstack, true);
                            break block47;
                        }
                        playerinventory.a(button, itemstack);
                        slot.e(itemstack42);
                        slot.a(player, itemstack);
                        break block47;
                    }
                    if (actionType != InventoryClickType.d || !player.fV() || !this.g().f() || slotIndex < 0) break block59;
                    Slot slot2 = this.k.get(slotIndex);
                    if (!slot2.h()) break block47;
                    net.minecraft.world.item.ItemStack itemstack1 = slot2.g();
                    this.b(itemstack1.c(itemstack1.k()));
                    break block47;
                }
                if (actionType != InventoryClickType.e || !this.g().f() || slotIndex < 0) break block60;
                Slot slot2 = this.k.get(slotIndex);
                int n2 = k2 = button == 0 ? 1 : slot2.g().L();
                if (!player.gl()) {
                    return;
                }
                net.minecraft.world.item.ItemStack itemstack = slot2.b(k2, Integer.MAX_VALUE, player);
                player.a(itemstack, true);
                player.g(itemstack);
                if (button != 1) break block47;
                while (!itemstack.f() && net.minecraft.world.item.ItemStack.b(slot2.g(), itemstack)) {
                    if (!player.gl()) {
                        return;
                    }
                    itemstack = slot2.b(k2, Integer.MAX_VALUE, player);
                    player.a(itemstack, true);
                    player.g(itemstack);
                }
                break block47;
            }
            if (actionType == InventoryClickType.g && slotIndex >= 0) {
                Slot slot2 = this.k.get(slotIndex);
                net.minecraft.world.item.ItemStack itemstack1 = this.g();
                if (!(itemstack1.f() || slot2.h() && slot2.a(player))) {
                    int l3 = button == 0 ? 0 : this.k.size() - 1;
                    int j2 = button == 0 ? 1 : -1;
                    for (int i2 = 0; i2 < 2; ++i2) {
                        for (int k2 = l3; k2 >= 0 && k2 < this.k.size() && itemstack1.L() < itemstack1.k(); k2 += j2) {
                            Slot slot3 = this.k.get(k2);
                            if (!slot3.h() || !Container.a(slot3, itemstack1, true) || !slot3.a(player) || !this.a(itemstack1, slot3)) continue;
                            net.minecraft.world.item.ItemStack itemstack5 = slot3.g();
                            if (i2 == 0 && itemstack5.L() == itemstack5.k()) continue;
                            net.minecraft.world.item.ItemStack itemstack6 = slot3.b(itemstack5.L(), itemstack1.k() - itemstack1.L(), player);
                            itemstack1.g(itemstack6.L());
                        }
                    }
                }
            }
        }
    }

    private boolean a(EntityHuman player, ClickAction clickType, Slot slot, net.minecraft.world.item.ItemStack stack, net.minecraft.world.item.ItemStack cursorStack) {
        FeatureFlagSet featureflagset = player.dW().J();
        return cursorStack.a(featureflagset) && cursorStack.a(slot, clickType, player) ? true : stack.a(featureflagset) && stack.a(cursorStack, slot, clickType, player, this.m());
    }

    private SlotAccess m() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack a() {
                return Container.this.g();
            }

            @Override
            public boolean a(net.minecraft.world.item.ItemStack stack) {
                Container.this.b(stack);
                return true;
            }
        };
    }

    public boolean a(net.minecraft.world.item.ItemStack stack, Slot slot) {
        return true;
    }

    public void a(EntityHuman player) {
        net.minecraft.world.item.ItemStack itemstack;
        if (player instanceof EntityPlayer && !(itemstack = this.g()).f()) {
            this.b(net.minecraft.world.item.ItemStack.j);
            Container.a(player, itemstack);
        }
    }

    private static void a(EntityHuman player, net.minecraft.world.item.ItemStack stack) {
        EntityPlayer entityplayer;
        boolean flag = player.dR() && player.dS() != Entity.RemovalReason.e;
        boolean flag1 = player instanceof EntityPlayer && (entityplayer = (EntityPlayer)player).u();
        boolean flag2 = flag1;
        if (!flag && !flag2) {
            if (player instanceof EntityPlayer) {
                player.gi().g(stack);
            }
        } else {
            player.a(stack, false);
        }
    }

    protected void a(EntityHuman player, IInventory inventory) {
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            Container.a(player, inventory.b(i2));
        }
    }

    public void a(IInventory inventory) {
        this.d();
    }

    public void a(int slot, int revision, net.minecraft.world.item.ItemStack stack) {
        this.b(slot).f(stack);
        this.t = revision;
    }

    public void a(int revision, List<net.minecraft.world.item.ItemStack> stacks, net.minecraft.world.item.ItemStack cursorStack) {
        for (int j2 = 0; j2 < stacks.size(); ++j2) {
            this.b(j2).f(stacks.get(j2));
        }
        this.p = cursorStack;
        this.t = revision;
    }

    public void b(int id, int value) {
        this.o.get(id).a(value);
    }

    public abstract boolean b(EntityHuman var1);

    protected boolean a(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return this.moveItemStackTo(stack, startIndex, endIndex, fromLast, false);
    }

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast, boolean isCheck) {
        int l2;
        net.minecraft.world.item.ItemStack itemstack1;
        Slot slot;
        if (isCheck) {
            stack = stack.v();
        }
        boolean flag1 = false;
        int k2 = startIndex;
        if (fromLast) {
            k2 = endIndex - 1;
        }
        if (stack.l()) {
            while (!stack.f() && !(fromLast ? k2 < startIndex : k2 >= endIndex)) {
                slot = this.k.get(k2);
                itemstack1 = slot.g();
                if (isCheck) {
                    itemstack1 = itemstack1.v();
                }
                if (!itemstack1.f() && net.minecraft.world.item.ItemStack.c(stack, itemstack1)) {
                    int i1;
                    l2 = itemstack1.L() + stack.L();
                    if (l2 <= (i1 = slot.a_(itemstack1))) {
                        stack.e(0);
                        itemstack1.e(l2);
                        if (!isCheck) {
                            slot.c();
                        }
                        flag1 = true;
                    } else if (itemstack1.L() < i1) {
                        stack.h(i1 - itemstack1.L());
                        itemstack1.e(i1);
                        if (!isCheck) {
                            slot.c();
                        }
                        flag1 = true;
                    }
                }
                if (fromLast) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        if (!stack.f()) {
            k2 = fromLast ? endIndex - 1 : startIndex;
            while (!(fromLast ? k2 < startIndex : k2 >= endIndex)) {
                slot = this.k.get(k2);
                itemstack1 = slot.g();
                if (isCheck) {
                    itemstack1 = itemstack1.v();
                }
                if (itemstack1.f() && slot.a(stack)) {
                    l2 = slot.a_(stack);
                    if (isCheck) {
                        stack.h(Math.min(stack.L(), l2));
                    } else {
                        slot.e(stack.a(Math.min(stack.L(), l2)));
                        slot.c();
                    }
                    flag1 = true;
                    break;
                }
                if (fromLast) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        return flag1;
    }

    public static int c(int quickCraftData) {
        return quickCraftData >> 2 & 3;
    }

    public static int d(int quickCraftData) {
        return quickCraftData & 3;
    }

    public static int c(int quickCraftStage, int buttonId) {
        return quickCraftStage & 3 | (buttonId & 3) << 2;
    }

    public static boolean a(int stage, EntityHuman player) {
        return stage == 0 ? true : (stage == 1 ? true : stage == 2 && player.fV());
    }

    public void f() {
        this.w = 0;
        this.x.clear();
    }

    public static boolean a(@Nullable Slot slot, net.minecraft.world.item.ItemStack stack, boolean allowOverflow) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.h();
        return !flag1 && net.minecraft.world.item.ItemStack.c(stack, slot.g()) ? slot.g().L() + (allowOverflow ? 0 : stack.L()) <= stack.k() : flag1;
    }

    public static int a(Set<Slot> slots, int mode, net.minecraft.world.item.ItemStack stack) {
        return switch (mode) {
            case 0 -> MathHelper.d((float)stack.L() / (float)slots.size());
            case 1 -> 1;
            case 2 -> stack.k();
            default -> stack.L();
        };
    }

    public boolean b(Slot slot) {
        return true;
    }

    public static int a(@Nullable TileEntity entity) {
        return entity instanceof IInventory ? Container.b((IInventory)((Object)entity)) : 0;
    }

    public static int b(@Nullable IInventory inventory) {
        if (inventory == null) {
            return 0;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = inventory.a(i2);
            if (itemstack.f()) continue;
            f2 += (float)itemstack.L() / (float)inventory.e_(itemstack);
        }
        return MathHelper.b(f2 /= (float)inventory.b(), 0, 15);
    }

    public void b(net.minecraft.world.item.ItemStack stack) {
        this.p = stack;
    }

    public net.minecraft.world.item.ItemStack g() {
        if (this.p.f()) {
            this.b(net.minecraft.world.item.ItemStack.j);
        }
        return this.p;
    }

    public void h() {
        this.A = true;
    }

    public void i() {
        this.A = false;
    }

    public void a(Container handler) {
        Slot slot;
        int i2;
        HashBasedTable table = HashBasedTable.create();
        for (i2 = 0; i2 < handler.k.size(); ++i2) {
            slot = handler.k.get(i2);
            table.put((Object)slot.c, (Object)slot.i(), (Object)i2);
        }
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            slot = this.k.get(i2);
            Integer integer = (Integer)table.get((Object)slot.c, (Object)slot.i());
            if (integer == null) continue;
            this.n.set(i2, handler.n.get(integer));
            this.q.set(i2, handler.q.get(integer));
        }
    }

    public OptionalInt b(IInventory inventory, int index) {
        for (int j2 = 0; j2 < this.k.size(); ++j2) {
            Slot slot = this.k.get(j2);
            if (slot.c != inventory || index != slot.i()) continue;
            return OptionalInt.of(j2);
        }
        return OptionalInt.empty();
    }

    public int j() {
        return this.t;
    }

    public int k() {
        this.t = this.t + 1 & Short.MAX_VALUE;
        return this.t;
    }

    protected final Supplier<BlockInventoryHolder> createBlockHolder(ContainerAccess context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context was null");
        return () -> context.createBlockHolder(this);
    }
}

