/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.view.CraftEnchantmentView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;

public class ContainerEnchantTable
extends Container {
    static final MinecraftKey p = MinecraftKey.b("item/empty_slot_lapis_lazuli");
    private final IInventory q;
    private final ContainerAccess r;
    private final RandomSource s;
    private final ContainerProperty t;
    public final int[] m;
    public final int[] n;
    public final int[] o;
    private CraftEnchantmentView bukkitEntity = null;
    private Player player;

    public ContainerEnchantTable(int syncId, PlayerInventory playerInventory) {
        this(syncId, playerInventory, ContainerAccess.a);
    }

    public ContainerEnchantTable(int syncId, PlayerInventory playerInventory, final ContainerAccess context) {
        super(Containers.n, syncId);
        this.q = new InventorySubcontainer(this.createBlockHolder(context), 2){

            @Override
            public void e() {
                super.e();
                ContainerEnchantTable.this.a(this);
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.s = RandomSource.a();
        this.t = ContainerProperty.a();
        this.m = new int[3];
        this.n = new int[]{-1, -1, -1};
        this.o = new int[]{-1, -1, -1};
        this.r = context;
        this.a(new Slot(this, this.q, 0, 15, 47){

            @Override
            public int a() {
                return 1;
            }
        });
        this.a(new Slot(this, this.q, 1, 35, 47){

            @Override
            public boolean a(net.minecraft.world.item.ItemStack stack) {
                return stack.a(Items.oX);
            }

            @Override
            public Pair<MinecraftKey, MinecraftKey> b() {
                return Pair.of((Object)ContainerPlayer.B, (Object)p);
            }
        });
        this.c(playerInventory, 8, 84);
        this.a(ContainerProperty.a(this.m, 0));
        this.a(ContainerProperty.a(this.m, 1));
        this.a(ContainerProperty.a(this.m, 2));
        this.a(this.t).a(playerInventory.k.gr());
        this.a(ContainerProperty.a(this.n, 0));
        this.a(ContainerProperty.a(this.n, 1));
        this.a(ContainerProperty.a(this.n, 2));
        this.a(ContainerProperty.a(this.o, 0));
        this.a(ContainerProperty.a(this.o, 1));
        this.a(ContainerProperty.a(this.o, 2));
        this.player = (Player)playerInventory.k.getBukkitEntity();
    }

    @Override
    public void a(IInventory inventory) {
        if (inventory == this.q) {
            net.minecraft.world.item.ItemStack itemstack = inventory.a(0);
            if (!itemstack.f()) {
                this.r.a((World world, BlockPosition blockposition) -> {
                    int j2;
                    Registry<Holder<Enchantment>> registry = world.K_().e(Registries.aO).t();
                    int i2 = 0;
                    for (BlockPosition blockposition1 : BlockEnchantmentTable.c) {
                        if (!BlockEnchantmentTable.a(world, blockposition, blockposition1)) continue;
                        ++i2;
                    }
                    this.s.b((long)this.t.b());
                    for (j2 = 0; j2 < 3; ++j2) {
                        this.m[j2] = EnchantmentManager.a(this.s, j2, i2, itemstack);
                        this.n[j2] = -1;
                        this.o[j2] = -1;
                        if (this.m[j2] >= j2 + 1) continue;
                        this.m[j2] = 0;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        List<WeightedRandomEnchant> list;
                        if (this.m[j2] <= 0 || (list = this.a(world.K_(), itemstack, j2, this.m[j2])) == null || list.isEmpty()) continue;
                        WeightedRandomEnchant weightedrandomenchant = list.get(this.s.a(list.size()));
                        this.n[j2] = registry.a(weightedrandomenchant.a);
                        this.o[j2] = weightedrandomenchant.b;
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (j2 = 0; j2 < 3; ++j2) {
                        org.bukkit.enchantments.Enchantment enchantment = this.n[j2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.a(this.n[j2])) : null;
                        offers[j2] = enchantment != null ? new EnchantmentOffer(enchantment, this.o[j2], this.m[j2]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (EnchantmentView)this.getBukkitView(), this.r.getLocation().getBlock(), (ItemStack)item, offers, i2);
                    event.setCancelled(!itemstack.D());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (j2 = 0; j2 < 3; ++j2) {
                            this.m[j2] = 0;
                            this.n[j2] = -1;
                            this.o[j2] = -1;
                        }
                        return;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        EnchantmentOffer offer = event.getOffers()[j2];
                        if (offer != null) {
                            this.m[j2] = offer.getCost();
                            this.n[j2] = registry.a(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.o[j2] = offer.getEnchantmentLevel();
                            continue;
                        }
                        this.m[j2] = 0;
                        this.n[j2] = -1;
                        this.o[j2] = -1;
                    }
                    this.d();
                });
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.m[i2] = 0;
                    this.n[i2] = -1;
                    this.o[i2] = -1;
                }
            }
        }
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.m.length) {
            net.minecraft.world.item.ItemStack itemstack = this.q.a(0);
            net.minecraft.world.item.ItemStack itemstack1 = this.q.a(1);
            int j2 = id + 1;
            if ((itemstack1.f() || itemstack1.L() < j2) && !player.fV()) {
                return false;
            }
            if (this.m[id] > 0 && !itemstack.f() && (player.cq >= j2 && player.cq >= this.m[id] || player.gj().d)) {
                this.r.a((World world, BlockPosition blockposition) -> {
                    net.minecraft.world.item.ItemStack itemstack2 = itemstack;
                    List<WeightedRandomEnchant> list = this.a(world.K_(), itemstack, id, this.m[id]);
                    Registry<Holder<Enchantment>> registry = world.K_().e(Registries.aO).t();
                    HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                    for (WeightedRandomEnchant instance : list) {
                        enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.a), instance.b);
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack2);
                    org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(registry.a(this.n[id]));
                    int hintedEnchantmentLevel = this.o[id];
                    EnchantItemEvent event = new EnchantItemEvent((Player)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.r.getLocation().getBlock(), (ItemStack)item, this.m[id], enchants, hintedEnchantment, hintedEnchantmentLevel, id);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    int level = event.getExpLevelCost();
                    if (event.isCancelled() || level > player.cq && !player.gj().d || event.getEnchantsToAdd().isEmpty()) {
                        return;
                    }
                    itemstack2 = CraftItemStack.getOrCloneOnMutation(item, event.getItem());
                    if (itemstack2 != itemstack) {
                        this.q.a(0, itemstack2);
                    }
                    if (itemstack2.a(Items.rn)) {
                        itemstack2 = itemstack2.a((IMaterial)Items.vm);
                        this.q.a(0, itemstack2);
                    }
                    for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                        Holder<Enchantment> nms = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                        if (nms == null) continue;
                        WeightedRandomEnchant weightedrandomenchant = new WeightedRandomEnchant(nms, (Integer)entry.getValue());
                        itemstack2.a(weightedrandomenchant.a, weightedrandomenchant.b);
                    }
                    player.a(itemstack, j2);
                    itemstack1.a(j2, (EntityLiving)player);
                    if (itemstack1.f()) {
                        this.q.a(1, net.minecraft.world.item.ItemStack.j);
                    }
                    player.a(StatisticList.ak);
                    if (player instanceof EntityPlayer) {
                        CriterionTriggers.j.a((EntityPlayer)player, itemstack2, j2);
                    }
                    this.q.e();
                    this.t.a(player.gr());
                    this.a(this.q);
                    world.a((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.ir, SoundCategory.e, 1.0f, world.A.i() * 0.1f + 0.9f);
                });
                return true;
            }
            return false;
        }
        String s2 = String.valueOf(player.al());
        SystemUtils.b(s2 + " pressed invalid button id: " + id);
        return false;
    }

    private List<WeightedRandomEnchant> a(IRegistryCustom registryManager, net.minecraft.world.item.ItemStack stack, int slot, int level) {
        this.s.b((long)(this.t.b() + slot));
        Optional optional = registryManager.e(Registries.aO).a(EnchantmentTags.k);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<WeightedRandomEnchant> list = EnchantmentManager.b(this.s, stack, level, ((HolderSet.Named)optional.get()).a());
        if (stack.a(Items.rn) && list.size() > 1) {
            list.remove(this.s.a(list.size()));
        }
        return list;
    }

    public int l() {
        net.minecraft.world.item.ItemStack itemstack = this.q.a(1);
        return itemstack.f() ? 0 : itemstack.L();
    }

    public int m() {
        return this.t.b();
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.r.a((World world, BlockPosition blockposition) -> this.a(player, this.q));
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerEnchantTable.a(this.r, player, Blocks.fF);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(EntityHuman player, int slot) {
        net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.item.ItemStack.j;
        Slot slot1 = this.k.get(slot);
        if (slot1 != null && slot1.h()) {
            net.minecraft.world.item.ItemStack itemstack1 = slot1.g();
            itemstack = itemstack1.v();
            if (slot == 0) {
                if (!this.a(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.j;
                }
            } else if (slot == 1) {
                if (!this.a(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.j;
                }
            } else if (itemstack1.a(Items.oX)) {
                if (!this.a(itemstack1, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.j;
                }
            } else {
                if (this.k.get(0).h() || !this.k.get(0).a(itemstack1)) {
                    return net.minecraft.world.item.ItemStack.j;
                }
                net.minecraft.world.item.ItemStack itemstack2 = itemstack1.c(1);
                itemstack1.h(1);
                this.k.get(0).e(itemstack2);
            }
            if (itemstack1.f()) {
                slot1.e(net.minecraft.world.item.ItemStack.j);
            } else {
                slot1.c();
            }
            if (itemstack1.L() == itemstack.L()) {
                return net.minecraft.world.item.ItemStack.j;
            }
            slot1.a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    public CraftEnchantmentView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.q);
        this.bukkitEntity = new CraftEnchantmentView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public void setEnchantmentSeed(int seed) {
        this.t.a(seed);
    }
}

