/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_21_R2.inventory.view.CraftLoomView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.LoomInventory;

public class ContainerLoom
extends Container {
    private CraftLoomView bukkitEntity = null;
    private Player player;
    private static final int m = -1;
    private static final int n = 4;
    private static final int o = 31;
    private static final int p = 31;
    private static final int q = 40;
    private final ContainerAccess r;
    final ContainerProperty s = ContainerProperty.a();
    private List<Holder<EnumBannerPatternType>> t = List.of();
    Runnable u = () -> {};
    private final HolderGetter<EnumBannerPatternType> v;
    final Slot w;
    final Slot x;
    private final Slot y;
    private final Slot z;
    long A;
    private final IInventory B;
    private final IInventory C;

    @Override
    public CraftLoomView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLoom inventory = new CraftInventoryLoom(this.B, this.C);
        this.bukkitEntity = new CraftLoomView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerLoom(int syncId, PlayerInventory playerInventory) {
        this(syncId, playerInventory, ContainerAccess.a);
    }

    public ContainerLoom(int syncId, PlayerInventory playerInventory, final ContainerAccess context) {
        super(Containers.s, syncId);
        this.B = new InventorySubcontainer(this.createBlockHolder(context), 3){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.a(this);
                ContainerLoom.this.u.run();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.C = new InventorySubcontainer(this.createBlockHolder(context), 1){

            @Override
            public void e() {
                super.e();
                ContainerLoom.this.u.run();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.r = context;
        this.w = this.a(new Slot(this, this.B, 0, 13, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemBanner;
            }
        });
        this.x = this.a(new Slot(this, this.B, 1, 33, 26){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemDye;
            }
        });
        this.y = this.a(new Slot(this, this.B, 2, 23, 45){

            @Override
            public boolean a(ItemStack stack) {
                return stack.h() instanceof ItemBannerPattern;
            }
        });
        this.z = this.a(new Slot(this.C, 0, 143, 57){

            @Override
            public boolean a(ItemStack stack) {
                return false;
            }

            @Override
            public void a(EntityHuman player, ItemStack stack) {
                ContainerLoom.this.w.a(1);
                ContainerLoom.this.x.a(1);
                if (!ContainerLoom.this.w.h() || !ContainerLoom.this.x.h()) {
                    ContainerLoom.this.s.a(-1);
                }
                context.a((World world, BlockPosition blockposition) -> {
                    long j2 = world.ac();
                    if (ContainerLoom.this.A != j2) {
                        world.a((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.AS, SoundCategory.e, 1.0f, 1.0f);
                        ContainerLoom.this.A = j2;
                    }
                });
                super.a(player, stack);
            }
        });
        this.c(playerInventory, 8, 84);
        this.a(this.s);
        this.v = playerInventory.k.dY().e(Registries.d);
        this.player = (Player)playerInventory.k.getBukkitEntity();
    }

    @Override
    public boolean b(EntityHuman player) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerLoom.a(this.r, player, Blocks.oo);
    }

    @Override
    public boolean a(EntityHuman player, int id) {
        if (id >= 0 && id < this.t.size()) {
            int selectablePatternIndex = id;
            PlayerLoomPatternSelectEvent event = new PlayerLoomPatternSelectEvent((Player)player.getBukkitEntity(), (LoomInventory)((CraftInventoryLoom)this.getBukkitView().getTopInventory()), CraftPatternType.minecraftHolderToBukkit(this.t.get(selectablePatternIndex)));
            if (!event.callEvent()) {
                player.cd.b();
                return false;
            }
            Holder<EnumBannerPatternType> eventPattern = CraftPatternType.bukkitToMinecraftHolder(event.getPatternType());
            Holder<EnumBannerPatternType> selectedPattern = null;
            for (int i2 = 0; i2 < this.t.size(); ++i2) {
                Holder<EnumBannerPatternType> holder = this.t.get(i2);
                if (!eventPattern.equals(holder)) continue;
                selectablePatternIndex = i2;
                selectedPattern = holder;
                break;
            }
            if (selectedPattern == null) {
                selectedPattern = eventPattern;
                selectablePatternIndex = -1;
            }
            player.cd.b();
            this.s.a(selectablePatternIndex);
            this.a(Objects.requireNonNull(selectedPattern, "selectedPattern was null, this is unexpected"));
            return true;
        }
        return false;
    }

    private List<Holder<EnumBannerPatternType>> c(ItemStack stack) {
        if (stack.f()) {
            return (List)this.v.a(BannerPatternTags.a).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = stack.h();
        if (item instanceof ItemBannerPattern) {
            ItemBannerPattern itembannerpattern = (ItemBannerPattern)item;
            return (List)this.v.a(itembannerpattern.b()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }

    private boolean e(int index) {
        return index >= 0 && index < this.t.size();
    }

    @Override
    public void a(IInventory inventory) {
        ItemStack itemstack = this.w.g();
        ItemStack itemstack1 = this.x.g();
        ItemStack itemstack2 = this.y.g();
        if (!itemstack.f() && !itemstack1.f()) {
            Holder<EnumBannerPatternType> holder;
            int i2 = this.s.b();
            boolean flag = this.e(i2);
            List<Holder<EnumBannerPatternType>> list = this.t;
            this.t = this.c(itemstack2);
            if (this.t.size() == 1) {
                this.s.a(0);
                holder = this.t.get(0);
            } else if (!flag) {
                this.s.a(-1);
                holder = null;
            } else {
                Holder<EnumBannerPatternType> holder1 = list.get(i2);
                int j2 = this.t.indexOf(holder1);
                if (j2 != -1) {
                    holder = holder1;
                    this.s.a(j2);
                } else {
                    holder = null;
                    this.s.a(-1);
                }
            }
            if (holder != null) {
                boolean flag1;
                BannerPatternLayers bannerpatternlayers = itemstack.a(DataComponents.ai, BannerPatternLayers.a);
                boolean bl = flag1 = bannerpatternlayers.b().size() >= 6;
                if (flag1) {
                    this.s.a(-1);
                    this.z.f(ItemStack.j);
                } else {
                    this.a(holder);
                }
            } else {
                this.z.f(ItemStack.j);
            }
            CraftEventFactory.callPrepareResultEvent(this, 3);
        } else {
            this.z.f(ItemStack.j);
            this.t = List.of();
            this.s.a(-1);
        }
    }

    public List<Holder<EnumBannerPatternType>> l() {
        return this.t;
    }

    public int m() {
        return this.s.b();
    }

    public void a(Runnable inventoryChangeListener) {
        this.u = inventoryChangeListener;
    }

    @Override
    public ItemStack b(EntityHuman player, int slot) {
        ItemStack itemstack = ItemStack.j;
        Slot slot1 = this.k.get(slot);
        if (slot1 != null && slot1.h()) {
            ItemStack itemstack1 = slot1.g();
            itemstack = itemstack1.v();
            if (slot == this.z.d) {
                if (!this.a(itemstack1, 4, 40, true)) {
                    return ItemStack.j;
                }
                slot1.b(itemstack1, itemstack);
            } else if (slot != this.x.d && slot != this.w.d && slot != this.y.d ? (itemstack1.h() instanceof ItemBanner ? !this.a(itemstack1, this.w.d, this.w.d + 1, false) : (itemstack1.h() instanceof ItemDye ? !this.a(itemstack1, this.x.d, this.x.d + 1, false) : (itemstack1.h() instanceof ItemBannerPattern ? !this.a(itemstack1, this.y.d, this.y.d + 1, false) : (slot >= 4 && slot < 31 ? !this.a(itemstack1, 31, 40, false) : slot >= 31 && slot < 40 && !this.a(itemstack1, 4, 31, false))))) : !this.a(itemstack1, 4, 40, false)) {
                return ItemStack.j;
            }
            if (itemstack1.f()) {
                slot1.e(ItemStack.j);
            } else {
                slot1.c();
            }
            if (itemstack1.L() == itemstack.L()) {
                return ItemStack.j;
            }
            slot1.a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void a(EntityHuman player) {
        super.a(player);
        this.r.a((World world, BlockPosition blockposition) -> this.a(player, this.B));
    }

    private void a(Holder<EnumBannerPatternType> pattern) {
        ItemStack itemstack = this.w.g();
        ItemStack itemstack1 = this.x.g();
        ItemStack itemstack2 = ItemStack.j;
        if (!itemstack.f() && !itemstack1.f()) {
            itemstack2 = itemstack.c(1);
            EnumColor enumcolor = ((ItemDye)itemstack1.h()).b();
            itemstack2.a(DataComponents.ai, BannerPatternLayers.a, bannerpatternlayers -> {
                if (bannerpatternlayers.b().size() > 20) {
                    bannerpatternlayers = new BannerPatternLayers(List.copyOf(bannerpatternlayers.b().subList(0, 20)));
                }
                return new BannerPatternLayers.a().a((BannerPatternLayers)bannerpatternlayers).a(pattern, enumcolor).a();
            });
        }
        if (!ItemStack.a(itemstack2, this.z.g())) {
            this.z.f(itemstack2);
        }
    }

    public Slot n() {
        return this.w;
    }

    public Slot o() {
        return this.x;
    }

    public Slot p() {
        return this.y;
    }

    public Slot q() {
        return this.z;
    }
}

