/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.World;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int a = 4;
    public static final int b = 3;
    public static final int c = 12;
    public static final int d = 11;
    private static final int m = ARGB.a(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int n = ARGB.a(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int o = 10;
    private static final int p = 2;
    private static final int q = 200;
    private final MinecraftKey r;
    private final MinecraftKey s;

    public BundleItem(MinecraftKey openFrontTexture, MinecraftKey openBackTexture, Item.Info settings) {
        super(settings);
        this.r = openFrontTexture;
        this.s = openBackTexture;
    }

    public static float c(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().floatValue();
    }

    public MinecraftKey b() {
        return this.r;
    }

    public MinecraftKey c() {
        return this.s;
    }

    @Override
    @Override
    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null) {
            return false;
        }
        ItemStack itemStack = slot.g();
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (clickType == ClickAction.a && !itemStack.f()) {
            if (mutable.a(slot, player) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        if (clickType == ClickAction.b && itemStack.f()) {
            ItemStack itemStack2 = mutable.b();
            if (itemStack2 != null) {
                ItemStack itemStack3 = slot.d(itemStack2);
                if (itemStack3.L() > 0) {
                    mutable.a(itemStack3);
                } else {
                    BundleItem.a(player);
                }
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.a && otherStack.f()) {
            BundleItem.a(stack, -1);
            return false;
        }
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null) {
            return false;
        }
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        if (clickType == ClickAction.a && !otherStack.f()) {
            if (slot.b(player) && mutable.a(otherStack) > 0) {
                BundleItem.b(player);
            } else {
                BundleItem.c(player);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        if (clickType == ClickAction.b && otherStack.f()) {
            ItemStack itemStack;
            if (slot.b(player) && (itemStack = mutable.b()) != null) {
                BundleItem.a(player);
                cursorStackReference.a(itemStack);
            }
            stack.b(DataComponents.P, mutable.d());
            this.a(player);
            return true;
        }
        BundleItem.a(stack, -1);
        return false;
    }

    @Override
    @Override
    public EnumInteractionResult a(World world, EntityHuman user, EnumHand hand) {
        if (world.C) {
            return EnumInteractionResult.c;
        }
        user.c(hand);
        return EnumInteractionResult.b;
    }

    private void a(World world, EntityHuman player, ItemStack stack) {
        if (this.a(stack, player)) {
            BundleItem.a(world, player);
            player.b(StatisticList.c.b(this));
        }
    }

    @Override
    @Override
    public boolean d(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    @Override
    public int e(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return Math.min(1 + MathHelper.a(bundleContents.f(), 12), 13);
    }

    @Override
    @Override
    public int f(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.f().compareTo(Fraction.ONE) >= 0 ? m : n;
    }

    public static void a(ItemStack stack, int selectedStackIndex) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null) {
            return;
        }
        BundleContents.a mutable = new BundleContents.a(bundleContents);
        mutable.a(selectedStackIndex);
        stack.b(DataComponents.P, mutable.d());
    }

    public static boolean g(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.h() != -1;
    }

    public static int h(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.h();
    }

    public static ItemStack i(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.a(bundleContents.h());
    }

    public static int j(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P, BundleContents.a);
        return bundleContents.a();
    }

    private boolean a(ItemStack stack, EntityHuman player) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents == null || bundleContents.g()) {
            return false;
        }
        Optional<ItemStack> optional = BundleItem.a(stack, player, bundleContents);
        if (optional.isPresent()) {
            player.a(optional.get(), true);
            return true;
        }
        return false;
    }

    private static Optional<ItemStack> a(ItemStack stack, EntityHuman player, BundleContents contents) {
        BundleContents.a mutable = new BundleContents.a(contents);
        ItemStack itemStack = mutable.b();
        if (itemStack != null) {
            BundleItem.a(player);
            stack.b(DataComponents.P, mutable.d());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    @Override
    @Override
    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
        if (!world.C && user instanceof EntityHuman) {
            boolean bl;
            EntityHuman player = (EntityHuman)user;
            int i2 = this.a(stack, user);
            boolean bl2 = bl = remainingUseTicks == i2;
            if (bl || remainingUseTicks < i2 - 10 && remainingUseTicks % 2 == 0) {
                this.a(world, player, stack);
            }
        }
    }

    @Override
    @Override
    public int a(ItemStack stack, EntityLiving user) {
        return 200;
    }

    @Override
    @Override
    public Optional<TooltipComponent> k(ItemStack stack) {
        if (stack.b(DataComponents.r) || stack.b(DataComponents.q)) {
            return Optional.empty();
        }
        return Optional.ofNullable(stack.a(DataComponents.P)).map(BundleTooltip::new);
    }

    @Override
    @Override
    public void a(EntityItem entity) {
        BundleContents bundleContents = entity.l().a(DataComponents.P);
        if (bundleContents == null) {
            return;
        }
        entity.l().b(DataComponents.P, BundleContents.a);
        ItemLiquidUtil.a(entity, bundleContents.d());
    }

    public static List<BundleItem> d() {
        return Stream.of(Items.rs, Items.rt, Items.ru, Items.rv, Items.rw, Items.rx, Items.ry, Items.rz, Items.rA, Items.rB, Items.rC, Items.rI, Items.rF, Items.rG, Items.rH, Items.rE, Items.rD).map(item -> (BundleItem)item).toList();
    }

    public static Item a(EnumColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Items.rt;
            case EnumColor.b -> Items.ru;
            case EnumColor.c -> Items.rv;
            case EnumColor.d -> Items.rw;
            case EnumColor.e -> Items.rx;
            case EnumColor.f -> Items.ry;
            case EnumColor.g -> Items.rz;
            case EnumColor.h -> Items.rA;
            case EnumColor.i -> Items.rB;
            case EnumColor.j -> Items.rC;
            case EnumColor.l -> Items.rE;
            case EnumColor.m -> Items.rF;
            case EnumColor.n -> Items.rG;
            case EnumColor.o -> Items.rH;
            case EnumColor.p -> Items.rI;
            case EnumColor.k -> Items.rD;
        };
    }

    private static void a(Entity entity) {
        entity.a(SoundEffects.ds, 0.8f, 0.8f + entity.dW().H_().i() * 0.4f);
    }

    private static void b(Entity entity) {
        entity.a(SoundEffects.dq, 0.8f, 0.8f + entity.dW().H_().i() * 0.4f);
    }

    private static void c(Entity entity) {
        entity.a(SoundEffects.dr, 1.0f, 1.0f);
    }

    private static void a(World world, Entity entity) {
        world.a(null, entity.dw(), SoundEffects.dp, SoundCategory.h, 0.8f, 0.8f + entity.dW().H_().i() * 0.4f);
    }

    private void a(EntityHuman user) {
        Container abstractContainerMenu = user.cd;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.a(user.gi());
        }
    }
}

