/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> a;

    public InstrumentItem(TagKey<Instrument> instrumentTag, Item.Info settings) {
        super(settings);
        this.a = instrumentTag;
    }

    @Override
    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        super.a(stack, context, tooltip, type);
        HolderLookup.a provider = context.a();
        if (provider == null) {
            return;
        }
        Optional<Holder<Instrument>> optional = this.a(stack, provider);
        if (optional.isPresent()) {
            IChatMutableComponent mutableComponent = optional.get().a().d().f();
            ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.h));
            tooltip.add(mutableComponent);
        }
    }

    public static ItemStack a(Item item, Holder<Instrument> instrument) {
        ItemStack itemStack = new ItemStack(item);
        itemStack.b(DataComponents.Z, instrument);
        return itemStack;
    }

    @Override
    @Override
    public EnumInteractionResult a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        Optional<Holder<Instrument>> optional = this.a(itemStack, user.dY());
        if (optional.isPresent()) {
            Instrument instrument = optional.get().a();
            user.c(hand);
            InstrumentItem.a(world, user, instrument);
            user.gE().a(itemStack, MathHelper.d(instrument.b() * 20.0f));
            user.b(StatisticList.c.b(this));
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.d;
    }

    @Override
    @Override
    public int a(ItemStack stack, EntityLiving user) {
        Optional<Holder<Instrument>> optional = this.a(stack, user.dY());
        return optional.map(instrument -> MathHelper.d(((Instrument)instrument.a()).b() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> a(ItemStack stack, HolderLookup.a registries) {
        Iterator iterator;
        Holder<Instrument> holder = stack.a(DataComponents.Z);
        if (holder != null) {
            return Optional.of(holder);
        }
        Optional<HolderSet.Named<Instrument>> optional = registries.d(Registries.I).a(this.a);
        if (optional.isPresent() && (iterator = optional.get().iterator()).hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    @Override
    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.i;
    }

    private static void a(World world, EntityHuman player, Instrument instrument) {
        SoundEffect soundEvent = instrument.a().a();
        float f2 = instrument.c() / 16.0f;
        world.a(player, player, soundEvent, SoundCategory.c, f2, 1.0f);
        world.a(GameEvent.B, player.du(), GameEvent.a.a(player));
    }
}

