/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    public static final Codec<Holder<Item>> e = BuiltInRegistries.g.r().validate(entry -> entry.a(Items.a.f()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)entry));
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> f = Maps.newHashMap();
    public static final MinecraftKey g = MinecraftKey.b("base_attack_damage");
    public static final MinecraftKey h = MinecraftKey.b("base_attack_speed");
    public static final int i = 64;
    public static final int j = 99;
    public static final int k = 13;
    private final Holder.c<Item> b = BuiltInRegistries.g.f(this);
    private final DataComponentMap c;
    @Nullable
    private final Item d;
    protected final String l;
    private final FeatureFlagSet m;

    public static int a(Item item) {
        return item == null ? 0 : BuiltInRegistries.g.a(item);
    }

    public static Item b(int id) {
        return BuiltInRegistries.g.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return f.getOrDefault(block, Items.a);
    }

    public Item(Info settings) {
        String string;
        this.l = settings.d();
        this.c = settings.a(IChatBaseComponent.c(this.l), settings.e());
        this.d = settings.d;
        this.m = settings.e;
        if (SharedConstants.aU && !(string = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)string);
        }
    }

    @Deprecated
    public Holder.c<Item> f() {
        return this.b;
    }

    public DataComponentMap g() {
        return this.c;
    }

    public int h() {
        return this.c.a(DataComponents.c, 1);
    }

    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
    }

    public void a(EntityItem entity) {
    }

    public void l(ItemStack stack) {
    }

    public boolean a(IBlockData state, World world, BlockPosition pos, EntityHuman miner) {
        return true;
    }

    @Override
    @Override
    public Item j() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.e;
    }

    public float a(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.B);
        return tool != null ? tool.a(state) : 1.0f;
    }

    public EnumInteractionResult a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        Consumable consumable = itemStack.a(DataComponents.x);
        if (consumable != null) {
            return consumable.a(user, itemStack, hand);
        }
        Equippable equippable = itemStack.a(DataComponents.D);
        if (equippable != null && equippable.g()) {
            return equippable.a(itemStack, user);
        }
        return EnumInteractionResult.e;
    }

    public ItemStack a(ItemStack stack, World world, EntityLiving user) {
        Consumable consumable = stack.a(DataComponents.x);
        if (consumable != null) {
            return consumable.a(world, user, stack);
        }
        return stack;
    }

    public boolean d(ItemStack stack) {
        return stack.n();
    }

    public int e(ItemStack stack) {
        return MathHelper.a(Math.round(13.0f - (float)stack.o() * 13.0f / (float)stack.p()), 0, 13);
    }

    public int f(ItemStack stack) {
        int i2 = stack.p();
        float f2 = Math.max(0.0f, ((float)i2 - (float)stack.o()) / (float)i2);
        return MathHelper.g(f2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return false;
    }

    public float a(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return 0.0f;
    }

    @Nullable
    public DamageSource a(EntityLiving user) {
        return null;
    }

    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        return false;
    }

    public void b(ItemStack stack, EntityLiving target, EntityLiving attacker) {
    }

    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        Tool tool = stack.a(DataComponents.B);
        if (tool == null) {
            return false;
        }
        if (!world.C && state.e(world, pos) != 0.0f && tool.c() > 0) {
            stack.a(tool.c(), miner, EnumItemSlot.a);
        }
        return true;
    }

    public boolean b(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.B);
        return tool != null && tool.b(state);
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman user, EntityLiving entity, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    @Override
    public String toString() {
        return BuiltInRegistries.g.e(this).g();
    }

    public final ItemStack k() {
        return this.d == null ? ItemStack.j : new ItemStack(this.d);
    }

    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void a(ItemStack stack, World world, EntityHuman player) {
        this.a(stack, world);
    }

    public void a(ItemStack stack, World world) {
    }

    public ItemUseAnimation b(ItemStack stack) {
        Consumable consumable = stack.a(DataComponents.x);
        if (consumable != null) {
            return consumable.d();
        }
        return ItemUseAnimation.a;
    }

    public int a(ItemStack stack, EntityLiving user) {
        Consumable consumable = stack.a(DataComponents.x);
        if (consumable != null) {
            return consumable.a();
        }
        return 0;
    }

    public boolean a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
        return false;
    }

    public void a(ItemStack stack, b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
    }

    public Optional<TooltipComponent> k(ItemStack stack) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String l() {
        return this.l;
    }

    public final IChatBaseComponent m() {
        return this.c.a(DataComponents.h, CommonComponents.a);
    }

    public IChatBaseComponent a(ItemStack stack) {
        return stack.a().a(DataComponents.h, CommonComponents.a);
    }

    public boolean c_(ItemStack stack) {
        return stack.E();
    }

    protected static MovingObjectPositionBlock a(World world, EntityHuman player, RayTrace.FluidCollisionOption fluidHandling) {
        Vec3D vec3 = player.bF();
        Vec3D vec32 = vec3.e(player.d(player.dO(), player.dM()).c(player.gJ()));
        return world.a(new RayTrace(vec3, vec32, RayTrace.BlockCollisionOption.b, fluidHandling, player));
    }

    public boolean d_(ItemStack stack) {
        return false;
    }

    public ItemStack n() {
        return new ItemStack(this);
    }

    public SoundEffect a() {
        return SoundEffects.nT;
    }

    public boolean e() {
        return true;
    }

    @Override
    @Override
    public FeatureFlagSet i() {
        return this.m;
    }

    public static class Info {
        private static final DependantName<Item, String> a = key -> SystemUtils.a("block", key.a());
        private static final DependantName<Item, String> b = key -> SystemUtils.a("item", key.a());
        private final DataComponentMap.a c = DataComponentMap.a().a(DataComponents.aq);
        @Nullable
        Item d;
        FeatureFlagSet e = FeatureFlags.h;
        @Nullable
        private ResourceKey<Item> f;
        private DependantName<Item, String> g = b;
        private DependantName<Item, MinecraftKey> h = ResourceKey::a;

        public Info a(FoodInfo foodComponent) {
            return this.a(foodComponent, Consumables.a);
        }

        public Info a(FoodInfo foodComponent, Consumable consumableComponent) {
            return this.a(DataComponents.w, foodComponent).a(DataComponents.x, consumableComponent);
        }

        public Info a(Item convertInto) {
            return this.a(DataComponents.y, new UseRemainder(new ItemStack(convertInto)));
        }

        public Info a(float seconds) {
            return this.a(DataComponents.z, new UseCooldown(seconds));
        }

        public Info a(int maxCount) {
            return this.a(DataComponents.c, maxCount);
        }

        public Info b(int maxDamage) {
            this.a(DataComponents.d, maxDamage);
            this.a(DataComponents.c, 1);
            this.a(DataComponents.e, 0);
            return this;
        }

        public Info b(Item recipeRemainder) {
            this.d = recipeRemainder;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            return this.a(DataComponents.k, rarity);
        }

        public Info a() {
            return this.a(DataComponents.A, new DamageResistant(DamageTypeTags.i));
        }

        public Info a(ResourceKey<JukeboxSong> songKey) {
            return this.a(DataComponents.ab, new JukeboxPlayable(new EitherHolder<JukeboxSong>(songKey), true));
        }

        public Info c(int enchantability) {
            return this.a(DataComponents.C, new Enchantable(enchantability));
        }

        public Info c(Item repairIngredient) {
            return this.a(DataComponents.E, new Repairable(HolderSet.a(repairIngredient.f())));
        }

        public Info a(TagKey<Item> repairIngredientsTag) {
            HolderGetter<Item> holderGetter = BuiltInRegistries.a(BuiltInRegistries.g);
            return this.a(DataComponents.E, new Repairable(holderGetter.b(repairIngredientsTag)));
        }

        public Info a(EnumItemSlot slot) {
            return this.a(DataComponents.D, Equippable.a(slot).a());
        }

        public Info b(EnumItemSlot slot) {
            return this.a(DataComponents.D, Equippable.a(slot).b(false).a());
        }

        public Info a(FeatureFlag ... features) {
            this.e = FeatureFlags.f.a(features);
            return this;
        }

        public Info b(ResourceKey<Item> registryKey) {
            this.f = registryKey;
            return this;
        }

        public Info a(String translationKey) {
            this.g = DependantName.fixed(translationKey);
            return this;
        }

        public Info b() {
            this.g = a;
            return this;
        }

        public Info c() {
            this.g = b;
            return this;
        }

        protected String d() {
            return this.g.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public Info a(MinecraftKey modelId) {
            this.h = DependantName.fixed(modelId);
            return this;
        }

        public MinecraftKey e() {
            return this.h.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public <T> Info a(DataComponentType<T> type, T value) {
            this.c.a(type, value);
            return this;
        }

        public Info a(ItemAttributeModifiers attributeModifiersComponent) {
            return this.a(DataComponents.o, attributeModifiersComponent);
        }

        DataComponentMap a(IChatBaseComponent name, MinecraftKey modelId) {
            DataComponentMap dataComponentMap = this.c.a(DataComponents.h, name).a(DataComponents.i, modelId).a();
            if (dataComponentMap.b(DataComponents.e) && dataComponentMap.a(DataComponents.c, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return dataComponentMap;
        }
    }

    public static interface b {
        public static final b a = new b(){

            @Override
            @Nullable
            @Override
            public HolderLookup.a a() {
                return null;
            }

            @Override
            @Override
            public float b() {
                return 20.0f;
            }

            @Override
            @Nullable
            @Override
            public WorldMap a(MapId mapIdComponent) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.a a();

        public float b();

        @Nullable
        public WorldMap a(MapId var1);

        public static b a(final @Nullable World world) {
            if (world == null) {
                return a;
            }
            return new b(){

                @Override
                @Override
                public HolderLookup.a a() {
                    return world.K_();
                }

                @Override
                @Override
                public float b() {
                    return world.t().f();
                }

                @Override
                @Override
                public WorldMap a(MapId mapIdComponent) {
                    return world.a(mapIdComponent);
                }
            };
        }

        public static b a(final HolderLookup.a registries) {
            return new b(){

                @Override
                @Override
                public HolderLookup.a a() {
                    return registries;
                }

                @Override
                @Override
                public float b() {
                    return 20.0f;
                }

                @Override
                @Nullable
                @Override
                public WorldMap a(MapId mapIdComponent) {
                    return null;
                }
            };
        }
    }
}

