/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class ItemEnderEye
extends Item {
    public ItemEnderEye(Item.Info settings) {
        super(settings);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        BlockPosition blockposition;
        World world = context.q();
        IBlockData iblockdata = world.a_(blockposition = context.a());
        if (iblockdata.a(Blocks.fM) && !iblockdata.c(BlockEnderPortalFrame.c).booleanValue()) {
            if (world.C) {
                return EnumInteractionResult.a;
            }
            IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockEnderPortalFrame.c, true);
            if (!CraftEventFactory.callEntityChangeBlockEvent(context.o(), blockposition, iblockdata1)) {
                return EnumInteractionResult.e;
            }
            Block.a(iblockdata, iblockdata1, world, blockposition);
            world.a(blockposition, iblockdata1, 2);
            world.c(blockposition, Blocks.fM);
            context.n().h(1);
            world.c(1503, blockposition, 0);
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = BlockEnderPortalFrame.b().a(world, blockposition);
            if (shapedetector_shapedetectorcollection != null) {
                BlockPosition blockposition1 = shapedetector_shapedetectorcollection.a().b(-3, 0, -3);
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j2 = 0; j2 < 3; ++j2) {
                        world.a(blockposition1.b(i2, 0, j2), Blocks.fL.m(), 2);
                    }
                }
                int viewDistance = world.getCraftServer().getViewDistance() * 16;
                BlockPosition soundPos = blockposition1.b(1, 0, 1);
                WorldServer serverLevel = (WorldServer)world;
                for (EntityPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = (double)soundPos.u() - player.dB();
                    double deltaZ = (double)soundPos.w() - player.dH();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.endPortalSoundRadius);
                    if (!serverLevel.N().b(GameRules.X) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dB() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dH() + deltaZ / deltaLength * (double)viewDistance;
                        player.f.b(new PacketPlayOutWorldEvent(1038, new BlockPosition((int)relativeX, soundPos.v(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.f.b(new PacketPlayOutWorldEvent(1038, soundPos, 0, true));
                }
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public int a(ItemStack stack, EntityLiving user) {
        return 0;
    }

    @Override
    public EnumInteractionResult a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = user.b(hand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemEnderEye.a(world, user, RayTrace.FluidCollisionOption.a);
        if (movingobjectpositionblock.d() == MovingObjectPosition.EnumMovingObjectType.b && world.a_(movingobjectpositionblock.b()).a(Blocks.fM)) {
            return EnumInteractionResult.e;
        }
        user.c(hand);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition = worldserver.a(StructureTags.a, user.dw(), 100, false);
            if (blockposition == null) {
                return EnumInteractionResult.c;
            }
            EntityEnderSignal entityendersignal = new EntityEnderSignal(world, user.dB(), user.e(0.5), user.dH());
            entityendersignal.a(itemstack);
            entityendersignal.a(blockposition);
            world.a(GameEvent.K, entityendersignal.du(), GameEvent.a.a(user));
            if (!world.b(entityendersignal)) {
                return EnumInteractionResult.d;
            }
            if (user instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)user;
                CriterionTriggers.n.a(entityplayer, blockposition);
            }
            float f2 = MathHelper.h(world.A.i(), 0.33f, 0.5f);
            world.a((EntityHuman)null, user.dB(), user.dD(), user.dH(), SoundEffects.iC, SoundCategory.g, 1.0f, f2);
            itemstack.a(1, (EntityLiving)user);
            user.b(StatisticList.c.b(this));
        }
        return EnumInteractionResult.b;
    }
}

