/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> a = Maps.newIdentityHashMap();
    private static final MapCodec<EntityTypes<?>> b = BuiltInRegistries.f.q().fieldOf("id");
    private final int c;
    private final int d;
    private final EntityTypes<?> m;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> type, int primaryColor, int secondaryColor, Item.Info settings) {
        super(settings);
        this.m = type;
        this.c = primaryColor;
        this.d = secondaryColor;
        a.put(type, this);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        World world = context.q();
        if (world.C) {
            return EnumInteractionResult.a;
        }
        ItemStack itemstack = context.n();
        BlockPosition blockposition = context.a();
        EnumDirection enumdirection = context.k();
        IBlockData iblockdata = world.a_(blockposition);
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof Spawner) {
            if (world.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return EnumInteractionResult.d;
            }
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityTypes<?> entitytypes = this.g(itemstack);
            spawner.a(entitytypes, world.H_());
            world.a(blockposition, iblockdata, iblockdata, 3);
            world.a((Entity)context.o(), GameEvent.c, blockposition);
            itemstack.h(1);
            return EnumInteractionResult.a;
        }
        BlockPosition blockposition1 = iblockdata.g(world, blockposition).c() ? blockposition : blockposition.a(enumdirection);
        EntityTypes<?> entitytypes = this.g(itemstack);
        if (entitytypes.a((WorldServer)world, itemstack, context.o(), blockposition1, EntitySpawnReason.m, true, !Objects.equals(blockposition, blockposition1) && enumdirection == EnumDirection.b) != null) {
            itemstack.h(1);
            world.a((Entity)context.o(), GameEvent.t, blockposition);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public EnumInteractionResult a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = user.b(hand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemMonsterEgg.a(world, user, RayTrace.FluidCollisionOption.b);
        if (movingobjectpositionblock.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        if (world.C) {
            return EnumInteractionResult.a;
        }
        BlockPosition blockposition = movingobjectpositionblock.b();
        if (!(world.a_(blockposition).b() instanceof BlockFluids)) {
            return EnumInteractionResult.e;
        }
        if (world.a(user, blockposition) && user.a(blockposition, movingobjectpositionblock.c(), itemstack)) {
            EntityTypes<?> entitytypes = this.g(itemstack);
            Object entity = entitytypes.a((WorldServer)world, itemstack, user, blockposition, EntitySpawnReason.m, false, false);
            if (entity == null) {
                return EnumInteractionResult.e;
            }
            itemstack.a(1, (EntityLiving)user);
            user.b(StatisticList.c.b(this));
            world.a((Entity)user, GameEvent.t, ((Entity)entity).du());
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.d;
    }

    public boolean a(ItemStack stack, EntityTypes<?> type) {
        return Objects.equals(this.g(stack), type);
    }

    public int a(int tintIndex) {
        return tintIndex == 0 ? this.c : this.d;
    }

    @Nullable
    public static ItemMonsterEgg a(@Nullable EntityTypes<?> type) {
        return a.get(type);
    }

    public static Iterable<ItemMonsterEgg> b() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public EntityTypes<?> g(ItemStack stack) {
        CustomData customdata = stack.a(DataComponents.W, CustomData.a);
        return !customdata.b() ? customdata.a(b).result().orElse(this.m) : this.m;
    }

    @Override
    public FeatureFlagSet i() {
        return this.m.i();
    }

    public Optional<EntityInsentient> a(EntityHuman user, EntityInsentient entity, EntityTypes<? extends EntityInsentient> entityType, WorldServer world, Vec3D pos, ItemStack stack) {
        if (!this.a(stack, entityType)) {
            return Optional.empty();
        }
        EntityInsentient object = entity instanceof EntityAgeable ? ((EntityAgeable)entity).a(world, (EntityAgeable)entity) : entityType.a(world, EntitySpawnReason.m);
        if (object == null) {
            return Optional.empty();
        }
        object.a(true);
        if (!object.e_()) {
            return Optional.empty();
        }
        object.b(pos.a(), pos.b(), pos.c(), 0.0f, 0.0f);
        world.addFreshEntityWithPassengers(object, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        object.b(stack.a(DataComponents.g));
        stack.a(1, (EntityLiving)user);
        return Optional.of(object);
    }
}

