/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<ItemStack> a = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::L), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.p.g())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.p.g())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
    public static final Codec<ItemStack> c = a.validate(ItemStack::c);
    public static final Codec<ItemStack> d = b.validate(ItemStack::c);
    public static final Codec<ItemStack> e = ExtraCodecs.f(a).xmap(optional -> optional.orElse(j), itemstack -> itemstack.f() ? Optional.empty() : Optional.of(itemstack));
    public static final Codec<ItemStack> f = Item.e.xmap(ItemStack::new, ItemStack::i);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> g = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> a = ByteBufCodecs.b(Registries.K);

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i2 = registryfriendlybytebuf.l();
            if (i2 <= 0) {
                return j;
            }
            Holder holder = (Holder)a.decode(registryfriendlybytebuf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.c.decode(registryfriendlybytebuf);
            ItemStack itemstack = new ItemStack(holder, i2, datacomponentpatch);
            return itemstack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.f() || itemstack.h() == null) {
                registryfriendlybytebuf.c(0);
            } else {
                registryfriendlybytebuf.c(itemstack.L());
                a.encode(registryfriendlybytebuf, itemstack.i());
                boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                try {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                    DataComponentPatch.c.encode(registryfriendlybytebuf, itemstack.p.g());
                }
                finally {
                    ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                }
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            ItemStack itemstack = (ItemStack)g.decode(registryfriendlybytebuf);
            if (itemstack.f()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.f()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            g.encode(registryfriendlybytebuf, itemstack);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> i = g.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger k = LogUtils.getLogger();
    public static final ItemStack j = new ItemStack((Void)null);
    private static final IChatBaseComponent l = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int m;
    private int n;
    @Deprecated
    @Nullable
    private Item o;
    private PatchedDataComponentMap p;
    @Nullable
    private net.minecraft.world.entity.Entity q;
    private CraftItemStack bukkitStack;

    private static DataResult<ItemStack> c(ItemStack stack) {
        DataResult<Unit> dataresult = ItemStack.a(stack.a());
        return dataresult.isError() ? dataresult.map(unit -> stack) : (stack.L() > stack.k() ? DataResult.error(() -> {
            int i2 = stack.L();
            return "Item stack with stack size of " + i2 + " was larger than maximum: " + stack.k();
        }) : DataResult.success((Object)stack));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> basePacketCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)basePacketCodec.decode(registryfriendlybytebuf);
                if (!itemstack.f()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.H().a(NullOps.a);
                    a.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                basePacketCodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.h().k(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.f() ? this.p : DataComponentMap.a;
    }

    public void c() {
        this.p.f();
    }

    public DataComponentMap d() {
        return !this.f() ? this.h().g() : DataComponentMap.a;
    }

    public DataComponentPatch e() {
        return !this.f() ? this.p.g() : DataComponentPatch.a;
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.a(), 1);
    }

    public ItemStack(Holder<Item> item, int count, DataComponentPatch changes) {
        this(item.a(), count, PatchedDataComponentMap.a(item.a().g(), changes));
    }

    public ItemStack(Holder<Item> itemEntry, int count) {
        this(itemEntry.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this(item, count, new PatchedDataComponentMap(item.j().g()));
    }

    private ItemStack(IMaterial item, int count, PatchedDataComponentMap components) {
        this.o = item.j();
        this.m = count;
        this.p = components;
        this.h().l(this);
    }

    private ItemStack(@Nullable Void v2) {
        this.o = null;
        this.p = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap components) {
        int j2;
        ItemStack itemstack;
        int i2;
        if (components.b(DataComponents.d) && components.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = components.a(DataComponents.al, ItemContainerContents.a);
        Iterator<ItemStack> iterator = itemcontainercontents.d().iterator();
        do {
            if (iterator.hasNext()) continue;
            return DataResult.success((Object)((Object)Unit.a));
        } while ((i2 = (itemstack = iterator.next()).L()) <= (j2 = itemstack.k()));
        int finalI = i2;
        int finalJ = j2;
        return DataResult.error(() -> "Item stack with count of " + finalI + " was larger than maximum: " + finalJ);
    }

    public static Optional<ItemStack> a(HolderLookup.a registries, NBTBase nbt) {
        return a.parse(registries.a(DynamicOpsNBT.a), (Object)nbt).resultOrPartial(s2 -> k.error("Tried to load invalid item: '{}'", s2));
    }

    public static ItemStack a(HolderLookup.a registries, NBTTagCompound nbt) {
        return nbt.g() ? j : ItemStack.a(registries, (NBTBase)nbt).orElse(j);
    }

    public boolean f() {
        return this == j || this.o == Items.a || this.m <= 0;
    }

    public boolean a(FeatureFlagSet enabledFeatures) {
        return this.f() || this.h().a(enabledFeatures);
    }

    public ItemStack a(int amount) {
        int j2 = Math.min(amount, this.L());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack g() {
        if (this.f()) {
            return j;
        }
        ItemStack itemstack = this.v();
        this.e(0);
        return itemstack;
    }

    public Item h() {
        return this.f() ? Items.a : this.o;
    }

    public Holder<Item> i() {
        return this.h().f();
    }

    public boolean a(TagKey<Item> tag) {
        return this.h().f().a(tag);
    }

    public boolean a(Item item) {
        return this.h() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.h().f());
    }

    public boolean a(Holder<Item> itemEntry) {
        return this.h().f() == itemEntry;
    }

    public boolean a(HolderSet<Item> registryEntryList) {
        return registryEntryList.a(this.i());
    }

    public Stream<TagKey<Item>> j() {
        return this.h().f().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult.d enuminteractionresult_d;
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = context.o();
        BlockPosition blockposition = context.a();
        if (entityhuman != null && !entityhuman.gj().e && !this.a(new ShapeDetectorBlock(context.q(), blockposition, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.h();
        DataComponentPatch oldData = this.p.g();
        int oldCount = this.L();
        WorldServer world = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            world.captureBlockStates = true;
            if (item == Items.sm) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.a(context);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.p.g();
        int newCount = this.L();
        this.e(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.h() == Items.sm;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.L() == oldCount && Objects.equals(this.p.g(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                    world.checkCapturedTreeStateForObserverNotify(blockposition, blockstate);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult instanceof EnumInteractionResult.d && (enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).c()) {
            EnumHand enumhand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1 && item != Items.qZ) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.d;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                world.isBlockPlaceCancelled = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.isBlockPlaceCancelled = false;
                world.preventPoiUpdated = false;
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData blockData;
                TileEntity te;
                if (this.L() == oldCount && Objects.equals(this.p.g(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : world.capturedTileEntities.entrySet()) {
                    world.a(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(world, newblockposition, oldBlock, true, context);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.o == Items.vc) {
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).v()) {
                        bp = !world.a_(blockposition).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)te);
                    }
                }
                if (this.o instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = world.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)te;
                            Block updateFlag = world.a_(ItemSign.openSign).b();
                            if (updateFlag instanceof BlockSign) {
                                BlockSign blocksign = (BlockSign)updateFlag;
                                blocksign.openTextEdit(entityhuman, tileentitysign, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.o instanceof ItemBed && (blockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    blockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.o instanceof ItemBlock) {
                    position = new BlockActionContext(context).a();
                    blockData = world.a_(position);
                    SoundEffectType soundeffecttype = blockData.A();
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData state) {
        return this.h().a(this, state);
    }

    public EnumInteractionResult a(net.minecraft.world.level.World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = this.v();
        boolean flag = this.a(user) <= 0;
        EnumInteractionResult enuminteractionresult = this.h().a(world, user, hand);
        if (flag && enuminteractionresult instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d enuminteractionresult_d;
            return enuminteractionresult_d.a((enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult).d() == null ? this.a((EntityLiving)user, itemstack) : enuminteractionresult_d.d().a((EntityLiving)user, itemstack));
        }
        return enuminteractionresult;
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving user) {
        ItemStack itemstack = this.v();
        ItemStack itemstack1 = this.h().a(this, world, user);
        return itemstack1.a(user, itemstack);
    }

    private ItemStack a(EntityLiving user, ItemStack stack) {
        UseRemainder useremainder = stack.a(DataComponents.y);
        UseCooldown usecooldown = stack.a(DataComponents.z);
        int i2 = stack.L();
        ItemStack itemstack1 = this;
        if (useremainder != null) {
            boolean flag = user.fV();
            Objects.requireNonNull(user);
            itemstack1 = useremainder.a(this, i2, flag, user::b);
        }
        if (usecooldown != null) {
            usecooldown.a(stack, user);
        }
        return itemstack1;
    }

    public NBTBase b(HolderLookup.a registries, NBTBase prefix) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)a.encode((Object)this, registries.a(DynamicOpsNBT.a), (Object)prefix).getOrThrow();
    }

    public NBTBase a(HolderLookup.a registries) {
        if (this.f()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)a.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this).getOrThrow();
    }

    public NBTBase b(HolderLookup.a registries) {
        return this.f() ? new NBTTagCompound() : this.b(registries, new NBTTagCompound());
    }

    public int k() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean l() {
        return this.k() > 1 && (!this.m() || !this.n());
    }

    public boolean m() {
        return this.b(DataComponents.d) && !this.b(DataComponents.f) && this.b(DataComponents.e);
    }

    public boolean n() {
        return this.m() && this.o() > 0;
    }

    public int o() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.p());
    }

    public void b(int damage) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(damage, 0, this.p())));
    }

    public int p() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public boolean q() {
        return this.m() && this.o() >= this.p();
    }

    public boolean r() {
        return this.m() && this.o() >= this.p() - 1;
    }

    public void hurtAndBreak(int amount, WorldServer world, @Nullable EntityLiving player, Consumer<Item> breakCallback) {
        this.hurtAndBreak(amount, world, player, breakCallback, false);
    }

    public void hurtAndBreak(int amount, WorldServer world, @Nullable EntityLiving player, Consumer<Item> breakCallback, boolean force) {
        int originalDamage = amount;
        int j2 = this.processDurabilityChange(amount, world, player, force);
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), j2, originalDamage);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (j2 != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return;
            }
            j2 = event.getDamage();
        } else if (player != null) {
            EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
            if (!event.callEvent()) {
                return;
            }
            j2 = event.getDamage();
        }
        if (j2 != 0) {
            this.applyDamage(this.o() + j2, player, breakCallback);
        }
    }

    private int processDurabilityChange(int baseDamage, WorldServer world, @Nullable EntityLiving player) {
        return this.processDurabilityChange(baseDamage, world, player, false);
    }

    private int processDurabilityChange(int baseDamage, WorldServer world, @Nullable EntityLiving player, boolean force) {
        return !this.m() ? 0 : (player instanceof EntityPlayer && player.fV() && !force ? 0 : (baseDamage > 0 ? EnchantmentManager.a(world, this, baseDamage) : baseDamage));
    }

    private void applyDamage(int damage, @Nullable EntityLiving player, Consumer<Item> breakCallback) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.u.a(serverPlayer, this, damage);
        }
        this.b(damage);
        if (this.q()) {
            Item item = this.h();
            if (this.m == 1 && player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
            }
            this.h(1);
            breakCallback.accept(item);
        }
    }

    public void a(int amount, EntityHuman player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            int j2 = this.processDurabilityChange(amount, entityplayer.y(), entityplayer);
            if (j2 == 0) {
                return;
            }
            int k2 = Math.min(this.o() + j2, this.p() - 1);
            this.applyDamage(k2, entityplayer, item -> {});
        }
    }

    public void a(int amount, EntityLiving entity, EnumItemSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, EntityLiving entity, EnumItemSlot slot, boolean force) {
        net.minecraft.world.level.World world = entity.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer1;
                EntityPlayer entityplayer = entityplayer1 = (EntityPlayer)entity;
            } else {
                Object entityplayer = null;
            }
            this.hurtAndBreak(amount, worldserver, entity, item -> {
                if (slot != null) {
                    entity.a((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack a(int amount, IMaterial itemAfterBreaking, EntityLiving entity, EnumItemSlot slot) {
        this.a(amount, entity, slot);
        if (this.f()) {
            ItemStack itemstack = this.b(itemAfterBreaking, 1);
            if (itemstack.m()) {
                itemstack.b(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean s() {
        return this.h().d(this);
    }

    public int t() {
        return this.h().e(this);
    }

    public int u() {
        return this.h().f(this);
    }

    public boolean a(Slot slot, ClickAction clickType, EntityHuman player) {
        return this.h().a(this, slot, clickType, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return this.h().a(this, stack, slot, clickType, player, cursorStackReference);
    }

    public boolean a(EntityLiving target, EntityLiving user) {
        Item item = this.h();
        if (item.a(this, target, user)) {
            if (user instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)user;
                entityhuman.b(StatisticList.c.b(item));
            }
            return true;
        }
        return false;
    }

    public void b(EntityLiving target, EntityLiving user) {
        this.h().b(this, target, user);
    }

    public void a(net.minecraft.world.level.World world, IBlockData state, BlockPosition pos, EntityHuman miner) {
        Item item = this.h();
        if (item.a(this, world, state, pos, miner)) {
            miner.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.h().b(this, state);
    }

    public EnumInteractionResult a(EntityHuman user, EntityLiving entity, EnumHand hand) {
        return this.h().a(this, user, entity, hand);
    }

    public ItemStack v() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.f()) {
            return j;
        }
        ItemStack itemstack = new ItemStack(originalItem ? this.o : this.h(), this.m, this.p.h());
        itemstack.d(this.K());
        return itemstack;
    }

    public ItemStack c(int count) {
        if (this.f()) {
            return j;
        }
        ItemStack itemstack = this.v();
        itemstack.e(count);
        return itemstack;
    }

    public ItemStack a(IMaterial item) {
        return this.a(item, this.L());
    }

    public ItemStack a(IMaterial item, int count) {
        return this.f() ? j : this.b(item, count);
    }

    private ItemStack b(IMaterial item, int count) {
        return new ItemStack(item.j().f(), count, this.p.g());
    }

    public static boolean a(ItemStack left, ItemStack right) {
        return left == right ? true : (left.L() != right.L() ? false : ItemStack.c(left, right));
    }

    @Deprecated
    public static boolean a(List<ItemStack> left, List<ItemStack> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i2 = 0; i2 < left.size(); ++i2) {
            if (ItemStack.a(left.get(i2), right.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack left, ItemStack right) {
        return left.a(right.h());
    }

    public static boolean c(ItemStack stack, ItemStack otherStack) {
        return !stack.a(otherStack.h()) ? false : (stack.f() && otherStack.f() ? true : Objects.equals(stack.p, otherStack.p));
    }

    public static MapCodec<ItemStack> a(String fieldName) {
        return a.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(j), itemstack -> itemstack.f() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int a(@Nullable ItemStack stack) {
        if (stack != null) {
            int i2 = 31 + stack.h().hashCode();
            return 31 * i2 + stack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> stacks) {
        int i2 = 0;
        for (ItemStack itemstack : stacks) {
            i2 = i2 * 31 + ItemStack.a(itemstack);
        }
        return i2;
    }

    public String toString() {
        int i2 = this.L();
        return i2 + " " + String.valueOf(this.h());
    }

    public void a(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.n > 0) {
            --this.n;
        }
        if (this.h() != null) {
            this.h().a(this, world, entity, slot, selected);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.h()), amount);
        this.h().a(this, world, player);
    }

    public void a(net.minecraft.world.level.World world) {
        this.h().a(this, world);
    }

    public int a(EntityLiving user) {
        return this.h().a(this, user);
    }

    public ItemUseAnimation w() {
        return this.h().b(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        ItemStack itemstack1;
        ItemStack itemstack = this.v();
        if (this.h().a(this, world, user, remainingUseTicks) && (itemstack1 = this.a(user, itemstack)) != this) {
            user.a(user.fA(), itemstack1);
        }
    }

    public boolean x() {
        return this.h().d_(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.p.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<? super T> type, @Nullable T value) {
        return this.p.b(type, value);
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> type, T defaultValue, U change, BiFunction<T, U, T> applier) {
        return this.b(type, applier.apply(this.a(type, defaultValue), change));
    }

    @Nullable
    public <T> T a(DataComponentType<T> type, T defaultValue, UnaryOperator<T> applier) {
        T t1 = this.a(type, defaultValue);
        return this.b(type, applier.apply(t1));
    }

    @Nullable
    public <T> T c(DataComponentType<? extends T> type) {
        return this.p.d(type);
    }

    public void a(DataComponentPatch changes) {
        DataComponentPatch datacomponentpatch1 = this.p.g();
        this.p.a(changes);
        Optional optional = ItemStack.c(this).error();
        if (optional.isPresent()) {
            k.error("Failed to apply component patch '{}' to item: '{}'", (Object)changes, (Object)((DataResult.Error)optional.get()).message());
            this.p.b(datacomponentpatch1);
        } else {
            this.h().l(this);
        }
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.v());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void b(DataComponentPatch changes) {
        this.p.a(changes);
        this.h().l(this);
    }

    public void b(DataComponentMap components) {
        this.p.a(components);
        this.h().l(this);
    }

    public IChatBaseComponent y() {
        String s2;
        IChatBaseComponent ichatbasecomponent = this.a(DataComponents.g);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        WrittenBookContent writtenbookcontent = this.a(DataComponents.T);
        if (writtenbookcontent != null && !UtilColor.h(s2 = writtenbookcontent.d().a())) {
            return IChatBaseComponent.b(s2);
        }
        return this.z();
    }

    public IChatBaseComponent z() {
        return this.h().a(this);
    }

    public IChatBaseComponent A() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y()).a(this.C().a());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        return ichatmutablecomponent;
    }

    private <T extends TooltipProvider> void a(DataComponentType<T> componentType, Item.b context, Consumer<IChatBaseComponent> textConsumer, TooltipFlag type) {
        TooltipProvider t0 = (TooltipProvider)this.a(componentType);
        if (t0 != null) {
            t0.a(context, textConsumer, type);
        }
    }

    public List<IChatBaseComponent> a(Item.b context, @Nullable EntityHuman player, TooltipFlag type) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!type.b() && this.b(DataComponents.r)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.A());
        if (!type.a() && !this.b(DataComponents.g) && (mapid = this.a(DataComponents.L)) != null) {
            list.add(ItemWorldMap.a(mapid));
        }
        Objects.requireNonNull(list);
        Consumer<IChatBaseComponent> consumer = list::add;
        if (!this.b(DataComponents.q)) {
            this.h().a(this, context, list, type);
        }
        this.a(DataComponents.ab, context, consumer, type);
        this.a(DataComponents.U, context, consumer, type);
        this.a(DataComponents.I, context, consumer, type);
        this.a(DataComponents.l, context, consumer, type);
        this.a(DataComponents.J, context, consumer, type);
        this.a(DataComponents.j, context, consumer, type);
        this.a(consumer, player);
        this.a(DataComponents.f, context, consumer, type);
        this.a(DataComponents.aa, context, consumer, type);
        this.a(DataComponents.R, context, consumer, type);
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.n);
        if (adventuremodepredicate != null && adventuremodepredicate.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.c);
            adventuremodepredicate.a(consumer);
        }
        if ((adventuremodepredicate1 = this.a(DataComponents.m)) != null && adventuremodepredicate1.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.d);
            adventuremodepredicate1.a(consumer);
        }
        if (type.a()) {
            if (this.n()) {
                list.add(IChatBaseComponent.a("item.durability", this.p() - this.o(), this.p()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.g.b(this.h()).toString()).a(EnumChatFormat.i));
            int i2 = this.p.d();
            if (i2 > 0) {
                list.add(IChatBaseComponent.a("item.components", i2).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.h().a(player.dW().J())) {
            list.add(l);
        }
        return list;
    }

    private void a(Consumer<IChatBaseComponent> textConsumer, @Nullable EntityHuman player) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        if (itemattributemodifiers.c()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.a(equipmentslotgroup, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    if (mutableboolean.isTrue()) {
                        textConsumer.accept(CommonComponents.a);
                        textConsumer.accept(IChatBaseComponent.c("item.modifiers." + equipmentslotgroup.c()).a(EnumChatFormat.h));
                        mutableboolean.setFalse();
                    }
                    this.a(textConsumer, player, (Holder<AttributeBase>)holder, (AttributeModifier)attributemodifier);
                });
            }
        }
    }

    private void a(Consumer<IChatBaseComponent> textConsumer, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
        double d0 = modifier.c();
        boolean flag = false;
        if (player != null) {
            if (modifier.a(Item.g)) {
                d0 += player.i(GenericAttributes.c);
                flag = true;
            } else if (modifier.a(Item.h)) {
                d0 += player.i(GenericAttributes.e);
                flag = true;
            }
        }
        double d1 = modifier.d() != AttributeModifier.Operation.b && modifier.d() != AttributeModifier.Operation.c ? (attribute.a(GenericAttributes.p) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (flag) {
            textConsumer.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(attribute.a().c())})).a(EnumChatFormat.c));
        } else if (d0 > 0.0) {
            textConsumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(true)));
        } else if (d0 < 0.0) {
            textConsumer.accept(IChatBaseComponent.a("attribute.modifier.take." + modifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(-d1), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(false)));
        }
    }

    public boolean B() {
        Boolean obool = this.a(DataComponents.u);
        return obool != null ? obool.booleanValue() : this.h().c_(this);
    }

    public EnumItemRarity C() {
        EnumItemRarity enumitemrarity = this.a(DataComponents.k, EnumItemRarity.a);
        if (!this.E()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> enumitemrarity;
        };
    }

    public boolean D() {
        if (!this.b(DataComponents.C)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.a(DataComponents.l);
        return itemenchantments != null && itemenchantments.d();
    }

    public void a(Holder<Enchantment> enchantment, int level) {
        EnchantmentManager.a(this, (ItemEnchantments.a itemenchantments_a) -> itemenchantments_a.b(enchantment, level));
    }

    public boolean E() {
        return !this.a(DataComponents.l, ItemEnchantments.a).d();
    }

    public ItemEnchantments F() {
        return this.a(DataComponents.l, ItemEnchantments.a);
    }

    public boolean G() {
        return this.q instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity holder) {
        if (!this.f()) {
            this.q = holder;
        }
    }

    @Nullable
    public EntityItemFrame H() {
        return this.q instanceof EntityItemFrame ? (EntityItemFrame)this.I() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity I() {
        return !this.f() ? this.q : null;
    }

    public void a(EquipmentSlotGroup slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemattributemodifiers.a(slot, attributeModifierConsumer);
        EnchantmentManager.a(this, slot, attributeModifierConsumer);
    }

    public void a(EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.o, ItemAttributeModifiers.a);
        itemattributemodifiers.a(slot, attributeModifierConsumer);
        EnchantmentManager.a(this, slot, attributeModifierConsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.o = item;
        DataComponentPatch patch = this.e();
        this.p = new PatchedDataComponentMap(this.o.g());
        this.b(patch);
    }

    public IChatBaseComponent J() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.f()) {
            ichatmutablecomponent1.a(this.C().a()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(ShapeDetectorBlock pos) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        return adventuremodepredicate != null && adventuremodepredicate.a(pos);
    }

    public boolean b(ShapeDetectorBlock pos) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.n);
        return adventuremodepredicate != null && adventuremodepredicate.a(pos);
    }

    public int K() {
        return this.n;
    }

    public void d(int bobbingAnimationTime) {
        this.n = bobbingAnimationTime;
    }

    public int L() {
        return this.f() ? 0 : this.m;
    }

    public void e(int count) {
        this.m = count;
    }

    public void f(int maxCount) {
        if (!this.f() && this.L() > maxCount) {
            this.e(maxCount);
        }
    }

    public void g(int amount) {
        this.e(this.L() + amount);
    }

    public void h(int amount) {
        this.g(-amount);
    }

    public void a(int amount, @Nullable EntityLiving entity) {
        if (!(entity != null && entity.fV() || this == j)) {
            this.h(amount);
        }
    }

    public ItemStack b(int amount, @Nullable EntityLiving entity) {
        ItemStack itemstack = this.c(amount);
        this.a(amount, entity);
        return itemstack;
    }

    public void b(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        Consumable consumable = this.a(DataComponents.x);
        if (consumable != null && consumable.a(remainingUseTicks)) {
            consumable.a(user.dZ(), user, this, 5);
        }
        this.h().a(world, user, this, remainingUseTicks);
    }

    public void a(EntityItem entity) {
        this.h().a(entity);
    }

    public SoundEffect M() {
        return this.h().a();
    }

    public boolean a(DamageSource source) {
        DamageResistant damageresistant = this.a(DataComponents.A);
        return damageresistant == null || !damageresistant.a(source);
    }

    public boolean b(ItemStack ingredient) {
        Repairable repairable = this.a(DataComponents.E);
        return repairable != null && repairable.a(ingredient);
    }
}

