/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class ItemWorldMap
extends Item {
    public static final int a = 128;
    public static final int b = 128;

    public ItemWorldMap(Item.Info settings) {
        super(settings);
    }

    public static ItemStack a(World world, int x2, int z2, byte scale, boolean showIcons, boolean unlimitedTracking) {
        ItemStack itemStack = new ItemStack(Items.sI);
        MapId mapId = ItemWorldMap.a(world, x2, z2, scale, showIcons, unlimitedTracking, world.ah());
        itemStack.b(DataComponents.L, mapId);
        return itemStack;
    }

    @Nullable
    public static WorldMap a(@Nullable MapId id, World world) {
        return id == null ? null : world.a(id);
    }

    @Nullable
    public static WorldMap b(ItemStack map, World world) {
        MapId mapId = map.a(DataComponents.L);
        return ItemWorldMap.a(mapId, world);
    }

    public static MapId a(World world, int x2, int z2, int scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        WorldMap mapItemSavedData = WorldMap.a(x2, z2, (byte)scale, showIcons, unlimitedTracking, dimension);
        MapId mapId = world.w();
        world.a(mapId, mapItemSavedData);
        return mapId;
    }

    public void a(World world, Entity entity, WorldMap state) {
        if (world.ah() == state.e && entity instanceof EntityHuman) {
            int i2 = 1 << state.f;
            int j2 = state.c;
            int k2 = state.d;
            int l2 = MathHelper.a(entity.dB() - (double)j2) / i2 + 64;
            int m2 = MathHelper.a(entity.dH() - (double)k2) / i2 + 64;
            int n2 = 128 / i2;
            if (world.G_().h()) {
                n2 /= 2;
            }
            WorldMap.WorldMapHumanTracker holdingPlayer = state.a((EntityHuman)entity);
            ++holdingPlayer.b;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
            boolean bl = false;
            for (int o2 = l2 - n2 + 1; o2 < l2 + n2; ++o2) {
                if ((o2 & 0xF) != (holdingPlayer.b & 0xF) && !bl) continue;
                bl = false;
                double d2 = 0.0;
                for (int p2 = m2 - n2 - 1; p2 < m2 + n2; ++p2) {
                    double g2;
                    double f2;
                    if (o2 < 0 || p2 < -1 || o2 >= 128 || p2 >= 128) continue;
                    int q2 = MathHelper.h(o2 - l2) + MathHelper.h(p2 - m2);
                    boolean bl2 = q2 > (n2 - 2) * (n2 - 2);
                    int r2 = (j2 / i2 + o2 - 64) * i2;
                    int s2 = (k2 / i2 + p2 - 64) * i2;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk levelChunk = world.getChunkIfLoaded(SectionPosition.a(r2), SectionPosition.a(s2));
                    if (levelChunk == null || levelChunk.E()) continue;
                    int t2 = 0;
                    double e2 = 0.0;
                    if (world.G_().h()) {
                        int u2 = r2 + s2 * 231871;
                        if (((u2 = u2 * u2 * 31287121 + u2 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.j.m().a((IBlockAccess)world, BlockPosition.c), 10);
                        } else {
                            multiset.add((Object)Blocks.b.m().a((IBlockAccess)world, BlockPosition.c), 100);
                        }
                        e2 = 100.0;
                    } else {
                        for (int v2 = 0; v2 < i2; ++v2) {
                            for (int w2 = 0; w2 < i2; ++w2) {
                                IBlockData blockState3;
                                mutableBlockPos.d(r2 + v2, 0, s2 + w2);
                                int x2 = levelChunk.a(HeightMap.Type.b, mutableBlockPos.u(), mutableBlockPos.w()) + 1;
                                if (x2 <= world.L_() + 1) {
                                    blockState3 = Blocks.I.m();
                                } else {
                                    do {
                                        mutableBlockPos.q(--x2);
                                    } while ((blockState3 = levelChunk.a_(mutableBlockPos)).a((IBlockAccess)world, (BlockPosition)mutableBlockPos) == MaterialMapColor.a && x2 > world.L_());
                                    if (x2 > world.L_() && !blockState3.y().c()) {
                                        IBlockData blockState2;
                                        int y2 = x2 - 1;
                                        mutableBlockPos2.g(mutableBlockPos);
                                        do {
                                            mutableBlockPos2.q(y2--);
                                            blockState2 = levelChunk.a_(mutableBlockPos2);
                                            ++t2;
                                        } while (y2 > world.L_() && !blockState2.y().c());
                                        blockState3 = this.a(world, blockState3, mutableBlockPos);
                                    }
                                }
                                state.a(world, mutableBlockPos.u(), mutableBlockPos.w());
                                e2 += (double)x2 / (double)(i2 * i2);
                                multiset.add((Object)blockState3.a((IBlockAccess)world, (BlockPosition)mutableBlockPos));
                            }
                        }
                    }
                    MaterialMapColor mapColor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a);
                    MaterialMapColor.a brightness = mapColor == MaterialMapColor.m ? ((f2 = (double)(t2 /= i2 * i2) * 0.1 + (double)(o2 + p2 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.c : (f2 > 0.9 ? MaterialMapColor.a.a : MaterialMapColor.a.b)) : ((g2 = (e2 - d2) * 4.0 / (double)(i2 + 4) + ((double)(o2 + p2 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.c : (g2 < -0.6 ? MaterialMapColor.a.a : MaterialMapColor.a.b));
                    d2 = e2;
                    if (p2 < 0 || q2 >= n2 * n2 || bl2 && (o2 + p2 & 1) == 0) continue;
                    bl |= state.a(o2, p2, mapColor.b(brightness));
                }
            }
        }
    }

    private IBlockData a(World world, IBlockData state, BlockPosition pos) {
        Fluid fluidState = state.y();
        return !fluidState.c() && !state.c((IBlockAccess)world, pos, EnumDirection.b) ? fluidState.g() : state;
    }

    private static boolean a(boolean[] biomes, int x2, int z2) {
        return biomes[z2 * 128 + x2];
    }

    public static void a(WorldServer world, ItemStack map) {
        WorldMap mapItemSavedData = ItemWorldMap.b(map, world);
        if (mapItemSavedData != null && world.ah() == mapItemSavedData.e) {
            int i2 = 1 << mapItemSavedData.f;
            int j2 = mapItemSavedData.c;
            int k2 = mapItemSavedData.d;
            boolean[] bls = new boolean[16384];
            int l2 = j2 / i2 - 64;
            int m2 = k2 / i2 - 64;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int n2 = 0; n2 < 128; ++n2) {
                for (int o2 = 0; o2 < 128; ++o2) {
                    Holder<BiomeBase> holder = world.a((l2 + o2) * i2, 0, (m2 + n2) * i2);
                    bls[n2 * 128 + o2] = holder.a(BiomeTags.ab);
                }
            }
            for (int p2 = 1; p2 < 127; ++p2) {
                for (int q2 = 1; q2 < 127; ++q2) {
                    int r2 = 0;
                    for (int s2 = -1; s2 < 2; ++s2) {
                        for (int t2 = -1; t2 < 2; ++t2) {
                            if (s2 == 0 && t2 == 0 || !ItemWorldMap.a(bls, p2 + s2, q2 + t2)) continue;
                            ++r2;
                        }
                    }
                    MaterialMapColor.a brightness = MaterialMapColor.a.d;
                    MaterialMapColor mapColor = MaterialMapColor.a;
                    if (ItemWorldMap.a(bls, p2, q2)) {
                        mapColor = MaterialMapColor.p;
                        if (r2 > 7 && q2 % 2 == 0) {
                            switch ((p2 + (int)(MathHelper.a((float)q2 + 0.0f) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    brightness = MaterialMapColor.a.a;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    brightness = MaterialMapColor.a.b;
                                    break;
                                }
                                case 2: {
                                    brightness = MaterialMapColor.a.c;
                                }
                            }
                        } else if (r2 > 7) {
                            mapColor = MaterialMapColor.a;
                        } else if (r2 > 5) {
                            brightness = MaterialMapColor.a.b;
                        } else if (r2 > 3) {
                            brightness = MaterialMapColor.a.a;
                        } else if (r2 > 1) {
                            brightness = MaterialMapColor.a.a;
                        }
                    } else if (r2 > 0) {
                        mapColor = MaterialMapColor.A;
                        brightness = r2 > 3 ? MaterialMapColor.a.b : MaterialMapColor.a.d;
                    }
                    if (mapColor == MaterialMapColor.a) continue;
                    mapItemSavedData.b(p2, q2, mapColor.b(brightness));
                }
            }
        }
    }

    @Override
    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        WorldMap mapItemSavedData;
        if (!world.C && (mapItemSavedData = ItemWorldMap.b(stack, world)) != null) {
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                mapItemSavedData.a(player, stack);
            }
            if (!mapItemSavedData.h && (selected || entity instanceof EntityHuman && ((EntityHuman)entity).fa() == stack)) {
                this.a(world, entity, mapItemSavedData);
            }
        }
    }

    @Override
    public void a(ItemStack stack, World world) {
        MapPostProcessing mapPostProcessing = stack.c(DataComponents.N);
        if (mapPostProcessing != null) {
            switch (mapPostProcessing) {
                case a: {
                    ItemWorldMap.a(world, stack);
                    break;
                }
                case b: {
                    ItemWorldMap.c(stack, world);
                }
            }
        }
    }

    private static void c(ItemStack map, World world) {
        WorldMap mapItemSavedData = ItemWorldMap.b(map, world);
        if (mapItemSavedData != null) {
            MapId mapId = world.w();
            world.a(mapId, mapItemSavedData.e());
            map.b(DataComponents.L, mapId);
        }
    }

    public static void a(World world, ItemStack stack) {
        WorldMap mapItemSavedData = ItemWorldMap.b(stack, world);
        if (mapItemSavedData != null) {
            MapId mapId = world.w();
            WorldMap mapItemSavedData2 = mapItemSavedData.b();
            world.a(mapId, mapItemSavedData2);
            stack.b(DataComponents.L, mapId);
        }
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        MapId mapId = stack.a(DataComponents.L);
        WorldMap mapItemSavedData = mapId != null ? context.a(mapId) : null;
        MapPostProcessing mapPostProcessing = stack.a(DataComponents.N);
        if (mapItemSavedData != null && (mapItemSavedData.h || mapPostProcessing == MapPostProcessing.a)) {
            tooltip.add(IChatBaseComponent.a("filled_map.locked", mapId.b()).a(EnumChatFormat.h));
        }
        if (type.a()) {
            if (mapItemSavedData != null) {
                if (mapPostProcessing == null) {
                    tooltip.add(ItemWorldMap.a(mapId));
                }
                byte i2 = mapPostProcessing == MapPostProcessing.b ? (byte)1 : 0;
                int j2 = Math.min(mapItemSavedData.f + i2, 4);
                tooltip.add(IChatBaseComponent.a("filled_map.scale", 1 << j2).a(EnumChatFormat.h));
                tooltip.add(IChatBaseComponent.a("filled_map.level", j2, 4).a(EnumChatFormat.h));
            } else {
                tooltip.add(IChatBaseComponent.c("filled_map.unknown").a(EnumChatFormat.h));
            }
        }
    }

    public static IChatBaseComponent a(MapId id) {
        return IChatBaseComponent.a("filled_map.id", id.b()).a(EnumChatFormat.h);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        IBlockData blockState = context.q().a_(context.a());
        if (blockState.a(TagsBlock.I)) {
            WorldMap mapItemSavedData;
            if (!context.q().C && (mapItemSavedData = ItemWorldMap.b(context.n(), context.q())) != null && !mapItemSavedData.a((GeneratorAccess)context.q(), context.a())) {
                return EnumInteractionResult.d;
            }
            return EnumInteractionResult.a;
        }
        return super.a(context);
    }
}

