/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;

public class MobBucketItem
extends ItemBucket {
    private static final MapCodec<EntityTropicalFish.d> a = EntityTropicalFish.d.a.fieldOf("BucketVariantTag");
    private final EntityTypes<?> b;
    private final SoundEffect c;

    public MobBucketItem(EntityTypes<?> type, FluidType fluid, SoundEffect emptyingSound, Item.Info settings) {
        super(fluid, settings);
        this.b = type;
        this.c = emptyingSound;
    }

    @Override
    @Override
    public void a(@Nullable EntityHuman player, World world, ItemStack stack, BlockPosition pos) {
        if (world instanceof WorldServer) {
            this.a((WorldServer)world, stack, pos);
            world.a((Entity)player, GameEvent.t, pos);
        }
    }

    @Override
    @Override
    protected void a(@Nullable EntityHuman player, GeneratorAccess world, BlockPosition pos) {
        world.a(player, pos, this.c, SoundCategory.g, 1.0f, 1.0f);
    }

    private void a(WorldServer world, ItemStack stack, BlockPosition pos) {
        Object entity = this.b.b(world, EntityTypes.a(world, stack, null), pos, EntitySpawnReason.l, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            CustomData customData = stack.a(DataComponents.X, CustomData.a);
            bucketable.h(customData.c());
            bucketable.x(true);
        }
        if (entity != null) {
            world.a_((Entity)entity);
        }
    }

    @Override
    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        if (this.b == EntityTypes.bA) {
            CustomData customData = stack.a(DataComponents.X, CustomData.a);
            if (customData.b()) {
                return;
            }
            Optional optional = customData.a(a).result();
            if (optional.isPresent()) {
                EntityTropicalFish.d variant = (EntityTropicalFish.d)optional.get();
                EnumChatFormat[] chatFormattings = new EnumChatFormat[]{EnumChatFormat.u, EnumChatFormat.h};
                String string = "color.minecraft." + String.valueOf(variant.c());
                String string2 = "color.minecraft." + String.valueOf(variant.d());
                int i2 = EntityTropicalFish.b.indexOf(variant);
                if (i2 != -1) {
                    tooltip.add(IChatBaseComponent.c(EntityTropicalFish.b(i2)).a(chatFormattings));
                    return;
                }
                tooltip.add(variant.b().d().e().a(chatFormattings));
                IChatMutableComponent mutableComponent = IChatBaseComponent.c(string);
                if (!string.equals(string2)) {
                    mutableComponent.f(", ").b(IChatBaseComponent.c(string2));
                }
                mutableComponent.a(chatFormattings);
                tooltip.add(mutableComponent);
            }
        }
    }
}

