/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    public static final PotionBrewer b = new PotionBrewer(List.of(), List.of(), List.of());
    private final List<RecipeItemStack> c;
    private final List<PredicatedCombination<PotionRegistry>> d;
    private final List<PredicatedCombination<Item>> e;
    private final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> customMixes = new Object2ObjectLinkedOpenHashMap();

    PotionBrewer(List<RecipeItemStack> potionTypes, List<PredicatedCombination<PotionRegistry>> potionRecipes, List<PredicatedCombination<Item>> itemRecipes) {
        this.c = potionTypes;
        this.d = potionRecipes;
        this.e = itemRecipes;
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) || this.c(stack) || this.isCustomIngredient(stack);
    }

    private boolean d(ItemStack stack) {
        for (RecipeItemStack ingredient : this.c) {
            if (!ingredient.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean b(ItemStack stack) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack stack) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.c.a(potion)) continue;
            return true;
        }
        return false;
    }

    public boolean a(ItemStack input, ItemStack ingredient) {
        if (this.hasCustomMix(input, ingredient)) {
            return true;
        }
        return this.d(input) && (this.b(input, ingredient) || this.c(input, ingredient));
    }

    public boolean b(ItemStack input, ItemStack ingredient) {
        for (PredicatedCombination<Item> mix : this.e) {
            if (!input.a(mix.a) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ItemStack input, ItemStack ingredient) {
        Optional<Holder<PotionRegistry>> optional = input.a(DataComponents.Q, PotionContents.a).e();
        if (optional.isEmpty()) {
            return false;
        }
        for (PredicatedCombination<PotionRegistry> mix : this.d) {
            if (!mix.a.a(optional.get()) || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public ItemStack d(ItemStack ingredient, ItemStack input) {
        if (input.f()) {
            return input;
        }
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return mix.result().v();
        }
        Optional<Holder<PotionRegistry>> optional = input.a(DataComponents.Q, PotionContents.a).e();
        if (optional.isEmpty()) {
            return input;
        }
        for (PredicatedCombination<Item> predicatedCombination : this.e) {
            if (!input.a(predicatedCombination.a) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a((Item)predicatedCombination.c.a(), optional.get());
        }
        for (PredicatedCombination<FeatureElement> predicatedCombination : this.d) {
            if (!predicatedCombination.a.a(optional.get()) || !predicatedCombination.b.a(ingredient)) continue;
            return PotionContents.a(input.h(), predicatedCombination.c);
        }
        return input;
    }

    public static PotionBrewer a(FeatureFlagSet enabledFeatures) {
        a builder = new a(enabledFeatures);
        PotionBrewer.a(builder);
        return builder.a();
    }

    public static void a(a builder) {
        builder.a(Items.sZ);
        builder.a(Items.we);
        builder.a(Items.wh);
        builder.a(Items.sZ, Items.pQ, Items.we);
        builder.a(Items.we, Items.wd, Items.wh);
        builder.a(Potions.a, Items.rM, Potions.c);
        builder.a(Potions.a, Items.lV, Potions.b);
        builder.a(Potions.a, Items.sX, Potions.d);
        builder.a(Items.uQ, Potions.Q);
        builder.a(Items.mc, Potions.S);
        builder.a(Items.b, Potions.T);
        builder.a(Items.cT, Potions.R);
        builder.a(Potions.d, Items.va, Potions.e);
        builder.a(Potions.e, Items.lV, Potions.f);
        builder.a(Potions.e, Items.tb, Potions.g);
        builder.a(Potions.f, Items.tb, Potions.h);
        builder.a(Potions.g, Items.lV, Potions.h);
        builder.a(Items.td, Potions.l);
        builder.a(Potions.l, Items.lV, Potions.m);
        builder.a(Items.vt, Potions.i);
        builder.a(Potions.i, Items.lV, Potions.j);
        builder.a(Potions.i, Items.rM, Potions.k);
        builder.a(Potions.i, Items.tb, Potions.q);
        builder.a(Potions.j, Items.tb, Potions.r);
        builder.a(Potions.q, Items.lV, Potions.r);
        builder.a(Potions.q, Items.rM, Potions.s);
        builder.a(Potions.d, Items.oK, Potions.t);
        builder.a(Potions.t, Items.lV, Potions.u);
        builder.a(Potions.t, Items.rM, Potions.v);
        builder.a(Potions.n, Items.tb, Potions.q);
        builder.a(Potions.o, Items.tb, Potions.r);
        builder.a(Items.so, Potions.n);
        builder.a(Potions.n, Items.lV, Potions.o);
        builder.a(Potions.n, Items.rM, Potions.p);
        builder.a(Potions.d, Items.rQ, Potions.w);
        builder.a(Potions.w, Items.lV, Potions.x);
        builder.a(Items.th, Potions.y);
        builder.a(Potions.y, Items.rM, Potions.z);
        builder.a(Potions.y, Items.tb, Potions.A);
        builder.a(Potions.z, Items.tb, Potions.B);
        builder.a(Potions.A, Items.rM, Potions.B);
        builder.a(Potions.C, Items.tb, Potions.A);
        builder.a(Potions.D, Items.tb, Potions.A);
        builder.a(Potions.E, Items.tb, Potions.B);
        builder.a(Items.ta, Potions.C);
        builder.a(Potions.C, Items.lV, Potions.D);
        builder.a(Potions.C, Items.rM, Potions.E);
        builder.a(Items.sV, Potions.F);
        builder.a(Potions.F, Items.lV, Potions.G);
        builder.a(Potions.F, Items.rM, Potions.H);
        builder.a(Items.tc, Potions.I);
        builder.a(Potions.I, Items.lV, Potions.J);
        builder.a(Potions.I, Items.rM, Potions.K);
        builder.a(Potions.a, Items.tb, Potions.L);
        builder.a(Potions.L, Items.lV, Potions.M);
        builder.a(Potions.d, Items.om, Potions.O);
        builder.a(Potions.O, Items.lV, Potions.P);
    }

    public boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.ingredient().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : this.customMixes.values()) {
            if (!mix.input().test(input) || !mix.ingredient().test(ingredient)) continue;
            return true;
        }
        return false;
    }

    public void addPotionMix(PotionMix mix) {
        if (this.customMixes.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + String.valueOf(mix.getKey()));
        }
        this.customMixes.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public boolean removePotionMix(NamespacedKey key) {
        return this.customMixes.remove((Object)key) != null;
    }

    public PotionBrewer reload(FeatureFlagSet flags) {
        return PotionBrewer.a(flags);
    }

    record PredicatedCombination<T>(Holder<T> a, RecipeItemStack b, Holder<T> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PredicatedCombination.class, "from;ingredient;to", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final List<RecipeItemStack> a = new ArrayList<RecipeItemStack>();
        private final List<PredicatedCombination<PotionRegistry>> b = new ArrayList<PredicatedCombination<PotionRegistry>>();
        private final List<PredicatedCombination<Item>> c = new ArrayList<PredicatedCombination<Item>>();
        private final FeatureFlagSet d;

        public a(FeatureFlagSet enabledFeatures) {
            this.d = enabledFeatures;
        }

        private static void b(Item potionType) {
            if (!(potionType instanceof ItemPotion)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.g.b(potionType)));
            }
        }

        public void a(Item input, Item ingredient, Item output) {
            if (input.a(this.d) && ingredient.a(this.d) && output.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(input);
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(output);
                this.c.add(new PredicatedCombination<Item>(input.f(), RecipeItemStack.a((IMaterial)ingredient), output.f()));
            }
        }

        public void a(Item item) {
            if (item.a(this.d)) {
                net.minecraft.world.item.alchemy.PotionBrewer$a.b(item);
                this.a.add(RecipeItemStack.a((IMaterial)item));
            }
        }

        public void a(Holder<PotionRegistry> input, Item ingredient, Holder<PotionRegistry> output) {
            if (input.a().a(this.d) && ingredient.a(this.d) && output.a().a(this.d)) {
                this.b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a((IMaterial)ingredient), output));
            }
        }

        public void a(Item ingredient, Holder<PotionRegistry> potion) {
            if (potion.a().a(this.d)) {
                this.a(Potions.a, ingredient, Potions.b);
                this.a(Potions.d, ingredient, potion);
            }
        }

        public PotionBrewer a() {
            return new PotionBrewer(List.copyOf(this.a), List.copyOf(this.b), List.copyOf(this.c));
        }
    }
}

