/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record PotionContents(Optional<Holder<PotionRegistry>> d, Optional<Integer> e, List<MobEffect> f, Optional<String> g) implements ConsumableListener
{
    private final Optional<Holder<PotionRegistry>> d;
    private final Optional<Integer> e;
    private final List<MobEffect> f;
    public static final PotionContents a = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final IChatBaseComponent h = IChatBaseComponent.c("effect.none").a(EnumChatFormat.h);
    private static final int i = -13083194;
    private static final Codec<PotionContents> j = RecordCodecBuilder.create(instance -> instance.group((App)PotionRegistry.a.optionalFieldOf("potion").forGetter(PotionContents::e), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::f), (App)MobEffect.d.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::d), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::g)).apply((Applicative)instance, PotionContents::new));
    public static final Codec<PotionContents> b = Codec.withAlternative(j, PotionRegistry.a, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> c = StreamCodec.a(PotionRegistry.b.a(ByteBufCodecs::a), PotionContents::e, ByteBufCodecs.g.a(ByteBufCodecs::a), PotionContents::f, MobEffect.e.a(ByteBufCodecs.a()), PotionContents::d, ByteBufCodecs.o.a(ByteBufCodecs::a), PotionContents::g, PotionContents::new);

    public PotionContents(Holder<PotionRegistry> potion) {
        this(Optional.of(potion), Optional.empty(), List.of(), Optional.empty());
    }

    public static ItemStack a(Item item, Holder<PotionRegistry> potion) {
        ItemStack itemstack = new ItemStack(item);
        itemstack.b(DataComponents.Q, new PotionContents(potion));
        return itemstack;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        return this.d.isPresent() && this.d.get().a(potion) && this.f.isEmpty();
    }

    public Iterable<MobEffect> a() {
        return this.d.isEmpty() ? this.f : (this.f.isEmpty() ? this.d.get().a().a() : Iterables.concat(this.d.get().a().a(), this.f));
    }

    public void a(Consumer<MobEffect> effectConsumer) {
        if (this.d.isPresent()) {
            for (MobEffect mobeffect : this.d.get().a().a()) {
                effectConsumer.accept(new MobEffect(mobeffect));
            }
        }
        for (MobEffect mobeffect : this.f) {
            effectConsumer.accept(new MobEffect(mobeffect));
        }
    }

    public PotionContents b(Holder<PotionRegistry> potion) {
        return new PotionContents(Optional.of(potion), this.e, this.f, this.g);
    }

    public PotionContents a(MobEffect customEffect) {
        return new PotionContents(this.d, this.e, SystemUtils.a(this.f, customEffect), this.g);
    }

    public int b() {
        return this.e.isPresent() ? this.e.get() : PotionContents.a(this.a());
    }

    public static int c(Holder<PotionRegistry> potion) {
        return PotionContents.a(potion.a().a());
    }

    public static int a(Iterable<MobEffect> effects) {
        return PotionContents.b(effects).orElse(-13083194);
    }

    public IChatBaseComponent a(String prefix) {
        String s1 = this.g.or(() -> this.d.map(holder -> ((PotionRegistry)holder.a()).b())).orElse("empty");
        return IChatBaseComponent.c(prefix + s1);
    }

    public static OptionalInt b(Iterable<MobEffect> effects) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (MobEffect mobeffect : effects) {
            if (!mobeffect.g()) continue;
            int i1 = mobeffect.c().a().g();
            int j1 = mobeffect.e() + 1;
            i2 += j1 * ARGB.b(i1);
            j2 += j1 * ARGB.c(i1);
            k2 += j1 * ARGB.d(i1);
            l2 += j1;
        }
        if (l2 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ARGB.a(i2 / l2, j2 / l2, k2 / l2));
    }

    public boolean c() {
        return !this.f.isEmpty() ? true : this.d.isPresent() && !this.d.get().a().a().isEmpty();
    }

    public List<MobEffect> d() {
        return Lists.transform(this.f, MobEffect::new);
    }

    public void a(Consumer<IChatBaseComponent> textConsumer, float durationMultiplier, float tickRate) {
        PotionContents.a(this.a(), textConsumer, durationMultiplier, tickRate);
    }

    public void a(EntityLiving user) {
        World world = user.dW();
        if (world instanceof WorldServer) {
            EntityHuman entityhuman1;
            WorldServer worldserver = (WorldServer)world;
            EntityHuman entityhuman = user instanceof EntityHuman ? (entityhuman1 = (EntityHuman)user) : null;
            EntityHuman entityhuman2 = entityhuman;
            this.a((MobEffect mobeffect) -> {
                if (mobeffect.c().a().a()) {
                    mobeffect.c().a().a(worldserver, entityhuman2, entityhuman2, user, mobeffect.e(), 1.0);
                } else {
                    user.addEffect((MobEffect)mobeffect, EntityPotionEffectEvent.Cause.POTION_DRINK);
                }
            });
        }
    }

    public static void a(Iterable<MobEffect> effects, Consumer<IChatBaseComponent> textConsumer, float durationMultiplier, float tickRate) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffect mobeffect : effects) {
            flag = false;
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c(mobeffect.i());
            Holder<MobEffectList> holder = mobeffect.c();
            holder.a().a(mobeffect.e(), (holder1, attributemodifier) -> list.add(new Pair(holder1, attributemodifier)));
            if (mobeffect.e() > 0) {
                ichatmutablecomponent = IChatBaseComponent.a("potion.withAmplifier", ichatmutablecomponent, IChatBaseComponent.c("potion.potency." + mobeffect.e()));
            }
            if (!mobeffect.a(20)) {
                ichatmutablecomponent = IChatBaseComponent.a("potion.withDuration", ichatmutablecomponent, MobEffectUtil.a(mobeffect, durationMultiplier, tickRate));
            }
            textConsumer.accept(ichatmutablecomponent.a(holder.a().f().a()));
        }
        if (flag) {
            textConsumer.accept(h);
        }
        if (!list.isEmpty()) {
            textConsumer.accept(CommonComponents.a);
            textConsumer.accept(IChatBaseComponent.c("potion.whenDrank").a(EnumChatFormat.f));
            for (Pair pair : list) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.c();
                double d1 = attributemodifier2.d() != AttributeModifier.Operation.b && attributemodifier2.d() != AttributeModifier.Operation.c ? attributemodifier2.c() : attributemodifier2.c() * 100.0;
                if (d0 > 0.0) {
                    textConsumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier2.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.j));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                textConsumer.accept(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier2.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1 *= -1.0), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.m));
            }
        }
    }

    @Override
    public void a(World world, EntityLiving user, ItemStack stack, Consumable consumable) {
        this.a(user);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "d", "e", "f", "g"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "d", "e", "f", "g"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "d", "e", "f", "g"}, this, o2);
    }

    public Optional<Holder<PotionRegistry>> e() {
        return this.d;
    }

    public Optional<Integer> f() {
        return this.e;
    }
}

