/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents a = new BundleContents(List.of());
    public static final Codec<BundleContents> b = ItemStack.a.listOf().flatXmap(BundleContents::a, component -> DataResult.success(component.g));
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> c = ItemStack.h.a(ByteBufCodecs.a()).a(BundleContents::new, component -> component.g);
    private static final Fraction e = Fraction.getFraction((int)1, (int)16);
    private static final int f = -1;
    public static final int d = -1;
    final List<ItemStack> g;
    final Fraction h;
    final int i;

    BundleContents(List<ItemStack> stacks, Fraction occupancy, int selectedStackIndex) {
        this.g = stacks;
        this.h = occupancy;
        this.i = selectedStackIndex;
    }

    private static DataResult<BundleContents> a(List<ItemStack> stacks) {
        try {
            Fraction fraction = BundleContents.b(stacks);
            return DataResult.success((Object)new BundleContents(stacks, fraction, -1));
        }
        catch (ArithmeticException arithmeticException) {
            return DataResult.error(() -> "Excessive total bundle weight");
        }
    }

    public BundleContents(List<ItemStack> stacks) {
        this(stacks, BundleContents.b(stacks), -1);
    }

    private static Fraction b(List<ItemStack> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemStack : stacks) {
            fraction = fraction.add(BundleContents.b(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.L(), (int)1)));
        }
        return fraction;
    }

    static Fraction b(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.P);
        if (bundleContents != null) {
            return e.add(bundleContents.f());
        }
        List list = stack.a(DataComponents.an, List.of());
        if (!list.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)stack.k());
    }

    public static boolean a(ItemStack stack) {
        return !stack.f() && stack.h().e();
    }

    public int a() {
        int i2 = this.e();
        int j2 = i2 > 12 ? 11 : 12;
        int k2 = i2 % 4;
        int l2 = k2 == 0 ? 0 : 4 - k2;
        return Math.min(i2, j2 - l2);
    }

    public ItemStack a(int index) {
        return this.g.get(index);
    }

    public Stream<ItemStack> b() {
        return this.g.stream().map(ItemStack::v);
    }

    public Iterable<ItemStack> c() {
        return this.g;
    }

    public Iterable<ItemStack> d() {
        return Lists.transform(this.g, ItemStack::v);
    }

    public int e() {
        return this.g.size();
    }

    public Fraction f() {
        return this.h;
    }

    public boolean g() {
        return this.g.isEmpty();
    }

    public int h() {
        return this.i;
    }

    public boolean i() {
        return this.i != -1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BundleContents) {
            BundleContents bundleContents = (BundleContents)object;
            return this.h.equals((Object)bundleContents.h) && ItemStack.a(this.g, bundleContents.g);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ItemStack.a(this.g);
    }

    @Override
    public String toString() {
        return "BundleContents" + String.valueOf(this.g);
    }

    public static class a {
        private final List<ItemStack> a;
        private Fraction b;
        private int c;

        public a(BundleContents base) {
            this.a = new ArrayList<ItemStack>(base.g);
            this.b = base.h;
            this.c = base.i;
        }

        public a a() {
            this.a.clear();
            this.b = Fraction.ZERO;
            this.c = -1;
            return this;
        }

        private int b(ItemStack stack) {
            if (!stack.l()) {
                return -1;
            }
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                if (!ItemStack.c(this.a.get(i2), stack)) continue;
                return i2;
            }
            return -1;
        }

        private int c(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.b);
            return Math.max(fraction.divideBy(BundleContents.b(stack)).intValue(), 0);
        }

        public int a(ItemStack stack) {
            if (!BundleContents.a(stack)) {
                return 0;
            }
            int i2 = Math.min(stack.L(), this.c(stack));
            if (i2 == 0) {
                return 0;
            }
            this.b = this.b.add(BundleContents.b(stack).multiplyBy(Fraction.getFraction((int)i2, (int)1)));
            int j2 = this.b(stack);
            if (j2 != -1) {
                ItemStack itemStack = this.a.remove(j2);
                ItemStack itemStack2 = itemStack.c(itemStack.L() + i2);
                stack.h(i2);
                this.a.add(0, itemStack2);
            } else {
                this.a.add(0, stack.a(i2));
            }
            return i2;
        }

        public int a(Slot slot, EntityHuman player) {
            ItemStack itemStack = slot.g();
            int i2 = this.c(itemStack);
            return BundleContents.a(itemStack) ? this.a(slot.b(itemStack.L(), i2, player)) : 0;
        }

        public void a(int selectedStackIndex) {
            this.c = this.c == selectedStackIndex || selectedStackIndex >= this.a.size() ? -1 : selectedStackIndex;
        }

        @Nullable
        public ItemStack b() {
            if (this.a.isEmpty()) {
                return null;
            }
            int i2 = this.c == -1 || this.c >= this.a.size() ? 0 : this.c;
            ItemStack itemStack = this.a.remove(i2).v();
            this.b = this.b.subtract(BundleContents.b(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.L(), (int)1)));
            this.a(-1);
            return itemStack;
        }

        public Fraction c() {
            return this.b;
        }

        public BundleContents d() {
            return new BundleContents(List.copyOf(this.a), this.b, this.c);
        }
    }
}

