/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class Consumable
extends Record {
    private final float d;
    private final ItemUseAnimation e;
    private final Holder<SoundEffect> f;
    private final boolean g;
    private final List<ConsumeEffect> h;
    public static final float a = 1.6f;
    private static final int i = 4;
    private static final float j = 0.21875f;
    public static final Codec<Consumable> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.n.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::c), (App)ItemUseAnimation.k.optionalFieldOf("animation", (Object)ItemUseAnimation.b).forGetter(Consumable::d), (App)SoundEffect.b.optionalFieldOf("sound", SoundEffects.kx).forGetter(Consumable::e), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::f), (App)ConsumeEffect.d.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::g)).apply((Applicative)instance, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> c = StreamCodec.a(ByteBufCodecs.l, Consumable::c, ItemUseAnimation.l, Consumable::d, SoundEffect.d, Consumable::e, ByteBufCodecs.b, Consumable::f, ConsumeEffect.e.a(ByteBufCodecs.a()), Consumable::g, Consumable::new);

    public Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEffect> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
        this.d = consumeSeconds;
        this.e = animation;
        this.f = sound;
        this.g = hasConsumeParticles;
        this.h = onConsumeEffects;
    }

    public EnumInteractionResult a(EntityLiving user, ItemStack stack, EnumHand hand) {
        boolean flag;
        if (!this.a(user, stack)) {
            return EnumInteractionResult.d;
        }
        boolean bl = flag = this.a() > 0;
        if (flag) {
            user.c(hand);
            return EnumInteractionResult.c;
        }
        ItemStack itemstack1 = this.a(user.dW(), user, stack);
        return EnumInteractionResult.c.a(itemstack1);
    }

    public ItemStack a(World world, EntityLiving user, ItemStack stack) {
        RandomSource randomsource = user.dZ();
        this.a(randomsource, user, stack, 16);
        if (user instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)user;
            entityplayer.b(StatisticList.c.b(stack.h()));
            CriterionTriggers.A.a(entityplayer, stack);
        }
        stack.a(ConsumableListener.class).forEach(consumablelistener -> consumablelistener.a(world, user, stack, this));
        if (!world.C) {
            EntityPotionEffectEvent.Cause cause = stack.a(Items.rc) ? EntityPotionEffectEvent.Cause.MILK : (stack.a(Items.sZ) ? EntityPotionEffectEvent.Cause.POTION_DRINK : EntityPotionEffectEvent.Cause.FOOD);
            this.h.forEach(consumeeffect -> consumeeffect.apply(world, stack, user, cause));
        }
        ((Entity)user).a(this.e == ItemUseAnimation.c ? GameEvent.l : GameEvent.m);
        stack.a(1, user);
        return stack;
    }

    public void cancelUsingItem(EntityPlayer entityplayer, ItemStack itemstack) {
        ObjectArrayList packets = new ObjectArrayList();
        itemstack.a(ConsumableListener.class).forEach(arg_0 -> Consumable.lambda$cancelUsingItem$3(entityplayer, itemstack, (List)packets, arg_0));
        entityplayer.g.ag().sendActiveEffects(entityplayer, ((List)packets)::add);
        entityplayer.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)packets));
    }

    public boolean a(EntityLiving user, ItemStack stack) {
        FoodInfo foodinfo = stack.a(DataComponents.w);
        if (foodinfo != null && user instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)user;
            return entityhuman.u(foodinfo.c());
        }
        return true;
    }

    public int a() {
        return (int)(this.d * 20.0f);
    }

    public void a(RandomSource random, EntityLiving user, ItemStack stack, int particleCount) {
        SoundEffect soundeffect;
        float f5;
        float f2 = random.h() ? 0.5f : 1.0f;
        float f1 = random.a(1.0f, 0.2f);
        float f22 = 0.5f;
        float f3 = MathHelper.b(random, 0.9f, 1.0f);
        float f4 = this.e == ItemUseAnimation.c ? 0.5f : f2;
        float f6 = f5 = this.e == ItemUseAnimation.c ? f3 : f1;
        if (this.g) {
            user.b(stack, particleCount);
        }
        if (user instanceof b) {
            b consumable_b = (b)((Object)user);
            soundeffect = consumable_b.j(stack);
        } else {
            soundeffect = this.f.a();
        }
        SoundEffect soundeffect1 = soundeffect;
        user.a(soundeffect1, f4, f5);
    }

    public boolean a(int remainingUseTicks) {
        int k2;
        int j2 = this.a() - remainingUseTicks;
        boolean flag = j2 > (k2 = (int)((float)this.a() * 0.21875f));
        return flag && remainingUseTicks % 4 == 0;
    }

    public static a b() {
        return new a();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this, o2);
    }

    public float c() {
        return this.d;
    }

    public ItemUseAnimation d() {
        return this.e;
    }

    public Holder<SoundEffect> e() {
        return this.f;
    }

    public boolean f() {
        return this.g;
    }

    public List<ConsumeEffect> g() {
        return this.h;
    }

    private static /* synthetic */ void lambda$cancelUsingItem$3(EntityPlayer entityplayer, ItemStack itemstack, List packets, ConsumableListener consumablelistener) {
        consumablelistener.cancelUsingItem(entityplayer, itemstack, packets);
    }

    public static interface b {
        public SoundEffect j(ItemStack var1);
    }

    public static class a {
        private float a = 1.6f;
        private ItemUseAnimation b = ItemUseAnimation.b;
        private Holder<SoundEffect> c = SoundEffects.kx;
        private boolean d = true;
        private final List<ConsumeEffect> e = new ArrayList<ConsumeEffect>();

        a() {
        }

        public a a(float consumeSeconds) {
            this.a = consumeSeconds;
            return this;
        }

        public a a(ItemUseAnimation useAction) {
            this.b = useAction;
            return this;
        }

        public a a(Holder<SoundEffect> sound) {
            this.c = sound;
            return this;
        }

        public a b(Holder<SoundEffect> finishSound) {
            return this.a(new PlaySoundConsumeEffect(finishSound));
        }

        public a a(boolean consumeParticles) {
            this.d = consumeParticles;
            return this;
        }

        public a a(ConsumeEffect consumeEffect) {
            this.e.add(consumeEffect);
            return this;
        }

        public Consumable a() {
            return new Consumable(this.a, this.b, this.c, this.d, this.e);
        }
    }
}

