/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import org.slf4j.Logger;

public final class CustomData {
    private static final Logger e = LogUtils.getLogger();
    public static final CustomData a = new CustomData(new NBTTagCompound());
    public static ThreadLocal<Boolean> SERIALIZE_CUSTOM_AS_SNBT = ThreadLocal.withInitial(() -> false);
    public static final Codec<CustomData> b = Codec.either(NBTTagCompound.a, MojangsonParser.i).xmap(Either::unwrap, data -> {
        if (!SERIALIZE_CUSTOM_AS_SNBT.get().booleanValue()) {
            return Either.left(data);
        }
        return Either.right(data);
    }).xmap(CustomData::new, component -> component.f);
    public static final Codec<CustomData> c = b.validate(component -> component.d().b("id", 8) ? DataResult.success((Object)component) : DataResult.error(() -> "Missing id for entity in: " + String.valueOf(component)));
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> d = ByteBufCodecs.r.a(CustomData::new, (? super O component) -> component.f);
    private final NBTTagCompound f;

    private CustomData(NBTTagCompound nbt) {
        this.f = nbt;
    }

    public static CustomData a(NBTTagCompound nbt) {
        return new CustomData(nbt.i());
    }

    public static Predicate<ItemStack> a(DataComponentType<CustomData> type, NBTTagCompound nbt) {
        return stack -> {
            CustomData customData = stack.a(type, a);
            return customData.b(nbt);
        };
    }

    public boolean b(NBTTagCompound nbt) {
        return GameProfileSerializer.a((NBTBase)nbt, this.f, true);
    }

    public static void a(DataComponentType<CustomData> type, ItemStack stack, Consumer<NBTTagCompound> nbtSetter) {
        CustomData customData = stack.a(type, a).a(nbtSetter);
        if (customData.f.g()) {
            stack.c(type);
        } else {
            stack.b(type, customData);
        }
    }

    public static void a(DataComponentType<CustomData> type, ItemStack stack, NBTTagCompound nbt) {
        if (!nbt.g()) {
            stack.b(type, CustomData.a(nbt));
        } else {
            stack.c(type);
        }
    }

    public CustomData a(Consumer<NBTTagCompound> nbtConsumer) {
        NBTTagCompound compoundTag = this.f.i();
        nbtConsumer.accept(compoundTag);
        return new CustomData(compoundTag);
    }

    public void a(Entity entity) {
        NBTTagCompound compoundTag = entity.f(new NBTTagCompound());
        UUID uUID = entity.cG();
        compoundTag.a(this.f);
        entity.g(compoundTag);
        entity.a_(uUID);
    }

    public boolean a(TileEntity blockEntity, HolderLookup.a registries) {
        NBTTagCompound compoundTag = blockEntity.e(registries);
        NBTTagCompound compoundTag2 = compoundTag.i();
        compoundTag.a(this.f);
        if (!compoundTag.equals(compoundTag2)) {
            try {
                blockEntity.d(compoundTag, registries);
                blockEntity.e();
                return true;
            }
            catch (Exception var8) {
                e.warn("Failed to apply custom data to block entity at {}", (Object)blockEntity.aB_(), (Object)var8);
                try {
                    blockEntity.d(compoundTag2, registries);
                }
                catch (Exception var7) {
                    e.warn("Failed to rollback block entity at {} after failure", (Object)blockEntity.aB_(), (Object)var7);
                }
            }
        }
        return false;
    }

    public <T> DataResult<CustomData> a(DynamicOps<NBTBase> ops, MapEncoder<T> encoder, T value) {
        return encoder.encode(value, ops, ops.mapBuilder()).build((Object)this.f).map(nbt -> new CustomData((NBTTagCompound)nbt));
    }

    public <T> DataResult<T> a(MapDecoder<T> decoder) {
        return this.a(DynamicOpsNBT.a, decoder);
    }

    public <T> DataResult<T> a(DynamicOps<NBTBase> ops, MapDecoder<T> decoder) {
        MapLike mapLike = (MapLike)ops.getMap((Object)this.f).getOrThrow();
        return decoder.decode(ops, mapLike);
    }

    public int a() {
        return this.f.f();
    }

    public boolean b() {
        return this.f.g();
    }

    public NBTTagCompound c() {
        return this.f.i();
    }

    public boolean a(String key) {
        return this.f.e(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) return true;
        if (!(object instanceof CustomData)) return false;
        CustomData customData = (CustomData)object;
        if (!this.f.equals(customData.f)) return false;
        return true;
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public String toString() {
        return this.f.toString();
    }

    @Deprecated
    public NBTTagCompound d() {
        return this.f;
    }
}

