/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class ItemContainerContents {
    private static final int d = -1;
    public static final int e = 256;
    public static final ItemContainerContents a = new ItemContainerContents(NonNullList.a());
    public static final Codec<ItemContainerContents> b = net.minecraft.world.item.component.ItemContainerContents$a.a.sizeLimitedListOf(256).xmap(ItemContainerContents::b, ItemContainerContents::f);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> c = ItemStack.g.a(ByteBufCodecs.c(256)).a(ItemContainerContents::new, component -> component.f);
    public final NonNullList<ItemStack> f;
    private final int g;

    private ItemContainerContents(NonNullList<ItemStack> stacks) {
        if (stacks.size() > 256) {
            throw new IllegalArgumentException("Got " + stacks.size() + " items, but maximum is 256");
        }
        this.f = stacks;
        this.g = ItemStack.a(stacks);
    }

    private ItemContainerContents(int size) {
        this(NonNullList.a(size, ItemStack.j));
    }

    private ItemContainerContents(List<ItemStack> stacks) {
        this(stacks.size());
        for (int i2 = 0; i2 < stacks.size(); ++i2) {
            this.f.set(i2, stacks.get(i2));
        }
    }

    private static ItemContainerContents b(List<a> slots) {
        OptionalInt optionalInt = slots.stream().mapToInt(a::a).max();
        if (optionalInt.isEmpty()) {
            return a;
        }
        ItemContainerContents itemContainerContents = new ItemContainerContents(optionalInt.getAsInt() + 1);
        for (a slot : slots) {
            itemContainerContents.f.set(slot.a(), slot.b());
        }
        return itemContainerContents;
    }

    public static ItemContainerContents a(List<ItemStack> stacks) {
        int i2 = ItemContainerContents.c(stacks);
        if (i2 == -1) {
            return a;
        }
        ItemContainerContents itemContainerContents = new ItemContainerContents(i2 + 1);
        for (int j2 = 0; j2 <= i2; ++j2) {
            itemContainerContents.f.set(j2, stacks.get(j2).v());
        }
        return itemContainerContents;
    }

    private static int c(List<ItemStack> stacks) {
        for (int i2 = stacks.size() - 1; i2 >= 0; --i2) {
            if (stacks.get(i2).f()) continue;
            return i2;
        }
        return -1;
    }

    private List<a> f() {
        ArrayList<a> list = new ArrayList<a>();
        for (int i2 = 0; i2 < this.f.size(); ++i2) {
            ItemStack itemStack = this.f.get(i2);
            if (itemStack.f()) continue;
            list.add(new a(i2, itemStack));
        }
        return list;
    }

    public void a(NonNullList<ItemStack> stacks) {
        for (int i2 = 0; i2 < stacks.size(); ++i2) {
            ItemStack itemStack = i2 < this.f.size() ? this.f.get(i2) : ItemStack.j;
            stacks.set(i2, itemStack.v());
        }
    }

    public ItemStack a() {
        return this.f.isEmpty() ? ItemStack.j : this.f.get(0).v();
    }

    public Stream<ItemStack> b() {
        return this.f.stream().map(ItemStack::v);
    }

    public Stream<ItemStack> c() {
        return this.f.stream().filter(stack -> !stack.f()).map(ItemStack::v);
    }

    public Iterable<ItemStack> d() {
        return Iterables.filter(this.f, stack -> !stack.f());
    }

    public Iterable<ItemStack> e() {
        return Iterables.transform(this.d(), ItemStack::v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ItemContainerContents)) return false;
        ItemContainerContents itemContainerContents = (ItemContainerContents)object;
        if (!ItemStack.a(this.f, itemContainerContents.f)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.g;
    }

    static final class a
    extends Record {
        private final int b;
        private final ItemStack c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(a::a), (App)ItemStack.a.fieldOf("item").forGetter(a::b)).apply((Applicative)instance, a::new));

        a(int i2, ItemStack itemStack) {
            this.b = i2;
            this.c = itemStack;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "index;item", "b", "c"}, this, object);
        }

        public int a() {
            return this.b;
        }

        public ItemStack b() {
            return this.c;
        }
    }
}

