/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.BookContent;

public final class WrittenBookContent
extends Record
implements BookContent<IChatBaseComponent, WrittenBookContent> {
    private final Filterable<String> k;
    private final String l;
    private final int m;
    private final List<Filterable<IChatBaseComponent>> n;
    private final boolean o;
    public static final WrittenBookContent a = new WrittenBookContent(Filterable.a(""), "", 0, List.of(), true);
    public static final int b = Short.MAX_VALUE;
    public static final int c = 16;
    public static final int d = 32;
    public static final int e = 3;
    public static final int f = 2;
    public static final Codec<IChatBaseComponent> g = ComponentSerialization.a(Short.MAX_VALUE);
    public static final Codec<List<Filterable<IChatBaseComponent>>> h = WrittenBookContent.a(g);
    public static final Codec<WrittenBookContent> i = RecordCodecBuilder.create(instance -> instance.group((App)Filterable.a(Codec.string((int)0, (int)32)).fieldOf("title").forGetter(WrittenBookContent::d), (App)Codec.STRING.fieldOf("author").forGetter(WrittenBookContent::e), (App)ExtraCodecs.a(0, 3).optionalFieldOf("generation", (Object)0).forGetter(WrittenBookContent::f), (App)h.optionalFieldOf("pages", List.of()).forGetter(WrittenBookContent::a), (App)Codec.BOOL.optionalFieldOf("resolved", (Object)false).forGetter(WrittenBookContent::g)).apply((Applicative)instance, WrittenBookContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrittenBookContent> j = StreamCodec.a(Filterable.a(ByteBufCodecs.b(32)), WrittenBookContent::d, ByteBufCodecs.o, WrittenBookContent::e, ByteBufCodecs.h, WrittenBookContent::f, Filterable.a(ComponentSerialization.b).a(ByteBufCodecs.a()), WrittenBookContent::a, ByteBufCodecs.b, WrittenBookContent::g, WrittenBookContent::new);

    public WrittenBookContent(Filterable<String> filterable, String string, int i2, List<Filterable<IChatBaseComponent>> list, boolean bl) {
        if (i2 < 0 || i2 > 3) {
            throw new IllegalArgumentException("Generation was " + i2 + ", but must be between 0 and 3");
        }
        this.k = filterable;
        this.l = string;
        this.m = i2;
        this.n = list;
        this.o = bl;
    }

    private static Codec<Filterable<IChatBaseComponent>> b(Codec<IChatBaseComponent> textCodec) {
        return Filterable.a(textCodec);
    }

    public static Codec<List<Filterable<IChatBaseComponent>>> a(Codec<IChatBaseComponent> textCodec) {
        return WrittenBookContent.b(textCodec).listOf();
    }

    @Nullable
    public WrittenBookContent b() {
        if (this.m >= 2) {
            return null;
        }
        return new WrittenBookContent(this.k, this.l, this.m + 1, this.n, this.o);
    }

    @Nullable
    public WrittenBookContent a(CommandListenerWrapper source, @Nullable EntityHuman player) {
        if (this.o) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.n.size());
        for (Filterable<IChatBaseComponent> filterable : this.n) {
            Optional<Filterable<IChatBaseComponent>> optional = WrittenBookContent.a(source, player, filterable);
            if (optional.isEmpty()) {
                return null;
            }
            builder.add(optional.get());
        }
        return new WrittenBookContent(this.k, this.l, this.m, (List<Filterable<IChatBaseComponent>>)builder.build(), true);
    }

    public WrittenBookContent c() {
        return new WrittenBookContent(this.k, this.l, this.m, this.n, true);
    }

    private static Optional<Filterable<IChatBaseComponent>> a(CommandListenerWrapper source, @Nullable EntityHuman player, Filterable<IChatBaseComponent> page) {
        return page.b((T text) -> {
            try {
                IChatMutableComponent component = ChatComponentUtils.a(source, text, (Entity)player, 0);
                if (WrittenBookContent.a(component, source.u())) {
                    return Optional.empty();
                }
                return Optional.of(component);
            }
            catch (Exception exception) {
                return Optional.of(text);
            }
        });
    }

    private static boolean a(IChatBaseComponent text, HolderLookup.a registries) {
        return IChatBaseComponent.ChatSerializer.a(text, registries).length() > Short.MAX_VALUE;
    }

    public List<IChatBaseComponent> a(boolean shouldFilter) {
        return Lists.transform(this.n, page -> (IChatBaseComponent)page.a(shouldFilter));
    }

    @Override
    public WrittenBookContent b(List<Filterable<IChatBaseComponent>> list) {
        return new WrittenBookContent(this.k, this.l, this.m, list, false);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this, object);
    }

    public Filterable<String> d() {
        return this.k;
    }

    public String e() {
        return this.l;
    }

    public int f() {
        return this.m;
    }

    @Override
    @Override
    public List<Filterable<IChatBaseComponent>> a() {
        return this.n;
    }

    public boolean g() {
        return this.o;
    }

    @Override
    public /* synthetic */ Object a(List pages) {
        return this.b(pages);
    }
}

