/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class TeleportRandomlyConsumeEffect
extends Record
implements ConsumeEffect {
    private final float c;
    private static final float f = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.o.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::b)).apply((Applicative)instance, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> b = StreamCodec.a(ByteBufCodecs.l, TeleportRandomlyConsumeEffect::b, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public TeleportRandomlyConsumeEffect(float diameter) {
        this.c = diameter;
    }

    public ConsumeEffect.a<TeleportRandomlyConsumeEffect> a() {
        return ConsumeEffect.a.d;
    }

    @Override
    public boolean a(World world, ItemStack stack, EntityLiving user) {
        boolean flag = false;
        for (int i2 = 0; i2 < 16; ++i2) {
            SoundCategory soundcategory;
            SoundEffect soundeffect;
            double d0 = user.dB() + (user.dZ().j() - 0.5) * (double)this.c;
            double d1 = MathHelper.a(user.dD() + (user.dZ().j() - 0.5) * (double)this.c, (double)world.L_(), (double)(world.L_() + ((WorldServer)world).l() - 1));
            double d2 = user.dH() + (user.dZ().j() - 0.5) * (double)this.c;
            if (user.bZ()) {
                user.ae();
            }
            Vec3D vec3d = user.du();
            Optional<Boolean> status = user.randomTeleport(d0, d1, d2, true, PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT);
            if (!status.isPresent()) break;
            if (!status.get().booleanValue()) continue;
            world.a(GameEvent.R, vec3d, GameEvent.a.a(user));
            if (user instanceof EntityFox) {
                soundeffect = SoundEffects.jJ;
                soundcategory = SoundCategory.g;
            } else {
                soundeffect = SoundEffects.fj;
                soundcategory = SoundCategory.h;
            }
            world.a((EntityHuman)null, user.dB(), user.dD(), user.dH(), soundeffect, soundcategory);
            user.k();
            flag = true;
            break;
        }
        if (flag && user instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)user;
            entityhuman.gN();
        }
        return flag;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this, o2);
    }

    public float b() {
        return this.c;
    }
}

