/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataAbstract<RecipeMap>
implements RecipeAccess {
    private static final Logger a = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, c> b = Map.of(RecipePropertySet.d, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.k();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.b, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.f();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.c, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.c();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.e, CraftingManager.b(Recipes.b), RecipePropertySet.f, CraftingManager.b(Recipes.c), RecipePropertySet.g, CraftingManager.b(Recipes.d), RecipePropertySet.h, CraftingManager.b(Recipes.e));
    private final HolderLookup.a c;
    public RecipeMap d = RecipeMap.a;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> e = Map.of();
    private SelectableRecipe.b<RecipeStonecutting> f = SelectableRecipe.b.a();
    private List<d> g = List.of();
    private Map<ResourceKey<IRecipe<?>>, List<d>> h = Map.of();
    private FeatureFlagSet featureflagset;

    public CraftingManager(HolderLookup.a registries) {
        this.c = registries;
    }

    protected RecipeMap a(IResourceManager manager, GameProfilerFiller profiler) {
        TreeMap<MinecraftKey, IRecipe> sortedmap = new TreeMap<MinecraftKey, IRecipe>();
        ResourceDataJson.a(manager, Registries.c(Registries.bk), this.c.a(JsonOps.INSTANCE), IRecipe.a, sortedmap);
        ArrayList list = new ArrayList(sortedmap.size());
        sortedmap.forEach((minecraftkey, irecipe) -> {
            ResourceKey<IRecipe<?>> resourcekey = ResourceKey.a(Registries.bk, minecraftkey);
            RecipeHolder<IRecipe> recipeholder = new RecipeHolder<IRecipe>(resourcekey, (IRecipe)irecipe);
            list.add(recipeholder);
        });
        return RecipeMap.a(list);
    }

    @Override
    protected void a(RecipeMap prepared, IResourceManager manager, GameProfilerFiller profiler) {
        this.d = prepared;
        a.info("Loaded {} recipes", (Object)prepared.a().size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        this.d.addRecipe(irecipe);
        this.finalizeRecipeLoading();
    }

    public void finalizeRecipeLoading() {
        if (this.featureflagset != null) {
            this.a(this.featureflagset);
            MinecraftServer.getServer().ag().reloadRecipes();
        }
    }

    public void a(FeatureFlagSet features) {
        this.featureflagset = features;
        ArrayList list = new ArrayList();
        List<b> list1 = b.entrySet().stream().map(entry -> new b((ResourceKey)entry.getKey(), (c)entry.getValue())).toList();
        this.d.a().forEach(recipeholder -> {
            Object irecipe = recipeholder.b();
            if (!irecipe.aq_() && irecipe.ap_().d()) {
                a.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)recipeholder.a().a());
            } else {
                RecipeStonecutting recipestonecutting;
                list1.forEach(craftingmanager_b -> craftingmanager_b.a((IRecipe<?>)irecipe));
                if (irecipe instanceof RecipeStonecutting && CraftingManager.a(features, (recipestonecutting = (RecipeStonecutting)irecipe).k()) && recipestonecutting.c().a(features)) {
                    list.add(new SelectableRecipe.a(recipestonecutting.k(), new SelectableRecipe(recipestonecutting.c(), Optional.of(recipeholder))));
                }
            }
        });
        this.e = list1.stream().collect(Collectors.toUnmodifiableMap(craftingmanager_b -> craftingmanager_b.a, craftingmanager_b -> craftingmanager_b.a(features)));
        this.f = new SelectableRecipe.b(list);
        this.g = CraftingManager.a(this.d.a(), features);
        this.h = this.g.stream().collect(Collectors.groupingBy(craftingmanager_d -> craftingmanager_d.b.a(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<RecipeItemStack> a(FeatureFlagSet features, List<RecipeItemStack> ingredients) {
        ingredients.removeIf(recipeitemstack -> !CraftingManager.a(features, recipeitemstack));
        return ingredients;
    }

    private static boolean a(FeatureFlagSet features, RecipeItemStack ingredient) {
        return ingredient.a().stream().allMatch(holder -> ((Item)holder.a()).a(features));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world, @Nullable ResourceKey<IRecipe<?>> recipe) {
        RecipeHolder<T> recipeholder = recipe != null ? this.a(type, recipe) : null;
        return this.a(type, input, world, recipeholder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world, @Nullable RecipeHolder<T> recipe) {
        return recipe != null && recipe.b().a(input, world) ? Optional.of(recipe) : this.a(type, input, world);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> type, I input, World world) {
        List<RecipeHolder<T>> list = this.d.a(type, input, world).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public Optional<RecipeHolder<?>> b(ResourceKey<IRecipe<?>> key) {
        return Optional.ofNullable(this.d.a(key));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> a(Recipes<T> type, ResourceKey<IRecipe<?>> key) {
        RecipeHolder<?> recipeholder = this.d.a(key);
        return recipeholder != null && recipeholder.b().b().equals(type) ? recipeholder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> b() {
        return this.e;
    }

    public SelectableRecipe.b<RecipeStonecutting> d() {
        return this.f;
    }

    @Override
    public RecipePropertySet a(ResourceKey<RecipePropertySet> key) {
        return this.e.getOrDefault(key, RecipePropertySet.j);
    }

    @Override
    public SelectableRecipe.b<RecipeStonecutting> a() {
        return this.f;
    }

    public Collection<RecipeHolder<?>> e() {
        return this.d.a();
    }

    @Nullable
    public d a(RecipeDisplayId id) {
        return this.g.get(id.a());
    }

    public void a(ResourceKey<IRecipe<?>> key, Consumer<RecipeDisplayEntry> action) {
        List<d> list = this.h.get(key);
        if (list != null) {
            list.forEach(craftingmanager_d -> action.accept(craftingmanager_d.a));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> a(ResourceKey<IRecipe<?>> key, JsonObject json, HolderLookup.a registries) {
        IRecipe irecipe = (IRecipe)IRecipe.a.parse(registries.a(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(key, irecipe);
    }

    public boolean removeRecipe(ResourceKey<IRecipe<?>> mcKey) {
        boolean removed = this.d.removeRecipe(mcKey);
        if (removed) {
            this.finalizeRecipeLoading();
        }
        return removed;
    }

    public void clearRecipes() {
        this.d = RecipeMap.a(Collections.emptyList());
        this.finalizeRecipeLoading();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> a(final Recipes<T> type) {
        return new a<I, T>(){
            @Nullable
            private ResourceKey<IRecipe<?>> b;

            @Override
            public Optional<RecipeHolder<T>> a(I input, WorldServer world) {
                CraftingManager craftingmanager = world.s();
                Optional optional = craftingmanager.a(type, input, (World)world, this.b);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.b = recipeholder.a();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<d> a(Iterable<RecipeHolder<?>> recipes, FeatureFlagSet enabledFeatures) {
        ArrayList<d> list = new ArrayList<d>();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeholder : recipes) {
            Object irecipe = recipeholder.b();
            OptionalInt optionalint = irecipe.j().isEmpty() ? OptionalInt.empty() : OptionalInt.of(object2intmap.computeIfAbsent((Object)irecipe.j(), arg_0 -> CraftingManager.lambda$unpackRecipeInfo$13((Object2IntMap)object2intmap, arg_0)));
            Optional<Object> optional = irecipe.aq_() ? Optional.empty() : Optional.of(irecipe.ap_().b());
            for (RecipeDisplay recipedisplay : irecipe.g()) {
                if (!recipedisplay.a(enabledFeatures)) continue;
                int i2 = list.size();
                RecipeDisplayId recipedisplayid = new RecipeDisplayId(i2);
                RecipeDisplayEntry recipedisplayentry = new RecipeDisplayEntry(recipedisplayid, recipedisplay, optionalint, irecipe.h(), optional);
                list.add(new d(recipedisplayentry, recipeholder));
            }
        }
        return list;
    }

    private static c b(Recipes<? extends RecipeSingleItem> expectedType) {
        return irecipe -> {
            Optional<Object> optional;
            if (irecipe.b() == expectedType && irecipe instanceof RecipeSingleItem) {
                RecipeSingleItem recipesingleitem = (RecipeSingleItem)irecipe;
                optional = Optional.of(recipesingleitem.k());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap object2intmap, Object object) {
        return object2intmap.size();
    }

    public record d(RecipeDisplayEntry a, RecipeHolder<?> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface c {
        public Optional<RecipeItemStack> apply(IRecipe<?> var1);
    }

    public static class b
    implements Consumer<IRecipe<?>> {
        final ResourceKey<RecipePropertySet> a;
        private final c b;
        private final List<RecipeItemStack> c = new ArrayList<RecipeItemStack>();

        protected b(ResourceKey<RecipePropertySet> propertySetKey, c ingredientGetter) {
            this.a = propertySetKey;
            this.b = ingredientGetter;
        }

        public void a(IRecipe<?> irecipe) {
            Optional<RecipeItemStack> optional = this.b.apply(irecipe);
            List<RecipeItemStack> list = this.c;
            Objects.requireNonNull(this.c);
            optional.ifPresent(list::add);
        }

        public RecipePropertySet a(FeatureFlagSet enabledFeatures) {
            return RecipePropertySet.a(CraftingManager.a(enabledFeatures, this.c));
        }
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> a(I var1, WorldServer var2);
    }
}

