/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftComplexRecipe;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftRecipe;
import org.bukkit.inventory.Recipe;

public abstract class IRecipeComplex
implements RecipeCrafting {
    private final CraftingBookCategory c;

    public IRecipeComplex(CraftingBookCategory category) {
        this.c = category;
    }

    @Override
    public boolean aq_() {
        return true;
    }

    @Override
    public CraftingBookCategory c() {
        return this.c;
    }

    @Override
    public PlacementInfo ap_() {
        return PlacementInfo.a;
    }

    @Override
    public abstract RecipeSerializer<? extends IRecipeComplex> a();

    @Override
    public Recipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(ItemStack.j);
        CraftComplexRecipe recipe = new CraftComplexRecipe(id, result, this);
        recipe.setGroup(this.j());
        recipe.setCategory(CraftRecipe.getCategory(this.c()));
        return recipe;
    }

    public static class Serializer<T extends RecipeCrafting>
    implements RecipeSerializer<T> {
        private final MapCodec<T> w = RecordCodecBuilder.mapCodec(instance -> {
            Products.P1 p1 = instance.group((App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(RecipeCrafting::c));
            Objects.requireNonNull(factory);
            return p1.apply((Applicative)instance, factory::create);
        });
        private final StreamCodec<RegistryFriendlyByteBuf, T> x;

        public Serializer(Factory<T> factory) {
            StreamCodec<ByteBuf, CraftingBookCategory> streamcodec = CraftingBookCategory.g;
            Function<RecipeCrafting, CraftingBookCategory> function = RecipeCrafting::c;
            Objects.requireNonNull(factory);
            this.x = StreamCodec.a(streamcodec, function, factory::create);
        }

        @Override
        public MapCodec<T> a() {
            return this.w;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> b() {
            return this.x;
        }

        @FunctionalInterface
        public static interface Factory<T extends RecipeCrafting> {
            public T create(CraftingBookCategory var1);
        }
    }
}

