/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemStack> a = ByteBufCodecs.c(Registries.K).a(RecipeItemStack::new, recipeitemstack -> recipeitemstack.e);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<RecipeItemStack>> b = ByteBufCodecs.c(Registries.K).a(holderset -> holderset.b() == 0 ? Optional.empty() : Optional.of(new RecipeItemStack((HolderSet<Item>)holderset)), optional -> optional.map(recipeitemstack -> recipeitemstack.e).orElse(HolderSet.a(new Holder[0])));
    public static final Codec<HolderSet<Item>> c = HolderSetCodec.a(Registries.K, Item.e, false);
    public static final Codec<RecipeItemStack> d = ExtraCodecs.b(c).xmap(RecipeItemStack::new, recipeitemstack -> recipeitemstack.e);
    private final HolderSet<Item> e;
    @Nullable
    private List<Holder<Item>> f;
    @Nullable
    private List<ItemStack> itemStacks;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static RecipeItemStack ofStacks(List<ItemStack> stacks) {
        RecipeItemStack recipe = RecipeItemStack.a(stacks.stream().map(ItemStack::h));
        recipe.itemStacks = stacks;
        return recipe;
    }

    private RecipeItemStack(HolderSet<Item> entries) {
        entries.d().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.a.f())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.e = entries;
    }

    public static boolean a(Optional<RecipeItemStack> ingredient, ItemStack stack) {
        Optional<Boolean> optional1 = ingredient.map(recipeitemstack -> recipeitemstack.a(stack));
        Objects.requireNonNull(stack);
        return (Boolean)optional1.orElseGet(stack::f);
    }

    public List<Holder<Item>> a() {
        if (this.f == null) {
            this.f = ImmutableList.copyOf(this.e);
        }
        return this.f;
    }

    public boolean a(ItemStack itemstack) {
        if (this.isExact()) {
            for (ItemStack itemstack1 : this.itemStacks()) {
                if (itemstack1.h() != itemstack.h() || !ItemStack.c(itemstack, itemstack1)) continue;
                return true;
            }
            return false;
        }
        List<Holder<Item>> list = this.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!itemstack.a(list.get(i2))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof RecipeItemStack) {
            RecipeItemStack recipeitemstack = (RecipeItemStack)object;
            return Objects.equals(this.e, recipeitemstack.e) && Objects.equals(this.itemStacks, recipeitemstack.itemStacks);
        }
        return false;
    }

    public static RecipeItemStack a(IMaterial item) {
        return new RecipeItemStack(HolderSet.a(item.j().f()));
    }

    public static RecipeItemStack a(IMaterial ... items) {
        return RecipeItemStack.a(Arrays.stream(items));
    }

    public static RecipeItemStack a(Stream<? extends IMaterial> stacks) {
        return new RecipeItemStack(HolderSet.a(stacks.map(imaterial -> imaterial.j().f()).toList()));
    }

    public static RecipeItemStack a(HolderSet<Item> tag) {
        return new RecipeItemStack(tag);
    }

    public SlotDisplay b() {
        if (this.isExact()) {
            return new SlotDisplay.b(this.itemStacks().stream().map(SlotDisplay.f::new).toList());
        }
        return (SlotDisplay)((Object)this.e.d().map(SlotDisplay.h::new, list -> new SlotDisplay.b(list.stream().map(RecipeItemStack::a).toList())));
    }

    public static SlotDisplay a(Optional<RecipeItemStack> ingredient) {
        return ingredient.map(RecipeItemStack::b).orElse(SlotDisplay.c.c);
    }

    private static SlotDisplay a(Holder<Item> displayedItem) {
        SlotDisplay.d slotdisplay_d = new SlotDisplay.d(displayedItem);
        ItemStack itemstack = displayedItem.a().k();
        if (!itemstack.f()) {
            SlotDisplay.f slotdisplay_f = new SlotDisplay.f(itemstack);
            return new SlotDisplay.j(slotdisplay_d, slotdisplay_f);
        }
        return slotdisplay_d;
    }
}

