/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class ShapedRecipePattern {
    private static final int d = 3;
    public static final char a = ' ';
    public static final MapCodec<ShapedRecipePattern> b = net.minecraft.world.item.crafting.ShapedRecipePattern$a.a.flatXmap(ShapedRecipePattern::a, recipe -> recipe.h.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> c = StreamCodec.a(ByteBufCodecs.h, (C recipe) -> recipe.e, ByteBufCodecs.h, (C recipe) -> recipe.f, RecipeItemStack.b.a(ByteBufCodecs.a()), (C recipe) -> recipe.g, ShapedRecipePattern::a);
    private final int e;
    private final int f;
    private final List<Optional<RecipeItemStack>> g;
    private final Optional<a> h;
    private final int i;
    private final boolean j;

    public ShapedRecipePattern(int width, int height, List<Optional<RecipeItemStack>> ingredients, Optional<a> data) {
        this.e = width;
        this.f = height;
        this.g = ingredients;
        this.h = data;
        this.i = (int)ingredients.stream().flatMap(Optional::stream).count();
        this.j = SystemUtils.a(width, height, ingredients);
    }

    private static ShapedRecipePattern a(Integer width, Integer height, List<Optional<RecipeItemStack>> ingredients) {
        return new ShapedRecipePattern(width, height, ingredients, Optional.empty());
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, String ... pattern) {
        return ShapedRecipePattern.a(key, List.of(pattern));
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, List<String> pattern) {
        a data = new a(key, pattern);
        return (ShapedRecipePattern)ShapedRecipePattern.a(data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> a(a data) {
        String[] strings = ShapedRecipePattern.a(data.c);
        int i2 = strings[0].length();
        int j2 = strings.length;
        ArrayList<Optional<RecipeItemStack>> list = new ArrayList<Optional<RecipeItemStack>>(i2 * j2);
        CharArraySet charSet = new CharArraySet(data.b.keySet());
        for (String string : strings) {
            for (int k2 = 0; k2 < string.length(); ++k2) {
                Optional<RecipeItemStack> optional2;
                char c2 = string.charAt(k2);
                if (c2 == ' ') {
                    Optional optional = Optional.empty();
                } else {
                    RecipeItemStack ingredient = data.b.get(Character.valueOf(c2));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c2 + "' but it's not defined in the key");
                    }
                    optional2 = Optional.of(ingredient);
                }
                charSet.remove(c2);
                list.add(optional2);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.a((CharSet)charSet));
        }
        return DataResult.success((Object)new ShapedRecipePattern(i2, j2, list, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] a(List<String> pattern) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int m2 = 0; m2 < pattern.size(); ++m2) {
            String string = pattern.get(m2);
            i2 = Math.min(i2, ShapedRecipePattern.a(string));
            int n2 = ShapedRecipePattern.b(string);
            j2 = Math.max(j2, n2);
            if (n2 < 0) {
                if (k2 == m2) {
                    ++k2;
                }
                ++l2;
                continue;
            }
            l2 = 0;
        }
        if (pattern.size() == l2) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l2 - k2];
        for (int o2 = 0; o2 < strings.length; ++o2) {
            strings[o2] = pattern.get(o2 + k2).substring(i2, j2 + 1);
        }
        return strings;
    }

    private static int a(String line) {
        int i2;
        for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String line) {
        int i2;
        for (i2 = line.length() - 1; i2 >= 0 && line.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    public boolean a(CraftingInput input) {
        if (input.e() != this.i) {
            return false;
        }
        if (input.f() == this.e && input.g() == this.f) {
            if (!this.j && this.a(input, true)) {
                return true;
            }
            if (this.a(input, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean a(CraftingInput input, boolean mirrored) {
        for (int i2 = 0; i2 < this.f; ++i2) {
            for (int j2 = 0; j2 < this.e; ++j2) {
                Optional<RecipeItemStack> optional2;
                if (mirrored) {
                    Optional<RecipeItemStack> optional = this.g.get(this.e - j2 - 1 + i2 * this.e);
                } else {
                    optional2 = this.g.get(j2 + i2 * this.e);
                }
                ItemStack itemStack = input.a(j2, i2);
                if (RecipeItemStack.a(optional2, itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    public int a() {
        return this.e;
    }

    public int b() {
        return this.f;
    }

    public List<Optional<RecipeItemStack>> c() {
        return this.g;
    }

    private static /* synthetic */ String a(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public static final class a
    extends Record {
        private final Map<Character, RecipeItemStack> b;
        private final List<String> c;
        private static final Codec<List<String>> d = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (pattern.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i2 = ((String)pattern.getFirst()).length();
            for (String string : pattern) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i2 == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        private static final Codec<Character> e = Codec.STRING.comapFlatMap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(keyEntry)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.b(e, RecipeItemStack.d).fieldOf("key").forGetter(data -> data.b), (App)d.fieldOf("pattern").forGetter(data -> data.c)).apply((Applicative)instance, a::new));

        public a(Map<Character, RecipeItemStack> map, List<String> list) {
            this.b = map;
            this.c = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this, object);
        }

        public Map<Character, RecipeItemStack> a() {
            return this.b;
        }

        public List<String> b() {
            return this.c;
        }
    }
}

