/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.block.entity.FuelValues;

public interface SlotDisplay {
    public static final Codec<SlotDisplay> a = BuiltInRegistries.aA.q().dispatch(SlotDisplay::a, i::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotDisplay> b = ByteBufCodecs.a(Registries.aG).b(SlotDisplay::a, i::b);

    public <T> Stream<T> a(ContextMap var1, DisplayContentsFactory<T> var2);

    public i<? extends SlotDisplay> a();

    default public boolean a(FeatureFlagSet features) {
        return true;
    }

    default public List<ItemStack> a(ContextMap parameters) {
        return this.a(parameters, e.a).toList();
    }

    default public ItemStack b(ContextMap context) {
        return this.a(context, e.a).findFirst().orElse(ItemStack.j);
    }

    public static class e
    implements DisplayContentsFactory.b<ItemStack> {
        public static final e a = new e();

        @Override
        public ItemStack b(ItemStack itemStack) {
            return itemStack;
        }

        @Override
        public /* synthetic */ Object a(ItemStack stack) {
            return this.b(stack);
        }
    }

    public static final class j
    extends Record
    implements SlotDisplay {
        private final SlotDisplay f;
        private final SlotDisplay g;
        public static final MapCodec<j> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.fieldOf("input").forGetter(j::b), (App)a.fieldOf("remainder").forGetter(j::c)).apply((Applicative)instance, j::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, j> d = StreamCodec.a(b, j::b, b, j::c, j::new);
        public static final i<j> e = new i<j>(c, d);

        public j(SlotDisplay slotDisplay, SlotDisplay slotDisplay2) {
            this.f = slotDisplay;
            this.g = slotDisplay2;
        }

        @Override
        public i<j> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.a) {
                DisplayContentsFactory.a forRemainders = (DisplayContentsFactory.a)factory;
                List list = this.g.a(parameters, factory).toList();
                return this.f.a(parameters, factory).map(input -> forRemainders.a(input, list));
            }
            return this.f.a(parameters, factory);
        }

        @Override
        @Override
        public boolean a(FeatureFlagSet features) {
            return this.f.a(features) && this.g.a(features);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "input;remainder", "f", "g"}, this, object);
        }

        public SlotDisplay b() {
            return this.f;
        }

        public SlotDisplay c() {
            return this.g;
        }
    }

    public static final class b
    extends Record
    implements SlotDisplay {
        private final List<SlotDisplay> f;
        public static final MapCodec<b> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.listOf().fieldOf("contents").forGetter(b::b)).apply((Applicative)instance, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> d = StreamCodec.a(b.a(ByteBufCodecs.a()), b::b, b::new);
        public static final i<b> e = new i<b>(c, d);

        public b(List<SlotDisplay> list) {
            this.f = list;
        }

        @Override
        public i<b> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            return this.f.stream().flatMap(display -> display.a(parameters, factory));
        }

        @Override
        @Override
        public boolean a(FeatureFlagSet features) {
            return this.f.stream().allMatch(child -> child.a(features));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "contents", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "contents", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "contents", "f"}, this, object);
        }

        public List<SlotDisplay> b() {
            return this.f;
        }
    }

    public static final class h
    extends Record
    implements SlotDisplay {
        private final TagKey<Item> f;
        public static final MapCodec<h> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.a(Registries.K).fieldOf("tag").forGetter(h::b)).apply((Applicative)instance, h::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, h> d = StreamCodec.a(TagKey.c(Registries.K), h::b, h::new);
        public static final i<h> e = new i<h>(c, d);

        public h(TagKey<Item> tagKey) {
            this.f = tagKey;
        }

        @Override
        public i<h> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)factory;
                HolderLookup.a provider = parameters.c(SlotDisplayContext.b);
                if (provider != null) {
                    return provider.d(Registries.K).a(this.f).map(tag -> tag.a().map(forStacks::a)).stream().flatMap(values -> values);
                }
            }
            return Stream.empty();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "tag", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "tag", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "tag", "f"}, this, object);
        }

        public TagKey<Item> b() {
            return this.f;
        }
    }

    public static final class f
    extends Record
    implements SlotDisplay {
        private final ItemStack f;
        public static final MapCodec<f> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.c.fieldOf("item").forGetter(f::b)).apply((Applicative)instance, f::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, f> d = StreamCodec.a(ItemStack.h, f::b, f::new);
        public static final i<f> e = new i<f>(c, d);

        public f(ItemStack itemStack) {
            this.f = itemStack;
        }

        @Override
        public i<f> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)factory;
                return Stream.of(forStacks.a(this.f));
            }
            return Stream.empty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Override
        public boolean equals(Object object) {
            if (this == object) return true;
            if (!(object instanceof f)) return false;
            f itemStackSlotDisplay = (f)object;
            if (!ItemStack.a(this.f, itemStackSlotDisplay.f)) return false;
            return true;
        }

        @Override
        @Override
        public boolean a(FeatureFlagSet features) {
            return this.f.h().a(features);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "stack", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "stack", "f"}, this);
        }

        public ItemStack b() {
            return this.f;
        }
    }

    public static final class d
    extends Record
    implements SlotDisplay {
        private final Holder<Item> f;
        public static final MapCodec<d> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.e.fieldOf("item").forGetter(d::b)).apply((Applicative)instance, d::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, d> d = StreamCodec.a(ByteBufCodecs.b(Registries.K), d::b, d::new);
        public static final i<d> e = new i<d>(c, d);

        public d(Item item) {
            this(item.f());
        }

        public d(Holder<Item> holder) {
            this.f = holder;
        }

        @Override
        public i<d> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)factory;
                return Stream.of(forStacks.a(this.f));
            }
            return Stream.empty();
        }

        @Override
        @Override
        public boolean a(FeatureFlagSet features) {
            return this.f.a().a(features);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "item", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "item", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "item", "f"}, this, object);
        }

        public Holder<Item> b() {
            return this.f;
        }
    }

    public static final class g
    extends Record
    implements SlotDisplay {
        private final SlotDisplay f;
        private final SlotDisplay g;
        private final SlotDisplay h;
        public static final MapCodec<g> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.fieldOf("base").forGetter(g::b), (App)a.fieldOf("material").forGetter(g::c), (App)a.fieldOf("pattern").forGetter(g::d)).apply((Applicative)instance, g::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, g> d = StreamCodec.a(b, g::b, b, g::c, b, g::d, g::new);
        public static final i<g> e = new i<g>(c, d);

        public g(SlotDisplay slotDisplay, SlotDisplay slotDisplay2, SlotDisplay slotDisplay3) {
            this.f = slotDisplay;
            this.g = slotDisplay2;
            this.h = slotDisplay3;
        }

        @Override
        public i<g> a() {
            return e;
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)factory;
                HolderLookup.a provider = parameters.c(SlotDisplayContext.b);
                if (provider != null) {
                    RandomSource randomSource = RandomSource.a(System.identityHashCode(this));
                    List<ItemStack> list = this.f.a(parameters);
                    if (list.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> list2 = this.g.a(parameters);
                    if (list2.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> list3 = this.h.a(parameters);
                    if (list3.isEmpty()) {
                        return Stream.empty();
                    }
                    return Stream.generate(() -> {
                        ItemStack itemStack = (ItemStack)SystemUtils.a(list, randomSource);
                        ItemStack itemStack2 = (ItemStack)SystemUtils.a(list2, randomSource);
                        ItemStack itemStack3 = (ItemStack)SystemUtils.a(list3, randomSource);
                        return SmithingTrimRecipe.a(provider, itemStack, itemStack2, itemStack3);
                    }).limit(256L).filter(stack -> !stack.f()).limit(16L).map(forStacks::a);
                }
            }
            return Stream.empty();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "base;material;pattern", "f", "g", "h"}, this, object);
        }

        public SlotDisplay b() {
            return this.f;
        }

        public SlotDisplay c() {
            return this.g;
        }

        public SlotDisplay d() {
            return this.h;
        }
    }

    public static class a
    implements SlotDisplay {
        public static final a c = new a();
        public static final MapCodec<a> d = MapCodec.unit((Object)c);
        public static final StreamCodec<RegistryFriendlyByteBuf, a> e = StreamCodec.a(c);
        public static final i<a> f = new i<a>(d, e);

        private a() {
        }

        @Override
        public i<a> a() {
            return f;
        }

        @Override
        public String toString() {
            return "<any fuel>";
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.b) {
                DisplayContentsFactory.b forStacks = (DisplayContentsFactory.b)factory;
                FuelValues fuelValues = parameters.c(SlotDisplayContext.a);
                if (fuelValues != null) {
                    return fuelValues.a().stream().map(forStacks::a);
                }
            }
            return Stream.empty();
        }
    }

    public static class c
    implements SlotDisplay {
        public static final c c = new c();
        public static final MapCodec<c> d = MapCodec.unit((Object)c);
        public static final StreamCodec<RegistryFriendlyByteBuf, c> e = StreamCodec.a(c);
        public static final i<c> f = new i<c>(d, e);

        private c() {
        }

        @Override
        public i<c> a() {
            return f;
        }

        @Override
        public String toString() {
            return "<empty>";
        }

        @Override
        @Override
        public <T> Stream<T> a(ContextMap parameters, DisplayContentsFactory<T> factory) {
            return Stream.empty();
        }
    }

    public record i<T extends SlotDisplay>(MapCodec<T> a, StreamCodec<RegistryFriendlyByteBuf, T> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "codec;streamCodec", "a", "b"}, this, object);
        }
    }
}

