/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableFloat;

public final class Enchantment
extends Record {
    private final IChatBaseComponent e;
    public final c f;
    private final HolderSet<Enchantment> g;
    private final DataComponentMap h;
    public static final int a = 255;
    public static final Codec<Enchantment> b = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.a.fieldOf("description").forGetter(Enchantment::f), (App)net.minecraft.world.item.enchantment.Enchantment$c.a.forGetter(Enchantment::g), (App)RegistryCodecs.a(Registries.aO).optionalFieldOf("exclusive_set", HolderSet.a(new Holder[0])).forGetter(Enchantment::h), (App)EnchantmentEffectComponents.b.optionalFieldOf("effects", (Object)DataComponentMap.a).forGetter(Enchantment::i)).apply((Applicative)instance, Enchantment::new));
    public static final Codec<Holder<Enchantment>> c = RegistryFixedCodec.a(Registries.aO);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Enchantment>> d = ByteBufCodecs.b(Registries.aO);

    public Enchantment(IChatBaseComponent component, c enchantmentDefinition, HolderSet<Enchantment> holderSet, DataComponentMap dataComponentMap) {
        this.e = component;
        this.f = enchantmentDefinition;
        this.g = holderSet;
        this.h = dataComponentMap;
    }

    public static b a(int base) {
        return new b(base, 0);
    }

    public static b a(int base, int perLevel) {
        return new b(base, perLevel);
    }

    public static c a(HolderSet<Item> supportedItems, HolderSet<Item> primaryItems, int weight, int maxLevel, b minCost, b maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new c(supportedItems, Optional.of(primaryItems), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public static c a(HolderSet<Item> supportedItems, int weight, int maxLevel, b minCost, b maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new c(supportedItems, Optional.empty(), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public Map<EnumItemSlot, ItemStack> a(EntityLiving entity) {
        EnumMap map = Maps.newEnumMap(EnumItemSlot.class);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.i) {
            ItemStack itemStack;
            if (!this.a(equipmentSlot) || (itemStack = entity.a(equipmentSlot)).f()) continue;
            map.put(equipmentSlot, itemStack);
        }
        return map;
    }

    public HolderSet<Item> a() {
        return this.f.a();
    }

    public boolean a(EnumItemSlot slot) {
        return this.f.h().stream().anyMatch(slotx -> slotx.b(slot));
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) && (this.f.c.isEmpty() || stack.a(this.f.c.get()));
    }

    public boolean b(ItemStack stack) {
        return stack.a(this.f.b);
    }

    public int b() {
        return this.f.c();
    }

    public int c() {
        return this.f.g();
    }

    public int d() {
        return 1;
    }

    public int e() {
        return this.f.d();
    }

    public int b(int level) {
        return this.f.e().a(level);
    }

    public int c(int level) {
        return this.f.f().a(level);
    }

    @Override
    @Override
    public String toString() {
        return "Enchantment " + this.e.getString();
    }

    public static boolean a(Holder<Enchantment> first, Holder<Enchantment> second) {
        return !first.equals(second) && !first.a().g.a(second) && !second.a().g.a(first);
    }

    public static IChatBaseComponent a(Holder<Enchantment> enchantment, int level) {
        IChatMutableComponent mutableComponent = enchantment.a().e.f();
        if (enchantment.a(EnchantmentTags.o)) {
            ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.m));
        } else {
            ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.h));
        }
        if (level != 1 || enchantment.a().e() != 1) {
            mutableComponent.b(CommonComponents.v).b(IChatBaseComponent.c("enchantment.level." + level));
        }
        return mutableComponent;
    }

    public boolean c(ItemStack stack) {
        return this.f.a().a(stack.i());
    }

    public <T> List<T> a(DataComponentType<List<T>> type) {
        return this.h.a(type, List.of());
    }

    public boolean a(WorldServer world, int level, Entity user, DamageSource damageSource) {
        LootTableInfo lootContext = Enchantment.b(world, level, user, damageSource);
        for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.d)) {
            if (!conditionalEffect.a(lootContext)) continue;
            return true;
        }
        return false;
    }

    public void a(WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat damageProtection) {
        LootTableInfo lootContext = Enchantment.b(world, level, user, damageSource);
        for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.c)) {
            if (!conditionalEffect.a(lootContext)) continue;
            damageProtection.setValue(((EnchantmentValueEffect)conditionalEffect.a()).a(level, user.dZ(), damageProtection.floatValue()));
        }
    }

    public void a(WorldServer world, int level, ItemStack stack, MutableFloat itemDamage) {
        this.a(EnchantmentEffectComponents.k, world, level, stack, itemDamage);
    }

    public void b(WorldServer world, int level, ItemStack projectileStack, MutableFloat ammoUse) {
        this.a(EnchantmentEffectComponents.p, world, level, projectileStack, ammoUse);
    }

    public void c(WorldServer world, int level, ItemStack stack, MutableFloat projectilePiercing) {
        this.a(EnchantmentEffectComponents.q, world, level, stack, projectilePiercing);
    }

    public void d(WorldServer world, int level, ItemStack stack, MutableFloat blockExperience) {
        this.a(EnchantmentEffectComponents.x, world, level, stack, blockExperience);
    }

    public void a(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat mobExperience) {
        this.a(EnchantmentEffectComponents.y, world, level, stack, user, mobExperience);
    }

    public void e(WorldServer world, int level, ItemStack stack, MutableFloat repairWithXp) {
        this.a(EnchantmentEffectComponents.z, world, level, stack, repairWithXp);
    }

    public void b(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat tridentReturnAcceleration) {
        this.a(EnchantmentEffectComponents.u, world, level, stack, user, tridentReturnAcceleration);
    }

    public void a(RandomSource random, int level, MutableFloat tridentSpinAttackStrength) {
        this.a(EnchantmentEffectComponents.F, random, level, tridentSpinAttackStrength);
    }

    public void c(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat fishingTimeReduction) {
        this.a(EnchantmentEffectComponents.v, world, level, stack, user, fishingTimeReduction);
    }

    public void d(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat fishingLuckBonus) {
        this.a(EnchantmentEffectComponents.w, world, level, stack, user, fishingLuckBonus);
    }

    public void b(WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat damage) {
        this.a(EnchantmentEffectComponents.e, world, level, stack, user, damageSource, damage);
    }

    public void c(WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat smashDamagePerFallenBlock) {
        this.a(EnchantmentEffectComponents.f, world, level, stack, user, damageSource, smashDamagePerFallenBlock);
    }

    public void d(WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat knockback) {
        this.a(EnchantmentEffectComponents.g, world, level, stack, user, damageSource, knockback);
    }

    public void e(WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat armorEffectiveness) {
        this.a(EnchantmentEffectComponents.h, world, level, stack, user, damageSource, armorEffectiveness);
    }

    public void a(WorldServer world, int level, EnchantedItemInUse context, EnchantmentTarget target, Entity user, DamageSource damageSource) {
        for (TargetedConditionalEffect targetedConditionalEffect : this.a(EnchantmentEffectComponents.i)) {
            if (target != targetedConditionalEffect.a()) continue;
            Enchantment.a(targetedConditionalEffect, world, level, context, user, damageSource);
        }
    }

    public static void a(TargetedConditionalEffect<EnchantmentEntityEffect> effect, WorldServer world, int level, EnchantedItemInUse context, Entity user, DamageSource damageSource) {
        if (effect.a(Enchantment.b(world, level, user, damageSource))) {
            Entity entity;
            switch (effect.b()) {
                default: {
                    throw new MatchException(null, null);
                }
                case a: {
                    Entity entity2 = damageSource.d();
                    break;
                }
                case b: {
                    Entity entity2 = damageSource.c();
                    break;
                }
                case c: {
                    Entity entity2 = entity = user;
                }
            }
            if (entity != null) {
                effect.c().a(world, level, context, entity, entity.du());
            }
        }
    }

    public void e(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat projectileCount) {
        this.a(EnchantmentEffectComponents.t, world, level, stack, user, projectileCount);
    }

    public void f(WorldServer world, int level, ItemStack stack, Entity user, MutableFloat projectileSpread) {
        this.a(EnchantmentEffectComponents.s, world, level, stack, user, projectileSpread);
    }

    public void b(RandomSource random, int level, MutableFloat crossbowChargeTime) {
        this.a(EnchantmentEffectComponents.A, random, level, crossbowChargeTime);
    }

    public void a(DataComponentType<EnchantmentValueEffect> type, RandomSource random, int level, MutableFloat value) {
        EnchantmentValueEffect enchantmentValueEffect = this.h.a(type);
        if (enchantmentValueEffect != null) {
            value.setValue(enchantmentValueEffect.a(level, random, value.floatValue()));
        }
    }

    public void a(WorldServer world, int level, EnchantedItemInUse context, Entity user) {
        Enchantment.a(this.a(EnchantmentEffectComponents.o), Enchantment.a(world, level, user, user.du()), (T effect) -> effect.a(world, level, context, user, user.du()));
    }

    public void b(WorldServer world, int level, EnchantedItemInUse context, Entity user) {
        Enchantment.a(this.a(EnchantmentEffectComponents.r), Enchantment.a(world, level, user, user.du()), (T effect) -> effect.a(world, level, context, user, user.du()));
    }

    public void a(WorldServer world, int level, EnchantedItemInUse context, Entity enchantedEntity, Vec3D pos, IBlockData state) {
        Enchantment.a(this.a(EnchantmentEffectComponents.j), Enchantment.a(world, level, enchantedEntity, pos, state), (T effect) -> effect.a(world, level, context, enchantedEntity, pos));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, WorldServer world, int level, ItemStack stack, MutableFloat value) {
        Enchantment.a(this.a(type), Enchantment.a(world, level, stack), (T effect) -> value.setValue(effect.a(level, world.H_(), value.getValue().floatValue())));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, WorldServer world, int level, ItemStack stack, Entity user, MutableFloat value) {
        Enchantment.a(this.a(type), Enchantment.a(world, level, user, user.du()), (T effect) -> value.setValue(effect.a(level, user.dZ(), value.floatValue())));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, WorldServer world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat value) {
        Enchantment.a(this.a(type), Enchantment.b(world, level, user, damageSource), (T effect) -> value.setValue(effect.a(level, user.dZ(), value.floatValue())));
    }

    public static LootTableInfo b(WorldServer world, int level, Entity entity, DamageSource damageSource) {
        LootParams lootParams = new LootParams.a(world).a(LootContextParameters.a, entity).a(LootContextParameters.k, level).a(LootContextParameters.f, entity.du()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c()).a(LootContextParameterSets.t);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer world, int level, ItemStack stack) {
        LootParams lootParams = new LootParams.a(world).a(LootContextParameters.i, stack).a(LootContextParameters.k, level).a(LootContextParameterSets.u);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer world, int level, Entity entity, boolean enchantmentActive) {
        LootParams lootParams = new LootParams.a(world).a(LootContextParameters.a, entity).a(LootContextParameters.k, level).a(LootContextParameters.f, entity.du()).a(LootContextParameters.l, enchantmentActive).a(LootContextParameterSets.v);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer world, int level, Entity entity, Vec3D pos) {
        LootParams lootParams = new LootParams.a(world).a(LootContextParameters.a, entity).a(LootContextParameters.k, level).a(LootContextParameters.f, pos).a(LootContextParameterSets.w);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer world, int level, Entity entity, Vec3D pos, IBlockData state) {
        LootParams lootParams = new LootParams.a(world).a(LootContextParameters.a, entity).a(LootContextParameters.k, level).a(LootContextParameters.f, pos).a(LootContextParameters.g, state).a(LootContextParameterSets.x);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static <T> void a(List<ConditionalEffect<T>> entries, LootTableInfo lootContext, Consumer<T> effectConsumer) {
        for (ConditionalEffect<T> conditionalEffect : entries) {
            if (!conditionalEffect.a(lootContext)) continue;
            effectConsumer.accept(conditionalEffect.a());
        }
    }

    public void a(WorldServer world, int level, EnchantedItemInUse context, EntityLiving user) {
        EnumItemSlot equipmentSlot = context.b();
        if (equipmentSlot == null) {
            return;
        }
        Map<Enchantment, Set<EnchantmentLocationBasedEffect>> map = user.c(equipmentSlot);
        if (!this.a(equipmentSlot)) {
            Set<EnchantmentLocationBasedEffect> set = map.remove(this);
            if (set != null) {
                set.forEach(effect -> effect.a(context, user, user.du(), level));
            }
            return;
        }
        ObjectArraySet set2 = map.get(this);
        for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.n)) {
            boolean bl;
            EnchantmentLocationBasedEffect enchantmentLocationBasedEffect = (EnchantmentLocationBasedEffect)conditionalEffect.a();
            boolean bl2 = bl = set2 != null && set2.contains(enchantmentLocationBasedEffect);
            if (conditionalEffect.a(Enchantment.a(world, level, (Entity)user, bl))) {
                if (!bl) {
                    if (set2 == null) {
                        set2 = new ObjectArraySet();
                        map.put(this, (Set<EnchantmentLocationBasedEffect>)set2);
                    }
                    set2.add((EnchantmentLocationBasedEffect)enchantmentLocationBasedEffect);
                }
                enchantmentLocationBasedEffect.a(world, level, context, user, user.du(), !bl);
                continue;
            }
            if (set2 == null || !set2.remove(enchantmentLocationBasedEffect)) continue;
            enchantmentLocationBasedEffect.a(context, user, user.du(), level);
        }
        if (set2 != null && set2.isEmpty()) {
            map.remove(this);
        }
    }

    public void a(int level, EnchantedItemInUse context, EntityLiving user) {
        EnumItemSlot equipmentSlot = context.b();
        if (equipmentSlot == null) {
            return;
        }
        Set<EnchantmentLocationBasedEffect> set = user.c(equipmentSlot).remove(this);
        if (set == null) {
            return;
        }
        for (EnchantmentLocationBasedEffect enchantmentLocationBasedEffect : set) {
            enchantmentLocationBasedEffect.a(context, user, user.du(), level);
        }
    }

    public static a a(c definition) {
        return new a(definition);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "e", "f", "g", "h"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "e", "f", "g", "h"}, this, object);
    }

    public IChatBaseComponent f() {
        return this.e;
    }

    public c g() {
        return this.f;
    }

    public HolderSet<Enchantment> h() {
        return this.g;
    }

    public DataComponentMap i() {
        return this.h;
    }

    public static final class c
    extends Record {
        private final HolderSet<Item> b;
        private final Optional<HolderSet<Item>> c;
        private final int d;
        private final int e;
        private final b f;
        private final b g;
        private final int h;
        private final List<EquipmentSlotGroup> i;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.a(Registries.K).fieldOf("supported_items").forGetter(c::a), (App)RegistryCodecs.a(Registries.K).optionalFieldOf("primary_items").forGetter(c::b), (App)ExtraCodecs.a(1, 1024).fieldOf("weight").forGetter(c::c), (App)ExtraCodecs.a(1, 255).fieldOf("max_level").forGetter(c::d), (App)net.minecraft.world.item.enchantment.Enchantment$b.a.fieldOf("min_cost").forGetter(c::e), (App)net.minecraft.world.item.enchantment.Enchantment$b.a.fieldOf("max_cost").forGetter(c::f), (App)ExtraCodecs.l.fieldOf("anvil_cost").forGetter(c::g), (App)EquipmentSlotGroup.l.listOf().fieldOf("slots").forGetter(c::h)).apply((Applicative)instance, c::new));

        public c(HolderSet<Item> holderSet, Optional<HolderSet<Item>> optional, int i2, int j2, b cost, b cost2, int k2, List<EquipmentSlotGroup> list) {
            this.b = holderSet;
            this.c = optional;
            this.d = i2;
            this.e = j2;
            this.f = cost;
            this.g = cost2;
            this.h = k2;
            this.i = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this, object);
        }

        public HolderSet<Item> a() {
            return this.b;
        }

        public Optional<HolderSet<Item>> b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public b e() {
            return this.f;
        }

        public b f() {
            return this.g;
        }

        public int g() {
            return this.h;
        }

        public List<EquipmentSlotGroup> h() {
            return this.i;
        }
    }

    public static final class b
    extends Record {
        private final int b;
        private final int c;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("base").forGetter(b::a), (App)Codec.INT.fieldOf("per_level_above_first").forGetter(b::b)).apply((Applicative)instance, b::new));

        public b(int i2, int j2) {
            this.b = i2;
            this.c = j2;
        }

        public int a(int level) {
            return this.b + this.c * (level - 1);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this, object);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    public static class a {
        private final c a;
        private HolderSet<Enchantment> b = HolderSet.a(new Holder[0]);
        private final Map<DataComponentType<?>, List<?>> c = new HashMap();
        private final DataComponentMap.a d = DataComponentMap.a();

        public a(c properties) {
            this.a = properties;
        }

        public a a(HolderSet<Enchantment> exclusiveSet) {
            this.b = exclusiveSet;
            return this;
        }

        public <E> a a(DataComponentType<List<ConditionalEffect<E>>> effectType, E effect, LootItemCondition.a requirements) {
            this.b(effectType).add(new ConditionalEffect<E>(effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> a a(DataComponentType<List<ConditionalEffect<E>>> effectType, E effect) {
            this.b(effectType).add(new ConditionalEffect<E>(effect, Optional.empty()));
            return this;
        }

        public <E> a a(DataComponentType<List<TargetedConditionalEffect<E>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect, LootItemCondition.a requirements) {
            this.b(type).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> a a(DataComponentType<List<TargetedConditionalEffect<E>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect) {
            this.b(type).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.empty()));
            return this;
        }

        public a a(DataComponentType<List<EnchantmentAttributeEffect>> type, EnchantmentAttributeEffect effect) {
            this.b(type).add(effect);
            return this;
        }

        public <E> a b(DataComponentType<E> type, E effect) {
            this.d.a(type, effect);
            return this;
        }

        public a a(DataComponentType<Unit> type) {
            this.d.a(type, Unit.a);
            return this;
        }

        private <E> List<E> b(DataComponentType<List<E>> type2) {
            return this.c.computeIfAbsent(type2, type -> {
                ArrayList arrayList = new ArrayList();
                this.d.a(type2, arrayList);
                return arrayList;
            });
        }

        public Enchantment a(MinecraftKey id) {
            return new Enchantment(IChatBaseComponent.c(SystemUtils.a("enchantment", id)), this.a, this.b, this.d.a());
        }
    }
}

