/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.phys.Vec3D;

public final class EnchantmentAttributeEffect
extends Record
implements EnchantmentLocationBasedEffect {
    private final MinecraftKey b;
    private final Holder<AttributeBase> d;
    private final LevelBasedValue e;
    private final AttributeModifier.Operation f;
    public static final MapCodec<EnchantmentAttributeEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.fieldOf("id").forGetter(EnchantmentAttributeEffect::b), (App)AttributeBase.a.fieldOf("attribute").forGetter(EnchantmentAttributeEffect::c), (App)LevelBasedValue.b.fieldOf("amount").forGetter(EnchantmentAttributeEffect::d), (App)AttributeModifier.Operation.f.fieldOf("operation").forGetter(EnchantmentAttributeEffect::e)).apply((Applicative)instance, EnchantmentAttributeEffect::new));

    public EnchantmentAttributeEffect(MinecraftKey resourceLocation, Holder<AttributeBase> holder, LevelBasedValue levelBasedValue, AttributeModifier.Operation operation) {
        this.b = resourceLocation;
        this.d = holder;
        this.e = levelBasedValue;
        this.f = operation;
    }

    private MinecraftKey a(INamable suffix) {
        return this.b.g("/" + suffix.c());
    }

    public AttributeModifier a(int value, INamable suffix) {
        return new AttributeModifier(this.a(suffix), this.d().a(value), this.e());
    }

    @Override
    @Override
    public void a(WorldServer world, int level, EnchantedItemInUse context, Entity user, Vec3D pos, boolean newlyApplied) {
        if (newlyApplied && user instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)user;
            livingEntity.eY().a((Multimap<Holder<AttributeBase>, AttributeModifier>)this.a(level, context.b()));
        }
    }

    @Override
    @Override
    public void a(EnchantedItemInUse context, Entity user, Vec3D pos, int level) {
        if (user instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)user;
            livingEntity.eY().b((Multimap<Holder<AttributeBase>, AttributeModifier>)this.a(level, context.b()));
        }
    }

    private HashMultimap<Holder<AttributeBase>, AttributeModifier> a(int level, EnumItemSlot slot) {
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put(this.d, (Object)this.a(level, (INamable)slot));
        return hashMultimap;
    }

    @Override
    public MapCodec<EnchantmentAttributeEffect> a() {
        return a;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this, object);
    }

    public MinecraftKey b() {
        return this.b;
    }

    public Holder<AttributeBase> c() {
        return this.d;
    }

    public LevelBasedValue d() {
        return this.e;
    }

    public AttributeModifier.Operation e() {
        return this.f;
    }
}

