/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;

public final class SpawnParticlesEffect
extends Record
implements EnchantmentEntityEffect {
    private final ParticleParam d;
    private final a e;
    private final a f;
    private final c g;
    private final c h;
    private final FloatProvider i;
    public static final MapCodec<SpawnParticlesEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Particles.bh.fieldOf("particle").forGetter(SpawnParticlesEffect::c), (App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$a.a.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::d), (App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$a.a.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::e), (App)c.a.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::f), (App)c.a.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::g), (App)FloatProvider.c.optionalFieldOf("speed", (Object)ConstantFloat.a).forGetter(SpawnParticlesEffect::h)).apply((Applicative)instance, SpawnParticlesEffect::new));

    public SpawnParticlesEffect(ParticleParam particleOptions, a positionSource, a positionSource2, c velocitySource, c velocitySource2, FloatProvider floatProvider) {
        this.d = particleOptions;
        this.e = positionSource;
        this.f = positionSource2;
        this.g = velocitySource;
        this.h = velocitySource2;
        this.i = floatProvider;
    }

    public static a a(float offset) {
        return new a(b.a, offset, 1.0f);
    }

    public static a b() {
        return new a(b.b, 0.0f, 1.0f);
    }

    public static c b(float movementScale) {
        return new c(movementScale, ConstantFloat.a);
    }

    public static c a(FloatProvider base) {
        return new c(0.0f, base);
    }

    @Override
    @Override
    public void a(WorldServer world, int level, EnchantedItemInUse context, Entity user, Vec3D pos) {
        RandomSource randomSource = user.dZ();
        Vec3D vec3 = user.ah();
        float f2 = user.dr();
        float g2 = user.ds();
        world.a(this.d, this.e.a(pos.a(), pos.a(), f2, randomSource), this.f.a(pos.b(), pos.b() + (double)(g2 / 2.0f), g2, randomSource), this.e.a(pos.c(), pos.c(), f2, randomSource), 0, this.g.a(vec3.a(), randomSource), this.h.a(vec3.b(), randomSource), this.g.a(vec3.c(), randomSource), this.i.a(randomSource));
    }

    @Override
    public MapCodec<SpawnParticlesEffect> a() {
        return a;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpawnParticlesEffect.class, "particle;horizontalPosition;verticalPosition;horizontalVelocity;verticalVelocity;speed", "d", "e", "f", "g", "h", "i"}, this, object);
    }

    public ParticleParam c() {
        return this.d;
    }

    public a d() {
        return this.e;
    }

    public a e() {
        return this.f;
    }

    public c f() {
        return this.g;
    }

    public c g() {
        return this.h;
    }

    public FloatProvider h() {
        return this.i;
    }

    public static final class a
    extends Record {
        private final b b;
        private final float c;
        private final float d;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.c.fieldOf("type").forGetter(a::a), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(a::b), (App)ExtraCodecs.o.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(a::c)).apply((Applicative)instance, a::new)).validate(source -> {
            if (source.a() == net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.a && source.c() != 1.0f) {
                return DataResult.error(() -> "Cannot scale an entity position coordinate source");
            }
            return DataResult.success((Object)source);
        });

        public a(b positionSourceType, float f2, float g2) {
            this.b = positionSourceType;
            this.c = f2;
            this.d = g2;
        }

        public double a(double entityPosition, double boundingBoxCenter, float boundingBoxSize, RandomSource random) {
            return this.b.a(entityPosition, boundingBoxCenter, boundingBoxSize * this.d, random) + (double)this.c;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;offset;scale", "b", "c", "d"}, this, object);
        }

        public b a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }
    }

    public static final class c
    extends Record {
        private final float b;
        private final FloatProvider c;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(c::a), (App)FloatProvider.c.optionalFieldOf("base", (Object)ConstantFloat.a).forGetter(c::b)).apply((Applicative)instance, c::new));

        public c(float f2, FloatProvider floatProvider) {
            this.b = f2;
            this.c = floatProvider;
        }

        public double a(double entityVelocity, RandomSource random) {
            return entityVelocity * (double)this.b + (double)this.c.a(random);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "movementScale;base", "b", "c"}, this, object);
        }

        public float a() {
            return this.b;
        }

        public FloatProvider b() {
            return this.c;
        }
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b a = new b("entity_position", (entityPosition, boundingBoxCenter, boundingBoxSize, random) -> entityPosition);
        public static final /* enum */ b b = new b("in_bounding_box", (entityPosition, boundingBoxCenter, boundingBoxSize, random) -> boundingBoxCenter + (random.j() - 0.5) * (double)boundingBoxSize);
        public static final Codec<b> c;
        private final String d;
        private final a e;
        private static final /* synthetic */ b[] f;

        public static b[] values() {
            return (b[])f.clone();
        }

        public static b valueOf(String string) {
            return Enum.valueOf(b.class, string);
        }

        private b(String id, a coordinateSource) {
            this.d = id;
            this.e = coordinateSource;
        }

        public double a(double entityPosition, double boundingBoxCenter, float boundingBoxSize, RandomSource random) {
            return this.e.getCoordinate(entityPosition, boundingBoxCenter, boundingBoxSize, random);
        }

        @Override
        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b};
        }

        static {
            f = net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect$b.a();
            c = INamable.a(b::values);
        }

        @FunctionalInterface
        static interface a {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

