/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.EquipmentModels;

public final class Equippable
extends Record {
    private final EnumItemSlot c;
    private final Holder<SoundEffect> d;
    private final Optional<MinecraftKey> e;
    private final Optional<MinecraftKey> f;
    private final Optional<HolderSet<EntityTypes<?>>> g;
    private final boolean h;
    private final boolean i;
    private final boolean j;
    public static final Codec<Equippable> a = RecordCodecBuilder.create(instance -> instance.group((App)EnumItemSlot.k.fieldOf("slot").forGetter(Equippable::a), (App)SoundEffect.b.optionalFieldOf("equip_sound", SoundEffects.as).forGetter(Equippable::b), (App)MinecraftKey.a.optionalFieldOf("model").forGetter(Equippable::c), (App)MinecraftKey.a.optionalFieldOf("camera_overlay").forGetter(Equippable::d), (App)RegistryCodecs.a(Registries.z).optionalFieldOf("allowed_entities").forGetter(Equippable::e), (App)Codec.BOOL.optionalFieldOf("dispensable", (Object)true).forGetter(Equippable::f), (App)Codec.BOOL.optionalFieldOf("swappable", (Object)true).forGetter(Equippable::g), (App)Codec.BOOL.optionalFieldOf("damage_on_hurt", (Object)true).forGetter(Equippable::h)).apply((Applicative)instance, Equippable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Equippable> b = StreamCodec.a(EnumItemSlot.l, Equippable::a, SoundEffect.d, Equippable::b, MinecraftKey.b.a(ByteBufCodecs::a), Equippable::c, MinecraftKey.b.a(ByteBufCodecs::a), Equippable::d, ByteBufCodecs.c(Registries.z).a(ByteBufCodecs::a), Equippable::e, ByteBufCodecs.b, Equippable::f, ByteBufCodecs.b, Equippable::g, ByteBufCodecs.b, Equippable::h, Equippable::new);

    public Equippable(EnumItemSlot equipmentSlot, Holder<SoundEffect> holder, Optional<MinecraftKey> optional, Optional<MinecraftKey> optional2, Optional<HolderSet<EntityTypes<?>>> optional3, boolean bl, boolean bl2, boolean bl3) {
        this.c = equipmentSlot;
        this.d = holder;
        this.e = optional;
        this.f = optional2;
        this.g = optional3;
        this.h = bl;
        this.i = bl2;
        this.j = bl3;
    }

    public static Equippable a(EnumColor color) {
        return Equippable.a(EnumItemSlot.g).a(SoundEffects.oy).a(EquipmentModels.j.get(color)).a(EntityTypes.ay, EntityTypes.by).a();
    }

    public static a a(EnumItemSlot slot) {
        return new a(slot);
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman player) {
        if (!player.e(this.c)) {
            return EnumInteractionResult.e;
        }
        ItemStack itemStack = player.a(this.c);
        if (EnchantmentManager.a(itemStack, EnchantmentEffectComponents.E) && !player.b() || ItemStack.c(stack, itemStack)) {
            return EnumInteractionResult.d;
        }
        if (!player.dW().B_()) {
            player.b(StatisticList.c.b(stack.h()));
        }
        if (stack.L() <= 1) {
            ItemStack itemStack2 = itemStack.f() ? stack : itemStack.g();
            ItemStack itemStack3 = player.b() ? stack.v() : stack.g();
            player.a(this.c, itemStack3);
            return EnumInteractionResult.a.a(itemStack2);
        }
        ItemStack itemStack4 = itemStack.g();
        ItemStack itemStack5 = stack.b(1, (EntityLiving)player);
        player.a(this.c, itemStack5);
        if (!player.gi().f(itemStack4)) {
            player.a(itemStack4, false);
        }
        return EnumInteractionResult.a.a(stack);
    }

    public boolean a(EntityTypes<?> entityType) {
        return this.g.isEmpty() || this.g.get().a(entityType.r());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Equippable.class, "slot;equipSound;model;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Equippable.class, "slot;equipSound;model;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Equippable.class, "slot;equipSound;model;cameraOverlay;allowedEntities;dispensable;swappable;damageOnHurt", "c", "d", "e", "f", "g", "h", "i", "j"}, this, object);
    }

    public EnumItemSlot a() {
        return this.c;
    }

    public Holder<SoundEffect> b() {
        return this.d;
    }

    public Optional<MinecraftKey> c() {
        return this.e;
    }

    public Optional<MinecraftKey> d() {
        return this.f;
    }

    public Optional<HolderSet<EntityTypes<?>>> e() {
        return this.g;
    }

    public boolean f() {
        return this.h;
    }

    public boolean g() {
        return this.i;
    }

    public boolean h() {
        return this.j;
    }

    public static class a {
        private final EnumItemSlot a;
        private Holder<SoundEffect> b = SoundEffects.as;
        private Optional<MinecraftKey> c = Optional.empty();
        private Optional<MinecraftKey> d = Optional.empty();
        private Optional<HolderSet<EntityTypes<?>>> e = Optional.empty();
        private boolean f = true;
        private boolean g = true;
        private boolean h = true;

        a(EnumItemSlot slot) {
            this.a = slot;
        }

        public a a(Holder<SoundEffect> equipSound) {
            this.b = equipSound;
            return this;
        }

        public a a(MinecraftKey model) {
            this.c = Optional.of(model);
            return this;
        }

        public a b(MinecraftKey cameraOverlay) {
            this.d = Optional.of(cameraOverlay);
            return this;
        }

        public a a(EntityTypes<?> ... allowedEntities) {
            return this.a(HolderSet.a(EntityTypes::r, allowedEntities));
        }

        public a a(HolderSet<EntityTypes<?>> allowedEntities) {
            this.e = Optional.of(allowedEntities);
            return this;
        }

        public a a(boolean dispensable) {
            this.f = dispensable;
            return this;
        }

        public a b(boolean swappable) {
            this.g = swappable;
            return this;
        }

        public a c(boolean damageOnHurt) {
            this.h = damageOnHurt;
            return this;
        }

        public Equippable a() {
            return new Equippable(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }
    }
}

