/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMerchantRecipe;

public class MerchantRecipe {
    public static final Codec<MerchantRecipe> a = RecordCodecBuilder.create(instance -> instance.group((App)ItemCost.a.fieldOf("buy").forGetter(merchantrecipe -> merchantrecipe.c), (App)ItemCost.a.lenientOptionalFieldOf("buyB").forGetter(merchantrecipe -> merchantrecipe.d), (App)ItemStack.a.fieldOf("sell").forGetter(merchantrecipe -> merchantrecipe.e), (App)Codec.INT.lenientOptionalFieldOf("uses", (Object)0).forGetter(merchantrecipe -> merchantrecipe.f), (App)Codec.INT.lenientOptionalFieldOf("maxUses", (Object)4).forGetter(merchantrecipe -> merchantrecipe.g), (App)Codec.BOOL.lenientOptionalFieldOf("rewardExp", (Object)true).forGetter(merchantrecipe -> merchantrecipe.h), (App)Codec.INT.lenientOptionalFieldOf("specialPrice", (Object)0).forGetter(merchantrecipe -> merchantrecipe.i), (App)Codec.INT.lenientOptionalFieldOf("demand", (Object)0).forGetter(merchantrecipe -> merchantrecipe.j), (App)Codec.FLOAT.lenientOptionalFieldOf("priceMultiplier", (Object)Float.valueOf(0.0f)).forGetter(merchantrecipe -> Float.valueOf(merchantrecipe.k)), (App)Codec.INT.lenientOptionalFieldOf("xp", (Object)1).forGetter(merchantrecipe -> merchantrecipe.l), (App)Codec.BOOL.lenientOptionalFieldOf("Paper.IgnoreDiscounts", (Object)false).forGetter(merchantrecipe -> merchantrecipe.ignoreDiscounts)).apply((Applicative)instance, MerchantRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantRecipe> b = StreamCodec.a(MerchantRecipe::a, MerchantRecipe::a);
    public ItemCost c;
    public Optional<ItemCost> d;
    public final ItemStack e;
    public int f;
    public int g;
    public boolean h;
    public int i;
    public int j;
    public float k;
    public int l;
    public boolean ignoreDiscounts;
    private CraftMerchantRecipe bukkitHandle;

    public CraftMerchantRecipe asBukkit() {
        return this.bukkitHandle == null ? (this.bukkitHandle = new CraftMerchantRecipe(this)) : this.bukkitHandle;
    }

    public MerchantRecipe(ItemCost baseCostA, Optional<ItemCost> costB, ItemStack result, int uses, int maxUses, int experience, float priceMultiplier, int demand, boolean ignoreDiscounts, CraftMerchantRecipe bukkit) {
        this(baseCostA, costB, result, uses, maxUses, experience, priceMultiplier, demand);
        this.ignoreDiscounts = ignoreDiscounts;
        this.bukkitHandle = bukkit;
    }

    private MerchantRecipe(ItemCost firstBuyItem, Optional<ItemCost> secondBuyItem, ItemStack sellItem, int uses, int maxUses, boolean rewardingPlayerExperience, int specialPrice, int demandBonus, float priceMultiplier, int merchantExperience, boolean ignoreDiscounts) {
        this.c = firstBuyItem;
        this.d = secondBuyItem;
        this.e = sellItem;
        this.f = uses;
        this.g = maxUses;
        this.h = rewardingPlayerExperience;
        this.i = specialPrice;
        this.j = demandBonus;
        this.k = priceMultiplier;
        this.l = merchantExperience;
        this.ignoreDiscounts = ignoreDiscounts;
    }

    public MerchantRecipe(ItemCost buyItem, ItemStack sellItem, int maxUses, int merchantExperience, float priceMultiplier) {
        this(buyItem, Optional.empty(), sellItem, maxUses, merchantExperience, priceMultiplier);
    }

    public MerchantRecipe(ItemCost firstBuyItem, Optional<ItemCost> secondBuyItem, ItemStack sellItem, int maxUses, int merchantExperience, float priceMultiplier) {
        this(firstBuyItem, secondBuyItem, sellItem, 0, maxUses, merchantExperience, priceMultiplier);
    }

    public MerchantRecipe(ItemCost firstBuyItem, Optional<ItemCost> secondBuyItem, ItemStack sellItem, int uses, int maxUses, int merchantExperience, float priceMultiplier) {
        this(firstBuyItem, secondBuyItem, sellItem, uses, maxUses, merchantExperience, priceMultiplier, 0);
    }

    public MerchantRecipe(ItemCost firstBuyItem, Optional<ItemCost> secondBuyItem, ItemStack sellItem, int uses, int maxUses, int merchantExperience, float priceMultiplier, int demandBonus) {
        this(firstBuyItem, secondBuyItem, sellItem, uses, maxUses, true, 0, demandBonus, priceMultiplier, merchantExperience, false);
    }

    private MerchantRecipe(MerchantRecipe offer) {
        this(offer.c, offer.d, offer.e.v(), offer.f, offer.g, offer.h, offer.i, offer.j, offer.k, offer.l, offer.ignoreDiscounts);
    }

    public ItemStack a() {
        return this.c.d();
    }

    public ItemStack b() {
        return this.c.d().c(this.a(this.c));
    }

    private int a(ItemCost firstBuyItem) {
        int i2 = firstBuyItem.b();
        int j2 = Math.max(0, MathHelper.d((float)(i2 * this.j) * this.k));
        return MathHelper.a(i2 + j2 + this.i, 1, firstBuyItem.d().k());
    }

    public ItemStack c() {
        return this.d.map(ItemCost::d).orElse(ItemStack.j);
    }

    public ItemCost d() {
        return this.c;
    }

    public Optional<ItemCost> e() {
        return this.d;
    }

    public ItemStack f() {
        return this.e;
    }

    public void g() {
        this.j = Math.max(0, this.j + this.f - (this.g - this.f));
    }

    public ItemStack h() {
        return this.e.v();
    }

    public int i() {
        return this.f;
    }

    public void j() {
        this.f = 0;
    }

    public int k() {
        return this.g;
    }

    public void l() {
        ++this.f;
    }

    public int m() {
        return this.j;
    }

    public void a(int increment) {
        this.i += increment;
    }

    public void n() {
        this.i = 0;
    }

    public int o() {
        return this.i;
    }

    public void b(int specialPrice) {
        this.i = specialPrice;
    }

    public float p() {
        return this.k;
    }

    public int q() {
        return this.l;
    }

    public boolean r() {
        return this.f >= this.g;
    }

    public void s() {
        this.f = this.g;
    }

    public boolean t() {
        return this.f > 0;
    }

    public boolean u() {
        return this.h;
    }

    public boolean a(ItemStack stack, ItemStack buyItem) {
        return this.c.a(stack) && stack.L() >= this.a(this.c) ? (!this.d.isPresent() ? buyItem.f() : this.d.get().a(buyItem) && buyItem.L() >= this.d.get().b()) : false;
    }

    public boolean b(ItemStack firstBuyStack, ItemStack secondBuyStack) {
        if (!this.a(firstBuyStack, secondBuyStack)) {
            return false;
        }
        if (!this.b().f()) {
            firstBuyStack.h(this.b().L());
        }
        if (!this.c().f()) {
            secondBuyStack.h(this.c().L());
        }
        return true;
    }

    public MerchantRecipe v() {
        return new MerchantRecipe(this);
    }

    private static void a(RegistryFriendlyByteBuf buf, MerchantRecipe offer) {
        ItemCost.b.encode(buf, offer.d());
        ItemStack.h.encode(buf, offer.f());
        ItemCost.c.encode(buf, offer.e());
        buf.a(offer.r());
        buf.q(offer.i());
        buf.q(offer.k());
        buf.q(offer.q());
        buf.q(offer.o());
        buf.a(offer.p());
        buf.q(offer.m());
    }

    public static MerchantRecipe a(RegistryFriendlyByteBuf buf) {
        ItemCost itemcost = (ItemCost)ItemCost.b.decode(buf);
        ItemStack itemstack = (ItemStack)ItemStack.h.decode(buf);
        Optional optional = (Optional)ItemCost.c.decode(buf);
        boolean flag = buf.readBoolean();
        int i2 = buf.readInt();
        int j2 = buf.readInt();
        int k2 = buf.readInt();
        int l2 = buf.readInt();
        float f2 = buf.readFloat();
        int i1 = buf.readInt();
        MerchantRecipe merchantrecipe = new MerchantRecipe(itemcost, optional, itemstack, i2, j2, k2, f2, i1);
        if (flag) {
            merchantrecipe.s();
        }
        merchantrecipe.b(l2);
        return merchantrecipe;
    }
}

