/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements ICollisionAccess {
    protected final int a;
    protected final int b;
    protected final IChunkAccess[][] c;
    protected boolean d;
    protected final World e;
    private final Supplier<Holder<BiomeBase>> f;

    public ChunkCache(World world, BlockPosition minPos, BlockPosition maxPos) {
        this.e = world;
        this.f = Suppliers.memoize(() -> world.K_().e(Registries.aI).b(Biomes.b));
        this.a = SectionPosition.a(minPos.u());
        this.b = SectionPosition.a(minPos.w());
        int i2 = SectionPosition.a(maxPos.u());
        int j2 = SectionPosition.a(maxPos.w());
        this.c = new IChunkAccess[i2 - this.a + 1][j2 - this.b + 1];
        IChunkProvider chunkSource = world.R();
        this.d = true;
        for (int k2 = this.a; k2 <= i2; ++k2) {
            for (int l2 = this.b; l2 <= j2; ++l2) {
                this.c[k2 - this.a][l2 - this.b] = chunkSource.a(k2, l2);
            }
        }
        for (int m2 = SectionPosition.a(minPos.u()); m2 <= SectionPosition.a(maxPos.u()); ++m2) {
            for (int n2 = SectionPosition.a(minPos.w()); n2 <= SectionPosition.a(maxPos.w()); ++n2) {
                IChunkAccess chunkAccess = this.c[m2 - this.a][n2 - this.b];
                if (chunkAccess == null || chunkAccess.a(minPos.v(), maxPos.v())) continue;
                this.d = false;
                return;
            }
        }
    }

    private IChunkAccess d(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    private IChunkAccess a(int chunkX, int chunkZ) {
        int i2 = chunkX - this.a;
        int j2 = chunkZ - this.b;
        if (i2 >= 0 && i2 < this.c.length && j2 >= 0 && j2 < this.c[i2].length) {
            IChunkAccess chunkAccess = this.c[i2][j2];
            return chunkAccess != null ? chunkAccess : new ChunkEmpty(this.e, new ChunkCoordIntPair(chunkX, chunkZ), this.f.get());
        }
        return new ChunkEmpty(this.e, new ChunkCoordIntPair(chunkX, chunkZ), this.f.get());
    }

    @Nullable
    private IChunkAccess getChunkIfLoaded(int x2, int z2) {
        int xx = x2 - this.a;
        int zz = z2 - this.b;
        if (xx >= 0 && xx < this.c.length && zz >= 0 && zz < this.c[xx].length) {
            return this.c[xx][zz];
        }
        return null;
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoaded(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoaded(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.a_(blockposition);
    }

    @Override
    public WorldBorder F_() {
        return this.e.F_();
    }

    @Override
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ);
    }

    @Override
    public List<VoxelShape> c(@Nullable Entity entity, AxisAlignedBB box) {
        return List.of();
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.c_(pos);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        if (this.s(pos)) {
            return Blocks.a.m();
        }
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.s(pos)) {
            return FluidTypes.a.g();
        }
        IChunkAccess chunkAccess = this.d(pos);
        return chunkAccess.b_(pos);
    }

    @Override
    public int L_() {
        return this.e.L_();
    }

    @Override
    public int M_() {
        return this.e.M_();
    }
}

