/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkCoordIntPair {
    public static final Codec<ChunkCoordIntPair> a = Codec.INT_STREAM.comapFlatMap(stream -> SystemUtils.a(stream, 2).map(coords -> new ChunkCoordIntPair(coords[0], coords[1])), chunkPos -> IntStream.of(chunkPos.h, chunkPos.i)).stable();
    public static final StreamCodec<ByteBuf, ChunkCoordIntPair> b = new StreamCodec<ByteBuf, ChunkCoordIntPair>(){

        public ChunkCoordIntPair a(ByteBuf byteBuf) {
            return PacketDataSerializer.c(byteBuf);
        }

        public void a(ByteBuf byteBuf, ChunkCoordIntPair chunkPos) {
            PacketDataSerializer.a(byteBuf, chunkPos);
        }
    };
    private static final int j = 1056;
    public static final long c = ChunkCoordIntPair.c(1875066, 1875066);
    private static final int k = (32 + ChunkPyramid.a.a(ChunkStatus.n).c().b() + 1) * 2;
    public static final int d = SectionPosition.a(0x1FFFFFF) - k;
    public static final ChunkCoordIntPair e = new ChunkCoordIntPair(0, 0);
    private static final long l = 32L;
    private static final long m = 0xFFFFFFFFL;
    private static final int n = 5;
    public static final int f = 32;
    private static final int o = 31;
    public static final int g = 31;
    public final int h;
    public final int i;
    public final long longKey;
    private static final int p = 1664525;
    private static final int q = 1013904223;
    private static final int r = -559038737;

    public ChunkCoordIntPair(int x2, int z2) {
        this.h = x2;
        this.i = z2;
        this.longKey = ChunkCoordIntPair.c(this.h, this.i);
    }

    public ChunkCoordIntPair(BlockPosition pos) {
        this.h = SectionPosition.a(pos.u());
        this.i = SectionPosition.a(pos.w());
        this.longKey = ChunkCoordIntPair.c(this.h, this.i);
    }

    public ChunkCoordIntPair(long pos) {
        this.h = (int)pos;
        this.i = (int)(pos >> 32);
        this.longKey = ChunkCoordIntPair.c(this.h, this.i);
    }

    public static ChunkCoordIntPair a(int x2, int z2) {
        return new ChunkCoordIntPair(x2 << 5, z2 << 5);
    }

    public static ChunkCoordIntPair b(int x2, int z2) {
        return new ChunkCoordIntPair((x2 << 5) + 31, (z2 << 5) + 31);
    }

    public long a() {
        return this.longKey;
    }

    public static long c(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static long a(BlockPosition pos) {
        return ChunkCoordIntPair.c(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public static int a(long pos) {
        return (int)(pos & 0xFFFFFFFFL);
    }

    public static int b(long pos) {
        return (int)(pos >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return ChunkCoordIntPair.d(this.h, this.i);
    }

    public static int d(int x2, int z2) {
        int i2 = 1664525 * x2 + 1013904223;
        int j2 = 1664525 * (z2 ^ 0xDEADBEEF) + 1013904223;
        return i2 ^ j2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof ChunkCoordIntPair)) return false;
        ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)object;
        if (this.h != chunkPos.h) return false;
        if (this.i != chunkPos.i) return false;
        return true;
    }

    public int b() {
        return this.a(8);
    }

    public int c() {
        return this.b(8);
    }

    public int d() {
        return SectionPosition.c(this.h);
    }

    public int e() {
        return SectionPosition.c(this.i);
    }

    public int f() {
        return this.a(15);
    }

    public int g() {
        return this.b(15);
    }

    public int h() {
        return this.h >> 5;
    }

    public int i() {
        return this.i >> 5;
    }

    public int j() {
        return this.h & 0x1F;
    }

    public int k() {
        return this.i & 0x1F;
    }

    public BlockPosition a(int offsetX, int y2, int offsetZ) {
        return new BlockPosition(this.a(offsetX), y2, this.b(offsetZ));
    }

    public int a(int offset) {
        return SectionPosition.a(this.h, offset);
    }

    public int b(int offset) {
        return SectionPosition.a(this.i, offset);
    }

    public BlockPosition c(int y2) {
        return new BlockPosition(this.b(), y2, this.c());
    }

    public String toString() {
        return "[" + this.h + ", " + this.i + "]";
    }

    public BlockPosition l() {
        return new BlockPosition(this.d(), 0, this.e());
    }

    public int a(ChunkCoordIntPair pos) {
        return this.e(pos.h, pos.i);
    }

    public int e(int x2, int z2) {
        return Math.max(Math.abs(this.h - x2), Math.abs(this.i - z2));
    }

    public int b(ChunkCoordIntPair pos) {
        return this.f(pos.h, pos.i);
    }

    public int c(long pos) {
        return this.f(ChunkCoordIntPair.a(pos), ChunkCoordIntPair.b(pos));
    }

    private int f(int x2, int z2) {
        int i2 = x2 - this.h;
        int j2 = z2 - this.i;
        return i2 * i2 + j2 * j2;
    }

    public static Stream<ChunkCoordIntPair> a(ChunkCoordIntPair center, int radius) {
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(center.h - radius, center.i - radius), new ChunkCoordIntPair(center.h + radius, center.i + radius));
    }

    public static Stream<ChunkCoordIntPair> a(final ChunkCoordIntPair pos1, final ChunkCoordIntPair pos2) {
        int i2 = Math.abs(pos1.h - pos2.h) + 1;
        int j2 = Math.abs(pos1.i - pos2.i) + 1;
        final int k2 = pos1.h < pos2.h ? 1 : -1;
        final int l2 = pos1.i < pos2.i ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkCoordIntPair>((long)(i2 * j2), 64){
            @Nullable
            private ChunkCoordIntPair e;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkCoordIntPair> consumer) {
                if (this.e == null) {
                    this.e = pos1;
                } else {
                    int i2 = this.e.h;
                    int j2 = this.e.i;
                    if (i2 == pos2.h) {
                        if (j2 == pos2.i) {
                            return false;
                        }
                        this.e = new ChunkCoordIntPair(pos1.h, j2 + l2);
                    } else {
                        this.e = new ChunkCoordIntPair(i2 + k2, j2);
                    }
                }
                consumer.accept(this.e);
                return true;
            }
        }, false);
    }
}

