/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.GameRule;
import org.slf4j.Logger;

public class GameRules {
    private static final boolean DISABLE_LIMITS = Boolean.getBoolean("paper.disableGameRuleLimits");
    public static final int a = 3;
    static final Logger ac = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> ad = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.a));
    public static final GameRuleKey<GameRuleBoolean> b = GameRules.a("doFireTick", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> c = GameRules.a("mobGriefing", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> d = GameRules.a("keepInventory", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> e = GameRules.a("doMobSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> f = GameRules.a("doMobLoot", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> g = GameRules.a("projectilesCanBreakBlocks", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> h = GameRules.a("doTileDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> i = GameRules.a("doEntityDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> j = GameRules.a("commandBlockOutput", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> k = GameRules.a("naturalRegeneration", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> l = GameRules.a("doDaylightCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> m = GameRules.a("logAdminCommands", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> n = GameRules.a("showDeathMessages", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> o = GameRules.a("randomTickSpeed", GameRuleCategory.e, GameRuleInt.a(3));
    public static final GameRuleKey<GameRuleBoolean> p = GameRules.a("sendCommandFeedback", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> q = GameRules.a("reducedDebugInfo", GameRuleCategory.g, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        int i2 = gamerules_gameruleboolean.a() ? 22 : 23;
        for (EntityPlayer entityplayer : minecraftserver.y()) {
            entityplayer.f.b(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> r = GameRules.a("spectatorsGenerateChunks", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> s = GameRules.a("spawnRadius", GameRuleCategory.a, GameRuleInt.a(10));
    public static final GameRuleKey<GameRuleBoolean> t = GameRules.a("disablePlayerMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> u = GameRules.a("disableElytraMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> v = GameRules.a("maxEntityCramming", GameRuleCategory.b, GameRuleInt.a(24));
    public static final GameRuleKey<GameRuleBoolean> w = GameRules.a("doWeatherCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> x = GameRules.a("doLimitedCrafting", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.y()) {
            entityplayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.n, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> y = GameRules.a("maxCommandChainLength", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> z = GameRules.a("maxCommandForkCount", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> A = GameRules.a("commandModificationBlockLimit", GameRuleCategory.g, GameRuleInt.a(32768));
    public static final GameRuleKey<GameRuleBoolean> B = GameRules.a("announceAdvancements", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> C = GameRules.a("disableRaids", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> D = GameRules.a("doInsomnia", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> E = GameRules.a("doImmediateRespawn", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.y()) {
            entityplayer.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> F = GameRules.a("playersNetherPortalDefaultDelay", GameRuleCategory.a, GameRuleInt.a(80));
    public static final GameRuleKey<GameRuleInt> G = GameRules.a("playersNetherPortalCreativeDelay", GameRuleCategory.a, GameRuleInt.a(0));
    public static final GameRuleKey<GameRuleBoolean> H = GameRules.a("drowningDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> I = GameRules.a("fallDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> J = GameRules.a("fireDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> K = GameRules.a("freezeDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> L = GameRules.a("doPatrolSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> M = GameRules.a("doTraderSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> N = GameRules.a("doWardenSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> O = GameRules.a("forgiveDeadPlayers", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> P = GameRules.a("universalAnger", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> Q = GameRules.a("playersSleepingPercentage", GameRuleCategory.a, GameRuleInt.a(100));
    public static final GameRuleKey<GameRuleBoolean> R = GameRules.a("blockExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> S = GameRules.a("mobExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> T = GameRules.a("tntExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> U = GameRules.a("snowAccumulationHeight", GameRuleCategory.e, GameRuleInt.a(1));
    public static final GameRuleKey<GameRuleBoolean> V = GameRules.a("waterSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> W = GameRules.a("lavaSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> X = GameRules.a("globalSoundEvents", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Y = GameRules.a("doVinesSpread", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Z = GameRules.a("enderPearlsVanishOnDeath", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> aa = GameRules.a("minecartMaxSpeed", GameRuleCategory.g, GameRuleInt.a(8, 1, GameRules.limit(1000, Integer.MAX_VALUE), FeatureFlagSet.a(FeatureFlags.e), (minecraftserver, gamerules_gameruleint) -> {}));
    public static final GameRuleKey<GameRuleInt> ab = GameRules.a("spawnChunkRadius", GameRuleCategory.g, GameRuleInt.a(2, 0, GameRules.limit(32, Integer.MAX_VALUE), FeatureFlagSet.a(), (minecraftserver, gamerules_gameruleint) -> {
        WorldServer worldserver = minecraftserver;
        worldserver.a(worldserver.Y(), worldserver.Z());
    }));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> ae;
    private final FeatureFlagSet af;
    private final GameRuleValue<?>[] gameruleArray;

    private static int limit(int limit, int unlimited) {
        return DISABLE_LIMITS ? unlimited : limit;
    }

    private static <T extends GameRuleValue<T>> GameRuleKey<T> a(String name, GameRuleCategory category, GameRuleDefinition<T> type) {
        GameRuleKey gamerules_gamerulekey = new GameRuleKey(name, category);
        GameRuleDefinition<T> gamerules_gameruledefinition1 = ad.put(gamerules_gamerulekey, type);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + name);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(FeatureFlagSet enabledFeatures, DynamicLike<?> values) {
        this(enabledFeatures);
        this.a(values);
    }

    public GameRules(FeatureFlagSet enabledFeatures) {
        this((Map)GameRules.b(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).a())), enabledFeatures);
    }

    private static Stream<Map.Entry<GameRuleKey<?>, GameRuleDefinition<?>>> b(FeatureFlagSet enabledFeatures) {
        return ad.entrySet().stream().filter(entry -> ((GameRuleDefinition)entry.getValue()).e.a(enabledFeatures));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> rules, FeatureFlagSet enabledFeatures) {
        this.ae = rules;
        this.af = enabledFeatures;
        int arraySize = GameRuleKey.lastGameRuleIndex + 1;
        GameRuleValue[] values = new GameRuleValue[arraySize];
        for (Map.Entry<GameRuleKey<?>, GameRuleValue<?>> entry : rules.entrySet()) {
            values[entry.getKey().gameRuleIndex] = entry.getValue();
        }
        this.gameruleArray = values;
    }

    public <T extends GameRuleValue<T>> T a(GameRuleKey<T> key) {
        GameRuleValue<?> t0;
        GameRuleValue<?> gameRuleValue = t0 = key == null ? null : this.gameruleArray[key.gameRuleIndex];
        if (t0 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)t0;
    }

    public NBTTagCompound a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.ae.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.a(gamerules_gamerulekey.a, gamerules_gamerulevalue.b()));
        return nbttagcompound;
    }

    private void a(DynamicLike<?> values) {
        this.ae.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            DataResult dataresult = values.get(gamerules_gamerulekey.a).asString();
            Objects.requireNonNull(gamerules_gamerulevalue);
            dataresult.ifSuccess(gamerules_gamerulevalue::a);
        });
    }

    public GameRules a(FeatureFlagSet enabledFeatures) {
        return new GameRules((Map)GameRules.b(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.ae.containsKey(entry.getKey()) ? this.ae.get(entry.getKey()) : ((GameRuleDefinition)entry.getValue()).a())), enabledFeatures);
    }

    public void a(GameRuleVisitor visitor) {
        ad.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> this.a(visitor, (GameRuleKey<?>)gamerules_gamerulekey, (GameRuleDefinition<?>)gamerules_gameruledefinition));
    }

    private <T extends GameRuleValue<T>> void a(GameRuleVisitor visitor, GameRuleKey<?> key, GameRuleDefinition<?> type) {
        if (type.e.a(this.af)) {
            visitor.a(key, type);
            type.a(visitor, key);
        }
    }

    public void assignFrom(GameRules gamerules, @Nullable WorldServer minecraftserver) {
        gamerules.ae.keySet().forEach(gamerules_gamerulekey -> this.assignCap((GameRuleKey)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends GameRuleValue<T>> void assignCap(GameRuleKey<T> gamerules_gamerulekey, GameRules gamerules, @Nullable WorldServer minecraftserver) {
        T t0 = gamerules.a(gamerules_gamerulekey);
        ((GameRuleValue)this.a(gamerules_gamerulekey)).setFrom(t0, minecraftserver);
    }

    public boolean b(GameRuleKey<GameRuleBoolean> rule) {
        return this.a(rule).a();
    }

    public int c(GameRuleKey<GameRuleInt> rule) {
        return this.a(rule).a();
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        public static int lastGameRuleIndex = 0;
        public final int gameRuleIndex = lastGameRuleIndex++;
        final String a;
        private final GameRuleCategory b;

        public GameRuleKey(String name, GameRuleCategory category) {
            this.a = name;
            this.b = category;
        }

        public String toString() {
            return this.a;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof GameRuleKey && ((GameRuleKey)object).a.equals(this.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return "gamerule." + this.a;
        }

        public GameRuleCategory c() {
            return this.b;
        }
    }

    public static enum GameRuleCategory {
        a("gamerule.category.player"),
        b("gamerule.category.mobs"),
        c("gamerule.category.spawning"),
        d("gamerule.category.drops"),
        e("gamerule.category.updates"),
        f("gamerule.category.chat"),
        g("gamerule.category.misc");

        private final String h;

        private GameRuleCategory(String s2) {
            this.h = s2;
        }

        public String a() {
            return this.h;
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        final Supplier<ArgumentType<?>> a;
        private final Function<GameRuleDefinition<T>, T> b;
        final BiConsumer<WorldServer, T> c;
        private final h<T> d;
        final FeatureFlagSet e;

        GameRuleDefinition(Supplier<ArgumentType<?>> argumentType, Function<GameRuleDefinition<T>, T> ruleFactory, BiConsumer<WorldServer, T> changeCallback, h<T> ruleAcceptor, FeatureFlagSet requiredFeatures) {
            this.a = argumentType;
            this.b = ruleFactory;
            this.c = changeCallback;
            this.d = ruleAcceptor;
            this.e = requiredFeatures;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> a(String name) {
            return CommandDispatcher.a(name, this.a.get());
        }

        public T a() {
            return (T)((GameRuleValue)this.b.apply(this));
        }

        public void a(GameRuleVisitor consumer, GameRuleKey<T> key) {
            this.d.call(consumer, key, this);
        }

        public FeatureFlagSet b() {
            return this.e;
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> a;

        public GameRuleValue(GameRuleDefinition<T> type) {
            this.a = type;
        }

        protected abstract void updateFromArgument(CommandContext<CommandListenerWrapper> var1, String var2, GameRuleKey<T> var3);

        public void setFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<T> gameRuleKey) {
            this.updateFromArgument(context, name, gameRuleKey);
            this.onChanged(((CommandListenerWrapper)context.getSource()).e());
        }

        public void onChanged(@Nullable WorldServer minecraftserver) {
            if (minecraftserver != null) {
                this.a.c.accept(minecraftserver, (WorldServer)this.g());
            }
        }

        public abstract void a(String var1);

        public abstract String b();

        public String toString() {
            return this.b();
        }

        public abstract int c();

        protected abstract T g();

        protected abstract T f();

        public abstract void setFrom(T var1, @Nullable WorldServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void a(GameRuleKey<T> key, GameRuleDefinition<T> type) {
        }

        default public void b(GameRuleKey<GameRuleBoolean> key, GameRuleDefinition<GameRuleBoolean> type) {
        }

        default public void c(GameRuleKey<GameRuleInt> key, GameRuleDefinition<GameRuleInt> type) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean b;

        static GameRuleDefinition<GameRuleBoolean> a(boolean initialValue, BiConsumer<WorldServer, GameRuleBoolean> changeCallback) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleVisitor::b, FeatureFlagSet.a());
        }

        static GameRuleDefinition<GameRuleBoolean> a(boolean initialValue) {
            return GameRuleBoolean.a(initialValue, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> type, boolean initialValue) {
            super(type);
            this.b = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<GameRuleBoolean> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(BoolArgumentType.getBool(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Boolean.parseBoolean(event.getValue());
        }

        public boolean a() {
            return this.b;
        }

        public void set(boolean flag, @Nullable WorldServer minecraftserver) {
            this.b = flag;
            this.onChanged(minecraftserver);
        }

        @Override
        public String b() {
            return Boolean.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = Boolean.parseBoolean(value);
        }

        @Override
        public int c() {
            return this.b ? 1 : 0;
        }

        protected GameRuleBoolean d() {
            return this;
        }

        protected GameRuleBoolean e() {
            return new GameRuleBoolean(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleBoolean gamerules_gameruleboolean, @Nullable WorldServer minecraftserver) {
            this.b = gamerules_gameruleboolean.b;
            this.onChanged(minecraftserver);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int b;

        private static GameRuleDefinition<GameRuleInt> a(int initialValue, BiConsumer<WorldServer, GameRuleInt> changeCallback) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleVisitor::c, FeatureFlagSet.a());
        }

        static GameRuleDefinition<GameRuleInt> a(int initialValue, int min, int max, FeatureFlagSet requiredFeatures, BiConsumer<WorldServer, GameRuleInt> changeCallback) {
            return new GameRuleDefinition<GameRuleInt>(() -> IntegerArgumentType.integer((int)min, (int)max), gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleVisitor::c, requiredFeatures);
        }

        static GameRuleDefinition<GameRuleInt> a(int initialValue) {
            return GameRuleInt.a(initialValue, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> rule, int initialValue) {
            super(rule);
            this.b = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<GameRuleInt> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Integer.parseInt(event.getValue());
        }

        public int a() {
            return this.b;
        }

        public void set(int i2, @Nullable WorldServer minecraftserver) {
            this.b = i2;
            this.onChanged(minecraftserver);
        }

        @Override
        public String b() {
            return Integer.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = GameRuleInt.c(value);
        }

        public boolean b(String input) {
            try {
                StringReader stringreader = new StringReader(input);
                this.b = (Integer)this.a.a.get().parse(stringreader);
                return !stringreader.canRead();
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        }

        private static int c(String input) {
            if (!input.isEmpty()) {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException numberformatexception) {
                    ac.warn("Failed to parse integer {}", (Object)input);
                }
            }
            return 0;
        }

        @Override
        public int c() {
            return this.b;
        }

        protected GameRuleInt d() {
            return this;
        }

        protected GameRuleInt e() {
            return new GameRuleInt(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleInt gamerules_gameruleint, @Nullable WorldServer minecraftserver) {
            this.b = gamerules_gameruleint.b;
            this.onChanged(minecraftserver);
        }
    }

    private static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

