/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.HumanEntity;

public interface IEntityAccess
extends ChunkSystemEntityGetter {
    public List<Entity> a(@Nullable Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box, Predicate<? super T> predicate) {
        return this.a((EntityTypeTest<Entity, T>)EntityTypeTest.a(entityClass), box, predicate);
    }

    public List<? extends EntityHuman> y();

    default public List<Entity> a_(@Nullable Entity except, AxisAlignedBB box) {
        return this.a(except, box, IEntitySelector.f);
    }

    @Override
    default public List<Entity> moonrise$getHardCollidingEntities(Entity entity, AxisAlignedBB box, Predicate<? super Entity> predicate) {
        return this.a(entity, box, predicate);
    }

    default public boolean a(@Nullable Entity entity, VoxelShape voxel) {
        if (voxel.c()) {
            return false;
        }
        AxisAlignedBB singleAABB = voxel.moonrise$getSingleAABBRepresentation();
        List<Entity> entities = this.a_(entity, singleAABB == null ? voxel.a() : singleAABB.c(-1.0E-7, -1.0E-7, -1.0E-7));
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB entityBB;
            Entity otherEntity = entities.get(i2);
            if (otherEntity.dR() || !otherEntity.I || entity != null && otherEntity.z(entity) || singleAABB == null && (CollisionUtil.isEmpty(entityBB = otherEntity.cR()) || !CollisionUtil.voxelShapeIntersectNoEmpty(voxel, entityBB))) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box) {
        return this.a(entityClass, box, IEntitySelector.f);
    }

    default public List<VoxelShape> c(@Nullable Entity entity, AxisAlignedBB box) {
        if (CollisionUtil.isEmpty(box)) {
            return new ArrayList<VoxelShape>();
        }
        box = box.c(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.moonrise$isHardColliding() ? this.a(entity, box, null) : this.moonrise$getHardCollidingEntities(entity, box, null);
        ArrayList<VoxelShape> ret = new ArrayList<VoxelShape>(Math.min(25, entities.size()));
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Entity otherEntity = entities.get(i2);
            if (otherEntity.aa_() || (entity != null || !otherEntity.bN()) && (entity == null || !entity.i(otherEntity))) continue;
            ret.add(VoxelShapes.a(otherEntity.cR()));
        }
        return ret;
    }

    @Nullable
    default public EntityHuman findNearbyPlayer(Entity entity, double maxDistance, @Nullable Predicate<Entity> predicate) {
        return this.a(entity.dB(), entity.dD(), entity.dH(), maxDistance, predicate);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double maxDistance, @Nullable Predicate<Entity> targetPredicate) {
        double d2 = -1.0;
        EntityHuman player = null;
        for (EntityHuman entityHuman : this.y()) {
            if (targetPredicate != null && !targetPredicate.test(entityHuman)) continue;
            double e2 = entityHuman.i(x2, y2, z2);
            if (!(maxDistance < 0.0) && !(e2 < maxDistance * maxDistance) || d2 != -1.0 && !(e2 < d2)) continue;
            d2 = e2;
            player = entityHuman;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x2, y2, z2, radius, notSpectator ? IEntitySelector.f : IEntitySelector.e);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityHuman entityHuman : this.y()) {
            if (predicate != null && !predicate.test(entityHuman)) continue;
            double distanceSquared = entityHuman.i(x2, y2, z2);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)entityHuman.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public EntityHuman a(Entity entity, double maxDistance) {
        return this.a(entity.dB(), entity.dD(), entity.dH(), maxDistance, false);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double maxDistance, boolean ignoreCreative) {
        Predicate<Entity> predicate = ignoreCreative ? IEntitySelector.e : IEntitySelector.f;
        return this.a(x2, y2, z2, maxDistance, predicate);
    }

    default public boolean hasNearbyAlivePlayerThatAffectsSpawning(double x2, double y2, double z2, double range) {
        for (EntityHuman entityHuman : this.y()) {
            if (!IEntitySelector.PLAYER_AFFECTS_SPAWNING.test(entityHuman)) continue;
            double distanceSqr = entityHuman.i(x2, y2, z2);
            if (!(range < 0.0) && !(distanceSqr < range * range)) continue;
            return true;
        }
        return false;
    }

    default public boolean a(double x2, double y2, double z2, double range) {
        for (EntityHuman entityHuman : this.y()) {
            if (!IEntitySelector.f.test(entityHuman) || !IEntitySelector.b.test(entityHuman)) continue;
            double d2 = entityHuman.i(x2, y2, z2);
            if (!(range < 0.0) && !(d2 < range * range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public EntityHuman b(UUID uuid) {
        for (int i2 = 0; i2 < this.y().size(); ++i2) {
            EntityHuman player = this.y().get(i2);
            if (!uuid.equals(player.cG())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    default public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.b(uuid);
    }
}

