/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftSpawnCategory;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class SpawnerCreature {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 24;
    public static final int a = 8;
    public static final int b = 128;
    static final int e = (int)Math.pow(17.0, 2.0);
    public static final EnumCreatureType[] f = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(enumcreaturetype -> enumcreaturetype != EnumCreatureType.h).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d a(int spawningChunkCount, Iterable<Entity> entities, b chunkSource, LocalMobCapCalculator densityCapper) {
        return SpawnerCreature.createState(spawningChunkCount, entities, chunkSource, densityCapper, false);
    }

    public static d createState(int spawningChunkCount, Iterable<Entity> entities, b chunkSource, LocalMobCapCalculator densityCapper, boolean countMobs) {
        SpawnerCreatureProbabilities spawnercreatureprobabilities = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : entities) {
            EnumCreatureType enumcreaturetype;
            EntityInsentient entityinsentient;
            if (entity instanceof EntityInsentient && ((entityinsentient = (EntityInsentient)entity).aj() || entityinsentient.W()) || (enumcreaturetype = entity.aq().f()) == EnumCreatureType.h || !entity.dW().paperConfig().entities.spawning.countAllMobsForSpawning && entity.spawnReason != CreatureSpawnEvent.SpawnReason.NATURAL && entity.spawnReason != CreatureSpawnEvent.SpawnReason.CHUNK_GEN) continue;
            BlockPosition blockposition = entity.dw();
            chunkSource.query(ChunkCoordIntPair.a(blockposition), chunk -> {
                BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(blockposition, (IChunkAccess)chunk).b().a(entity.aq());
                if (biomesettingsmobs_b != null) {
                    spawnercreatureprobabilities.a(entity.dw(), biomesettingsmobs_b.b());
                }
                if (densityCapper != null && entity instanceof EntityInsentient) {
                    densityCapper.a(chunk.f(), enumcreaturetype);
                }
                object2intopenhashmap.addTo((Object)enumcreaturetype, 1);
                if (countMobs) {
                    chunk.r.m().a.updatePlayerMobTypeMap(entity);
                }
            });
        }
        return new d(spawningChunkCount, (Object2IntOpenHashMap<EnumCreatureType>)object2intopenhashmap, spawnercreatureprobabilities, densityCapper);
    }

    static BiomeBase a(BlockPosition pos, IChunkAccess chunk) {
        return chunk.getNoiseBiome(QuartPos.a(pos.u()), QuartPos.a(pos.v()), QuartPos.a(pos.w())).a();
    }

    public static List<EnumCreatureType> getFilteredSpawningCategories(d spawnercreature_d, boolean flag, boolean flag1, boolean flag2, WorldServer worldserver) {
        WorldData worlddata = worldserver.D_();
        ArrayList<EnumCreatureType> list = new ArrayList<EnumCreatureType>(f.length);
        for (EnumCreatureType enumcreaturetype : f) {
            boolean spawnThisTick = true;
            int limit = enumcreaturetype.b();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) != 0L && worlddata.c() % worldserver.ticksPerSpawnCategory.getLong((Object)spawnCategory) == 0L;
                limit = worldserver.getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !flag && enumcreaturetype.d() || !flag1 && !enumcreaturetype.d() || !flag2 && enumcreaturetype.e() || !worldserver.paperConfig().entities.spawning.perPlayerMobSpawns && !spawnercreature_d.canSpawnForCategoryGlobal(enumcreaturetype, limit)) continue;
            list.add(enumcreaturetype);
        }
        return list;
    }

    public static void a(WorldServer world, Chunk chunk, d info, List<EnumCreatureType> spawnableGroups) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("spawner");
        for (EnumCreatureType enumcreaturetype : spawnableGroups) {
            boolean canSpawn;
            int maxSpawns = Integer.MAX_VALUE;
            if (world.paperConfig().entities.spawning.perPlayerMobSpawns) {
                int limit = enumcreaturetype.b();
                SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(enumcreaturetype);
                if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                    limit = world.getWorld().getSpawnLimit(spawnCategory);
                }
                int minDiff = Integer.MAX_VALUE;
                ReferenceList<EntityPlayer> inRange = world.moonrise$getNearbyPlayers().getPlayers(chunk.f(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
                if (inRange != null) {
                    EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
                    int len = inRange.size();
                    for (int k2 = 0; k2 < len; ++k2) {
                        minDiff = Math.min(limit - world.m().a.getMobCountNear(backingSet[k2], enumcreaturetype), minDiff);
                    }
                }
                maxSpawns = minDiff == Integer.MAX_VALUE ? 0 : minDiff;
                canSpawn = maxSpawns > 0;
            } else {
                canSpawn = info.a(enumcreaturetype, chunk.f());
            }
            if (!canSpawn) continue;
            Objects.requireNonNull(info);
            c spawnercreature_c = info::a;
            Objects.requireNonNull(info);
            SpawnerCreature.spawnCategoryForChunk(enumcreaturetype, world, chunk, spawnercreature_c, info::a, maxSpawns, world.paperConfig().entities.spawning.perPlayerMobSpawns ? world.m().a::updatePlayerMobTypeMap : null);
        }
        gameprofilerfiller.c();
    }

    public static int globalLimitForCategory(WorldServer level, EnumCreatureType category, int spawnableChunkCount) {
        int categoryLimit = level.getWorld().getSpawnLimitUnsafe(CraftSpawnCategory.toBukkit(category));
        if (categoryLimit < 1) {
            return categoryLimit;
        }
        return categoryLimit * spawnableChunkCount / e;
    }

    public static void a(EnumCreatureType group, WorldServer world, Chunk chunk, c checker, a runner) {
        SpawnerCreature.spawnCategoryForChunk(group, world, chunk, checker, runner, Integer.MAX_VALUE, null);
    }

    public static void spawnCategoryForChunk(EnumCreatureType group, WorldServer world, Chunk chunk, c checker, a runner, int maxSpawns, Consumer<Entity> trackEntity) {
        BlockPosition blockposition = SpawnerCreature.a((World)world, chunk);
        if (blockposition.v() >= world.L_() + 1) {
            SpawnerCreature.spawnCategoryForPosition(group, world, chunk, blockposition, checker, runner, maxSpawns, trackEntity);
        }
    }

    @VisibleForDebug
    public static void a(EnumCreatureType group, WorldServer world, BlockPosition pos) {
        SpawnerCreature.a(group, world, world.y(pos), pos, (EntityTypes<?> entitytypes, BlockPosition blockposition1, IChunkAccess ichunkaccess) -> true, (EntityInsentient entityinsentient, IChunkAccess ichunkaccess) -> {});
    }

    public static void a(EnumCreatureType group, WorldServer world, IChunkAccess chunk, BlockPosition pos, c checker, a runner) {
        SpawnerCreature.spawnCategoryForPosition(group, world, chunk, pos, checker, runner, Integer.MAX_VALUE, null);
    }

    public static void spawnCategoryForPosition(EnumCreatureType group, WorldServer world, IChunkAccess chunk, BlockPosition pos, c checker, a runner, int maxSpawns, Consumer<Entity> trackEntity) {
        StructureManager structuremanager = world.b();
        ChunkGenerator chunkgenerator = world.m().g();
        int i2 = pos.v();
        IBlockData iblockdata = world.getBlockStateIfLoadedAndInBounds(pos);
        if (iblockdata != null && !iblockdata.d(chunk, pos)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int j2 = 0;
            block0: for (int k2 = 0; k2 < 3; ++k2) {
                int l2 = pos.u();
                int i1 = pos.w();
                boolean flag = true;
                BiomeSettingsMobs.c biomesettingsmobs_c = null;
                GroupDataEntity groupdataentity = null;
                int j1 = MathHelper.f(world.A.i() * 4.0f);
                int k1 = 0;
                for (int l1 = 0; l1 < j1; ++l1) {
                    PreSpawnStatus doSpawning;
                    blockposition_mutableblockposition.d(l2 += world.A.a(6) - world.A.a(6), i2, i1 += world.A.a(6) - world.A.a(6));
                    double d0 = (double)l2 + 0.5;
                    double d1 = (double)i1 + 0.5;
                    EntityHuman entityhuman = world.a(d0, (double)i2, d1, -1.0, false);
                    if (entityhuman == null) continue;
                    double d2 = entityhuman.i(d0, i2, d1);
                    if (!world.isLoadedAndInBounds(blockposition_mutableblockposition) || !SpawnerCreature.a(world, chunk, blockposition_mutableblockposition, d2)) continue;
                    if (biomesettingsmobs_c == null) {
                        Optional<BiomeSettingsMobs.c> optional = SpawnerCreature.a(world, structuremanager, chunkgenerator, group, world.A, (BlockPosition)blockposition_mutableblockposition);
                        if (optional.isEmpty()) continue block0;
                        biomesettingsmobs_c = optional.get();
                        j1 = biomesettingsmobs_c.c + world.A.a(1 + biomesettingsmobs_c.d - biomesettingsmobs_c.c);
                    }
                    if ((doSpawning = SpawnerCreature.isValidSpawnPostitionForType(world, group, structuremanager, chunkgenerator, biomesettingsmobs_c, blockposition_mutableblockposition, d2)) == PreSpawnStatus.ABORT || doSpawning == PreSpawnStatus.CANCELLED) {
                        world.m().a.updateFailurePlayerMobTypeMap(blockposition_mutableblockposition.u() >> 4, blockposition_mutableblockposition.w() >> 4, group);
                    }
                    if (doSpawning == PreSpawnStatus.ABORT) {
                        return;
                    }
                    if (doSpawning != PreSpawnStatus.SUCCESS || !checker.test(biomesettingsmobs_c.b, blockposition_mutableblockposition, chunk)) continue;
                    EntityInsentient entityinsentient = SpawnerCreature.a(world, biomesettingsmobs_c.b);
                    if (entityinsentient == null) {
                        return;
                    }
                    entityinsentient.b(d0, i2, d1, world.A.i() * 360.0f, 0.0f);
                    if (!SpawnerCreature.a(world, entityinsentient, d2)) continue;
                    groupdataentity = entityinsentient.a((WorldAccess)world, world.d_(entityinsentient.dw()), EntitySpawnReason.a, groupdataentity);
                    world.addFreshEntityWithPassengers(entityinsentient, entityinsentient instanceof EntityOcelot && !((Ageable)entityinsentient.getBukkitEntity()).isAdult() ? CreatureSpawnEvent.SpawnReason.OCELOT_BABY : CreatureSpawnEvent.SpawnReason.NATURAL);
                    if (!entityinsentient.dR()) {
                        ++j2;
                        ++k1;
                        runner.run(entityinsentient, chunk);
                        if (trackEntity != null) {
                            trackEntity.accept(entityinsentient);
                        }
                    }
                    if (j2 >= entityinsentient.ad() || j2 >= maxSpawns) {
                        return;
                    }
                    if (entityinsentient.q(k1)) continue block0;
                }
            }
        }
    }

    private static boolean a(WorldServer world, IChunkAccess chunk, BlockPosition.MutableBlockPosition pos, double squaredDistance) {
        return squaredDistance <= 576.0 ? false : (world.Y().a(new Vec3D((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5), 24.0) ? false : Objects.equals(new ChunkCoordIntPair(pos), chunk.f()) || world.g(pos));
    }

    private static PreSpawnStatus isValidSpawnPostitionForType(WorldServer world, EnumCreatureType group, StructureManager structureAccessor, ChunkGenerator chunkGenerator, BiomeSettingsMobs.c spawnEntry, BlockPosition.MutableBlockPosition pos, double squaredDistance) {
        EntityTypes<?> entitytypes = spawnEntry.b;
        PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(MCUtil.toLocation(world, pos), CraftEntityType.minecraftToBukkit(entitytypes), CreatureSpawnEvent.SpawnReason.NATURAL);
        if (!event.callEvent()) {
            if (event.shouldAbortSpawn()) {
                return PreSpawnStatus.ABORT;
            }
            return PreSpawnStatus.CANCELLED;
        }
        return entitytypes.f() == EnumCreatureType.h ? PreSpawnStatus.FAIL : (!entitytypes.e() && squaredDistance > (double)(entitytypes.f().f() * entitytypes.f().f()) ? PreSpawnStatus.FAIL : (entitytypes.c() && SpawnerCreature.a(world, structureAccessor, chunkGenerator, group, spawnEntry, (BlockPosition)pos) ? (!EntityPositionTypes.a(entitytypes, world, pos) ? PreSpawnStatus.FAIL : (!EntityPositionTypes.a(entitytypes, world, EntitySpawnReason.a, pos, world.A) ? PreSpawnStatus.FAIL : (world.b(entitytypes.a((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5)) ? PreSpawnStatus.SUCCESS : PreSpawnStatus.FAIL))) : PreSpawnStatus.FAIL));
    }

    @Nullable
    private static EntityInsentient a(WorldServer world, EntityTypes<?> type) {
        try {
            Object entity = type.a(world, EntitySpawnReason.a);
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                return entityinsentient;
            }
            c.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.f.b(type));
        }
        catch (Exception exception) {
            c.warn("Failed to create mob", (Throwable)exception);
            ServerInternalException.reportInternalException((Throwable)exception);
        }
        return null;
    }

    private static boolean a(WorldServer world, EntityInsentient entity, double squaredDistance) {
        return squaredDistance > (double)(entity.aq().f().f() * entity.aq().f().f()) && entity.h(squaredDistance) ? false : entity.a((GeneratorAccess)world, EntitySpawnReason.a) && entity.a((IWorldReader)world);
    }

    private static Optional<BiomeSettingsMobs.c> a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, RandomSource random, BlockPosition pos) {
        Holder<BiomeBase> holder = world.t(pos);
        return spawnGroup == EnumCreatureType.g && holder.a(BiomeTags.am) && random.i() < 0.98f ? Optional.empty() : SpawnerCreature.a(world, structureAccessor, chunkGenerator, spawnGroup, pos, holder).b(random);
    }

    private static boolean a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, BiomeSettingsMobs.c spawnEntry, BlockPosition pos) {
        return SpawnerCreature.a(world, structureAccessor, chunkGenerator, spawnGroup, pos, (Holder<BiomeBase>)null).e().contains(spawnEntry);
    }

    private static WeightedRandomList<BiomeSettingsMobs.c> a(WorldServer world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EnumCreatureType spawnGroup, BlockPosition pos, @Nullable Holder<BiomeBase> biomeEntry) {
        return SpawnerCreature.a(pos, world, spawnGroup, structureAccessor) ? NetherFortressStructure.d : chunkGenerator.a(biomeEntry != null ? biomeEntry : world.t(pos), structureAccessor, spawnGroup, pos);
    }

    public static boolean a(BlockPosition pos, WorldServer world, EnumCreatureType spawnGroup, StructureManager structureAccessor) {
        if (spawnGroup == EnumCreatureType.a && world.a_(pos.e()).a(Blocks.fB)) {
            Structure structure = structureAccessor.b().e(Registries.aU).c(BuiltinStructures.o);
            return structure == null ? false : structureAccessor.a(pos, structure).b();
        }
        return false;
    }

    private static BlockPosition a(World world, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.d() + world.A.a(16);
        int j2 = chunkcoordintpair.e() + world.A.a(16);
        int k2 = chunk.a(HeightMap.Type.b, i2, j2) + 1;
        int l2 = MathHelper.b(world.A, world.L_(), k2);
        return new BlockPosition(i2, l2, j2);
    }

    public static boolean a(IBlockAccess blockView, BlockPosition pos, IBlockData state, Fluid fluidState, EntityTypes<?> entityType) {
        return state.m(blockView, pos) ? false : (state.p() ? false : (!fluidState.c() ? false : (state.a(TagsBlock.aZ) ? false : !entityType.a(state))));
    }

    public static void a(WorldAccess world, Holder<BiomeBase> biomeEntry, ChunkCoordIntPair chunkPos, RandomSource random) {
        BiomeSettingsMobs biomesettingsmobs = biomeEntry.a().b();
        WeightedRandomList<BiomeSettingsMobs.c> weightedrandomlist = biomesettingsmobs.a(EnumCreatureType.b);
        if (!weightedrandomlist.d()) {
            int i2 = chunkPos.d();
            int j2 = chunkPos.e();
            while (random.i() < biomesettingsmobs.a()) {
                Optional<BiomeSettingsMobs.c> optional = weightedrandomlist.b(random);
                if (optional.isEmpty()) continue;
                BiomeSettingsMobs.c biomesettingsmobs_c = optional.get();
                int k2 = biomesettingsmobs_c.c + random.a(1 + biomesettingsmobs_c.d - biomesettingsmobs_c.c);
                GroupDataEntity groupdataentity = null;
                int l2 = i2 + random.a(16);
                int i1 = j2 + random.a(16);
                int j1 = l2;
                int k1 = i1;
                for (int l1 = 0; l1 < k2; ++l1) {
                    boolean flag = false;
                    for (int i22 = 0; !flag && i22 < 4; ++i22) {
                        BlockPosition blockposition = SpawnerCreature.a((IWorldReader)world, biomesettingsmobs_c.b, l2, i1);
                        if (biomesettingsmobs_c.b.c() && EntityPositionTypes.a(biomesettingsmobs_c.b, world, blockposition)) {
                            EntityInsentient entityinsentient;
                            Object entity;
                            float f2 = biomesettingsmobs_c.b.l();
                            double d0 = MathHelper.a((double)l2, (double)i2 + (double)f2, (double)i2 + 16.0 - (double)f2);
                            double d1 = MathHelper.a((double)i1, (double)j2 + (double)f2, (double)j2 + 16.0 - (double)f2);
                            if (!world.b(biomesettingsmobs_c.b.a(d0, blockposition.v(), d1)) || !EntityPositionTypes.a(biomesettingsmobs_c.b, world, EntitySpawnReason.b, BlockPosition.a(d0, (double)blockposition.v(), d1), world.H_())) continue;
                            try {
                                entity = biomesettingsmobs_c.b.a(world.a(), EntitySpawnReason.a);
                            }
                            catch (Exception exception) {
                                c.warn("Failed to create mob", (Throwable)exception);
                                ServerInternalException.reportInternalException((Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)entity).b(d0, blockposition.v(), d1, random.i() * 360.0f, 0.0f);
                            if (entity instanceof EntityInsentient && (entityinsentient = (EntityInsentient)entity).a(world, EntitySpawnReason.b) && entityinsentient.a(world)) {
                                groupdataentity = entityinsentient.a(world, world.d_(entityinsentient.dw()), EntitySpawnReason.b, groupdataentity);
                                world.addFreshEntityWithPassengers(entityinsentient, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
                                flag = true;
                            }
                        }
                        l2 += random.a(5) - random.a(5);
                        i1 += random.a(5) - random.a(5);
                        while (l2 < i2 || l2 >= i2 + 16 || i1 < j2 || i1 >= j2 + 16) {
                            l2 = j1 + random.a(5) - random.a(5);
                            i1 = k1 + random.a(5) - random.a(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPosition a(IWorldReader world, EntityTypes<?> entityType, int x2, int z2) {
        int k2 = world.a(EntityPositionTypes.b(entityType), x2, z2);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, k2, z2);
        if (world.G_().h()) {
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (!world.a_(blockposition_mutableblockposition).l());
            do {
                blockposition_mutableblockposition.c(EnumDirection.a);
            } while (world.a_(blockposition_mutableblockposition).l() && blockposition_mutableblockposition.v() > world.L_());
        }
        return EntityPositionTypes.a(entityType).a(world, blockposition_mutableblockposition.j());
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int a;
        private final Object2IntOpenHashMap<EnumCreatureType> b;
        private final SpawnerCreatureProbabilities c;
        private final Object2IntMap<EnumCreatureType> d;
        private final LocalMobCapCalculator e;
        @Nullable
        private BlockPosition f;
        @Nullable
        private EntityTypes<?> g;
        private double h;

        d(int spawningChunkCount, Object2IntOpenHashMap<EnumCreatureType> groupToCount, SpawnerCreatureProbabilities densityField, LocalMobCapCalculator densityCapper) {
            this.a = spawningChunkCount;
            this.b = groupToCount;
            this.c = densityField;
            this.e = densityCapper;
            this.d = Object2IntMaps.unmodifiable(groupToCount);
        }

        private boolean a(EntityTypes<?> type, BlockPosition pos, IChunkAccess chunk) {
            double d0;
            this.f = pos;
            this.g = type;
            BiomeSettingsMobs.b biomesettingsmobs_b = SpawnerCreature.a(pos, chunk).b().a(type);
            if (biomesettingsmobs_b == null) {
                this.h = 0.0;
                return true;
            }
            this.h = d0 = biomesettingsmobs_b.b();
            double d1 = this.c.b(pos, d0);
            return d1 <= biomesettingsmobs_b.a();
        }

        private void a(EntityInsentient entity, IChunkAccess chunk) {
            BiomeSettingsMobs.b biomesettingsmobs_b;
            EntityTypes<?> entitytypes = entity.aq();
            BlockPosition blockposition = entity.dw();
            double d0 = blockposition.equals(this.f) && entitytypes == this.g ? this.h : ((biomesettingsmobs_b = SpawnerCreature.a(blockposition, chunk).b().a(entitytypes)) != null ? biomesettingsmobs_b.b() : 0.0);
            this.c.a(blockposition, d0);
            EnumCreatureType enumcreaturetype = entitytypes.f();
            this.b.addTo((Object)enumcreaturetype, 1);
            if (this.e != null) {
                this.e.a(new ChunkCoordIntPair(blockposition), enumcreaturetype);
            }
        }

        public int a() {
            return this.a;
        }

        public Object2IntMap<EnumCreatureType> b() {
            return this.d;
        }

        boolean canSpawnForCategoryGlobal(EnumCreatureType enumcreaturetype, int limit) {
            int i2 = limit * this.a / e;
            return this.b.getInt((Object)enumcreaturetype) < i2;
        }

        boolean a(EnumCreatureType group, ChunkCoordIntPair chunkPos) {
            return this.e.a(group, chunkPos);
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }

    private static enum PreSpawnStatus {
        FAIL,
        SUCCESS,
        CANCELLED,
        ABORT;

    }
}

