/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.AbstractIterator;
import io.papermc.paper.util.MCUtil;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class VoxelShapeSpliterator<T>
extends AbstractIterator<T> {
    private final AxisAlignedBB a;
    private final VoxelShapeCollision b;
    private final CursorPosition c;
    private final BlockPosition.MutableBlockPosition d;
    private final VoxelShape e;
    private final ICollisionAccess f;
    private final boolean g;
    @Nullable
    private IBlockAccess h;
    private long i;
    private final BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> j;

    public VoxelShapeSpliterator(ICollisionAccess world, @Nullable Entity entity, AxisAlignedBB box, boolean forEntity, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultFunction) {
        this(world, entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity), box, forEntity, resultFunction);
    }

    public VoxelShapeSpliterator(ICollisionAccess world, VoxelShapeCollision context, AxisAlignedBB box, boolean forEntity, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultFunction) {
        this.b = context;
        this.d = new BlockPosition.MutableBlockPosition();
        this.e = VoxelShapes.a(box);
        this.f = world;
        this.a = box;
        this.g = forEntity;
        this.j = resultFunction;
        int i2 = MathHelper.a(box.a - 1.0E-7) - 1;
        int j2 = MathHelper.a(box.d + 1.0E-7) + 1;
        int k2 = MathHelper.a(box.b - 1.0E-7) - 1;
        int l2 = MathHelper.a(box.e + 1.0E-7) + 1;
        int m2 = MathHelper.a(box.c - 1.0E-7) - 1;
        int n2 = MathHelper.a(box.f + 1.0E-7) + 1;
        this.c = new CursorPosition(i2, k2, m2, j2, l2, n2);
    }

    @Nullable
    private IBlockAccess a(int x2, int z2) {
        IBlockAccess blockGetter;
        int i2 = SectionPosition.a(x2);
        int j2 = SectionPosition.a(z2);
        long l2 = ChunkCoordIntPair.c(i2, j2);
        if (this.h != null && this.i == l2) {
            return this.h;
        }
        this.h = blockGetter = this.f.c(i2, j2);
        this.i = l2;
        return blockGetter;
    }

    protected T computeNext() {
        while (this.c.a()) {
            IBlockData blockState;
            Entity entity;
            int k2;
            int j2;
            int i2;
            int x2 = i2 = this.c.b();
            int y2 = j2 = this.c.c();
            int z2 = k2 = this.c.d();
            int l2 = this.c.e();
            if (l2 == 3) continue;
            VoxelShapeCollision voxelShapeCollision = this.b;
            if (voxelShapeCollision instanceof VoxelShapeCollisionEntity) {
                VoxelShapeCollisionEntity entityContext = (VoxelShapeCollisionEntity)voxelShapeCollision;
                entity = entityContext.c();
            } else {
                entity = null;
            }
            Entity source = entity;
            boolean far = source != null && MCUtil.distanceSq(source.dB(), y2, source.dH(), x2, y2, z2) > 14.0;
            this.d.d(x2, y2, z2);
            if (this.f instanceof RegionLimitedWorldAccess) {
                IBlockAccess blockGetter = this.a(x2, z2);
                if (blockGetter == null) continue;
                blockState = blockGetter.a_(this.d);
            } else {
                blockState = !far && source instanceof EntityPlayer || source != null && source.collisionLoadChunks ? this.f.a_(this.d) : this.f.getBlockStateIfLoaded(this.d);
            }
            if (blockState == null) {
                if (source instanceof EntityPlayer && !source.dW().paperConfig().chunks.preventMovingIntoUnloadedChunks) continue;
                return this.j.apply(new BlockPosition.MutableBlockPosition(x2, y2, z2), VoxelShapes.a(far ? source.cR() : new AxisAlignedBB(new BlockPosition(x2, y2, z2))));
            }
            if (l2 == 1 && !blockState.i() || l2 == 2 && !blockState.a(Blocks.bX)) continue;
            VoxelShape voxelShape = this.b.a(blockState, this.f, this.d);
            if (voxelShape == VoxelShapes.b()) {
                if (!this.a.a(i2, j2, k2, (double)i2 + 1.0, (double)j2 + 1.0, (double)k2 + 1.0)) continue;
                return this.j.apply(this.d, voxelShape.a(i2, (double)j2, (double)k2));
            }
            VoxelShape voxelShape2 = voxelShape.a(i2, (double)j2, (double)k2);
            if (voxelShape2.c() || !VoxelShapes.c(voxelShape2, this.e, OperatorBoolean.i)) continue;
            return this.j.apply(this.d, voxelShape2);
        }
        return (T)this.endOfData();
    }
}

