/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.destroystokyo.paper.antixray.ChunkPacketBlockControllerAntiXray;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.WorldConfiguration;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable,
ChunkSystemLevel,
ChunkSystemEntityGetter {
    public static final Codec<ResourceKey<World>> h = ResourceKey.a(Registries.be);
    public static final ResourceKey<World> i = ResourceKey.a(Registries.be, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.be, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> k = ResourceKey.a(Registries.be, MinecraftKey.b("the_end"));
    public static final int l = 30000000;
    public static final int m = 512;
    public static final int n = 32;
    public static final int o = 15;
    public static final int p = 24000;
    public static final int q = 20000000;
    public static final int r = -20000000;
    public final List<TickingBlockEntity> s = Lists.newArrayList();
    protected final NeighborUpdater t;
    private final List<TickingBlockEntity> a = Lists.newArrayList();
    private boolean b;
    public final Thread c;
    private final boolean d;
    private int e;
    protected int u = RandomSource.a().f();
    protected final int v = 1013904223;
    protected float w;
    public float x;
    protected float y;
    public float z;
    public final RandomSource A = new ThreadUnsafeRandom(RandomSupport.a());
    @Deprecated
    private final RandomSource f = RandomSource.b();
    private final Holder<DimensionManager> E;
    public final WorldDataMutable B;
    public final boolean C;
    private final WorldBorder F;
    private final BiomeManager G;
    private final ResourceKey<World> H;
    private final IRegistryCustom I;
    private final DamageSources J;
    private long K;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public boolean isBlockPlaceCancelled = false;
    public Map<BlockPosition, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CraftBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new LinkedHashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    private final WorldConfiguration paperConfig;
    public final ChunkPacketBlockController chunkPacketBlockController;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;
    public final Map<ServerExplosion.CacheKey, Float> explosionDensityCache = new HashMap<ServerExplosion.CacheKey, Float>();
    public ArrayDeque<BlockRedstoneTorch.RedstoneUpdateInfo> redstoneUpdateInfos;
    private EntityLookup entityLookup;
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();
    private static final Fluid AIR_FLUIDSTATE;
    private final int minY;
    private final int height;
    private final int maxY;
    private final int minSectionY;
    private final int maxSectionY;
    private final int sectionsCount;

    public WorldConfiguration paperConfig() {
        return this.paperConfig;
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    private int getTicksPerSpawn(SpawnCategory spawnCategory) {
        int perWorld = this.paperConfig().entities.spawning.ticksPerSpawn.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory));
        if (perWorld >= 0) {
            return perWorld;
        }
        return this.getCraftServer().getTicksPerSpawns(spawnCategory);
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public final void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Override
    public final <T extends net.minecraft.world.entity.Entity> List<T> a(Class<T> entityClass, AxisAlignedBB boundingBox, Predicate<? super T> predicate) {
        Profiler.a().f("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        return ret;
    }

    @Override
    public final List<net.minecraft.world.entity.Entity> moonrise$getHardCollidingEntities(net.minecraft.world.entity.Entity entity, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (Chunk)this.R().a(chunkX, chunkZ, ChunkStatus.n, false);
    }

    @Override
    public IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.R().a(chunkX, chunkZ, ChunkStatus.c, false);
    }

    @Override
    public IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        return this.R().a(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        IChunkProvider chunkSource = this.R();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean b(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    @Override
    public IChunkAccess a(int x2, int z2, ChunkStatus status) {
        return this.a(x2, z2, status, true);
    }

    @Override
    public BlockPosition a(HeightMap.Type types, BlockPosition blockPos) {
        return new BlockPosition(blockPos.u(), this.a(types, blockPos.u(), blockPos.w()), blockPos.w());
    }

    @Override
    public boolean f(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB boundingBox = entity.cR();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a(entity, boundingBox.c(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity otherEntity = entities.get(i2);
            if (otherEntity.aa_() || otherEntity.dR() || !otherEntity.I || otherEntity.z(entity)) continue;
            return false;
        }
        return true;
    }

    private static MovingObjectPositionBlock miss(RayTrace clipContext) {
        Vec3D to = clipContext.a();
        Vec3D from = clipContext.b();
        return MovingObjectPositionBlock.a(to, EnumDirection.a(from.d - to.d, from.e - to.e, from.f - to.f), BlockPosition.a(to.d, to.e, to.f));
    }

    private static MovingObjectPositionBlock fastClip(Vec3D from, Vec3D to, World level, RayTrace clipContext) {
        double adjX = 1.0E-7 * (from.d - to.d);
        double adjY = 1.0E-7 * (from.e - to.e);
        double adjZ = 1.0E-7 * (from.f - to.f);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return World.miss(clipContext);
        }
        double toXAdj = to.d - adjX;
        double toYAdj = to.e - adjY;
        double toZAdj = to.f - adjZ;
        double fromXAdj = from.d + adjX;
        double fromYAdj = from.e + adjY;
        double fromZAdj = from.f + adjZ;
        int currX = MathHelper.a(fromXAdj);
        int currY = MathHelper.a(fromYAdj);
        int currZ = MathHelper.a(fromZAdj);
        BlockPosition.MutableBlockPosition currPos = new BlockPosition.MutableBlockPosition();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.e(fromXAdj) : MathHelper.e(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.e(fromYAdj) : MathHelper.e(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.e(fromZAdj) : MathHelper.e(fromZAdj));
        ChunkSection[] lastChunk = null;
        DataPaletteBlock<IBlockData> lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.d(newChunkX, newChunkZ).d();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].h : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = lastSection.a(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).l()) {
                VoxelShape fluidCollision;
                MovingObjectPositionBlock fluidHit;
                Fluid fluidState;
                MovingObjectPositionBlock blockHit;
                VoxelShape blockCollision = clipContext.a(blockState, (IBlockAccess)level, (BlockPosition)currPos);
                MovingObjectPositionBlock movingObjectPositionBlock = blockHit = blockCollision.c() ? null : level.a(from, to, currPos, blockCollision, blockState);
                if (clipContext.d != RayTrace.FluidCollisionOption.a && (fluidState = blockState.y()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.a(fluidState, (IBlockAccess)level, (BlockPosition)currPos)).a(from, to, currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.g(blockHit.g()) <= from.g(fluidHit.g()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return World.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Override
    public MovingObjectPositionBlock a(RayTrace clipContext) {
        return World.fastClip(clipContext.b(), clipContext.a(), this, clipContext);
    }

    @Override
    public boolean g(net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, 8, (state, pos) -> state.j(this, (BlockPosition)pos));
    }

    private static VoxelShape inflateAABBToVoxel(AxisAlignedBB aabb, double x2, double y2, double z2) {
        return VoxelShapes.b(aabb.a - x2, aabb.b - y2, aabb.c - z2, aabb.d + x2, aabb.e + y2, aabb.f + z2);
    }

    @Override
    public Optional<Vec3D> a(net.minecraft.world.entity.Entity entity, VoxelShape boundsShape, Vec3D fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.c()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AxisAlignedBB collectionVolume = boundsShape.a().c(expandByX, expandByY, expandByZ);
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, collectionVolume, voxels, aabbs, 4, null);
        WorldBorder worldBorder = this.F_();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.a((AxisAlignedBB)aabb));
            voxels.removeIf(shape -> !worldBorder.a(shape.a()));
        }
        int len = voxels.size();
        for (int i2 = 0; i2 < len; ++i2) {
            aabbs.addAll(((VoxelShape)voxels.get(i2)).e());
        }
        VoxelShape first = aabbs.isEmpty() ? VoxelShapes.a() : World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i3 = 1; i3 < len2; ++i3) {
            rest[i3 - 1] = World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(i3), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = VoxelShapes.a(first, rest);
        VoxelShape freeSpace = VoxelShapes.b(boundsShape, joined, OperatorBoolean.e);
        return freeSpace.b(fromPosition);
    }

    @Override
    public Optional<BlockPosition> h(net.minecraft.world.entity.Entity entity, AxisAlignedBB aabb) {
        int minSection = WorldUtil.getMinSection(this);
        int minBlockX = MathHelper.a(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.a(aabb.d + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, MathHelper.a(aabb.b - 1.0E-7) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(this) << 4) + 16, MathHelper.a(aabb.e + 1.0E-7) + 1);
        int minBlockZ = MathHelper.a(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.a(aabb.f + 1.0E-7) + 1;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        BaseBlockPosition selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3D entityPos = entity.du();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = this.R();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                IChunkAccess chunk = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false);
                if (chunk == null) continue;
                ChunkSection[] sections = chunk.d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    boolean hasSpecial = section.moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                IBlockData blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                int n2 = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.b(entityPos)) > selectedDistance || distance == selectedDistance && selected.i(mutablePos) >= 0 || (blockData = blocks.a(localBlockIndex)).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = blockData.moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.i() || edgeCount == 2 && blockData.b() != Blocks.bX) || blockCollision == null && (blockCollision = blockData.b((IBlockAccess)this, (BlockPosition)mutablePos, collisionShape)).c()) continue;
                                AxisAlignedBB shiftedAABB = aabb.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = blockCollision.moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.j();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.j();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }

    @Override
    public int L_() {
        return this.minY;
    }

    @Override
    public int M_() {
        return this.height;
    }

    @Override
    public int am() {
        return this.maxY;
    }

    @Override
    public int an() {
        return this.sectionsCount;
    }

    @Override
    public int ao() {
        return this.minSectionY;
    }

    @Override
    public int ap() {
        return this.maxSectionY;
    }

    @Override
    public boolean d(int blockY) {
        return blockY >= this.minY && blockY <= this.maxY;
    }

    @Override
    public boolean s(BlockPosition pos) {
        return this.e(pos.v());
    }

    @Override
    public boolean e(int blockY) {
        return blockY < this.minY || blockY > this.maxY;
    }

    @Override
    public int f(int blockY) {
        return (blockY >> 4) - this.minSectionY;
    }

    @Override
    public int g(int sectionY) {
        return sectionY - this.minSectionY;
    }

    @Override
    public int h(int sectionIdx) {
        return sectionIdx + this.minSectionY;
    }

    @Override
    public abstract Holder<BiomeBase> a(int var1, int var2, int var3);

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        IChunkAccess chunk = this.a(x2 >> 2, z2 >> 2, ChunkStatus.f, false);
        return chunk != null ? chunk.getNoiseBiome(x2, y2, z2) : this.a(x2, y2, z2);
    }

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env, Function<SpigotWorldConfig, WorldConfiguration> paperWorldConfigCreator, Executor executor) {
        DimensionManager dimType = holder.a();
        this.minY = dimType.n();
        this.height = dimType.o();
        this.maxY = this.minY + this.height - 1;
        this.minSectionY = this.minY >> 4;
        this.maxSectionY = this.maxY >> 4;
        this.sectionsCount = this.maxSectionY - this.minSectionY + 1;
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).e());
        this.paperConfig = paperWorldConfigCreator.apply(this.spigotConfig);
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getTicksPerSpawn(spawnCategory));
        }
        this.B = worlddatamutable;
        this.E = holder;
        DimensionManager dimensionmanager = holder.a();
        this.H = resourcekey;
        this.C = flag;
        this.F = dimensionmanager.k() != 1.0 ? new WorldBorder(this){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.c = Thread.currentThread();
        this.G = new BiomeManager(this, i2);
        this.d = flag1;
        this.t = new CollectingNeighborUpdater(this, j2);
        this.I = iregistrycustom;
        this.J = new DamageSources(iregistrycustom);
        this.F_().world = (WorldServer)this;
        this.F_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
        this.chunkPacketBlockController = this.paperConfig().anticheat.antiXray.enabled ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
        this.entityLookup = new DefaultEntityLookup(this);
    }

    public final boolean checkEntityCollision(IBlockData data, net.minecraft.world.entity.Entity source, VoxelShapeCollision voxelshapedcollision, BlockPosition position, boolean checkCanSee) {
        VoxelShape voxelshape = data.b((IBlockAccess)this, position, voxelshapedcollision);
        if (voxelshape.c()) {
            return true;
        }
        if ((voxelshape = voxelshape.a(position.u(), (double)position.v(), (double)position.w())).c()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a_(null, voxelshape.a());
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = entities.get(i2);
            if (checkCanSee && source instanceof EntityPlayer && entity instanceof EntityPlayer && !((EntityPlayer)source).getBukkitEntity().canSee(((EntityPlayer)entity).getBukkitEntity()) || entity.dR() || !entity.I || !VoxelShapes.c(voxelshape, VoxelShapes.a(entity.cR()), OperatorBoolean.i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean B_() {
        return this.C;
    }

    @Override
    @Nullable
    public MinecraftServer p() {
        return null;
    }

    public MovingObjectPosition.EnumMovingObjectType clipDirect(Vec3D start, Vec3D end, VoxelShapeCollision context) {
        return this.a(new RayTrace(start, end, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, context)).d();
    }

    public boolean k(BlockPosition pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public static boolean l(BlockPosition pos) {
        return !World.b(pos.v()) && World.g(pos);
    }

    private static boolean g(BlockPosition pos) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000;
    }

    private static boolean b(int y2) {
        return y2 < -20000000 || y2 >= 20000000;
    }

    public final Chunk m(BlockPosition pos) {
        return this.d(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public final Chunk d(int chunkX, int chunkZ) {
        ChunkProviderServer cps = ((WorldServer)this).m();
        Chunk ifLoaded = cps.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        return (Chunk)cps.a(chunkX, chunkZ, ChunkStatus.n, true);
    }

    @Override
    @Nullable
    public final IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return ((WorldServer)this).J.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    @Nullable
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.s(pos)) {
            return Blocks.nw.m();
        }
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.a_(pos);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public final boolean B(BlockPosition pos) {
        return this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPosition blockposition) {
        return this.F_().a(blockposition) && this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) != null;
    }

    @Nullable
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return ((WorldServer)this).m().getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Nullable
    public final Chunk getChunkIfLoaded(BlockPosition blockposition) {
        return ((WorldServer)this).m().getChunkAtIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
    }

    @Nullable
    public final IBlockData getBlockStateIfLoadedAndInBounds(BlockPosition blockposition) {
        return this.F_().a(blockposition) ? this.getBlockStateIfLoaded(blockposition) : null;
    }

    @Override
    public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ichunkaccess = this.R().a(chunkX, chunkZ, leastStatus, create);
        if (ichunkaccess == null && create) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags) {
        return this.a(pos, state, flags, 512);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int maxUpdateDepth) {
        if (this.captureTreeGeneration) {
            IBlockData type = this.a_(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.j(), blockstate);
            }
            blockstate.setData(state);
            blockstate.setFlag(flags);
            return true;
        }
        if (this.s(pos)) {
            return false;
        }
        if (!this.C && this.ai()) {
            return false;
        }
        Chunk chunk = this.m(pos);
        Block block = state.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(pos)) {
            CraftBlockState blockstate = (CraftBlockState)this.world.getBlockAt(pos.u(), pos.v(), pos.w()).getState();
            blockstate.setFlag(flags);
            this.capturedBlockStates.put(pos.j(), blockstate);
            captured = true;
        }
        IBlockData iblockdata1 = chunk.setBlockState(pos, state, (flags & 0x40) != 0, (flags & 0x400) == 0);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, iblockdata1, flags, maxUpdateDepth);
        if (iblockdata1 == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(pos);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunk, iblockdata1, state, iblockdata2, flags, maxUpdateDepth);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(pos);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.C || (i2 & 4) == 0) && (this.C || chunk == null || chunk.F() != null && chunk.F().a(FullChunkStatus.b))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.b(blockposition, iblockdata1.b());
                if (!this.C && iblockdata.q()) {
                    this.c(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                boolean cancelledUpdates = false;
                if (world != null && ((WorldServer)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    cancelledUpdates = event.isCancelled();
                }
                if (!cancelledUpdates) {
                    iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                    iblockdata.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                }
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
    }

    @Override
    public boolean a(BlockPosition pos, boolean move) {
        Fluid fluid = this.b_(pos);
        return this.a(pos, fluid.g(), 3 | (move ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition pos, boolean drop, @Nullable net.minecraft.world.entity.Entity breakingEntity, int maxUpdateDepth) {
        boolean flag1;
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.l()) {
            return false;
        }
        Fluid fluid = this.b_(pos);
        boolean playEffect = true;
        IBlockData effectType = iblockdata;
        int xp = iblockdata.b().getExpDrop(iblockdata, (WorldServer)this, pos, ItemStack.j, true);
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)fluid.g().createCraftBlockData(), (BlockData)effectType.createCraftBlockData(), xp, drop);
            if (!event.callEvent()) {
                return false;
            }
            effectType = ((CraftBlockData)event.getEffectBlock()).getState();
            playEffect = event.playEffect();
            drop = event.willDrop();
            xp = event.getExpToDrop();
        }
        if (playEffect && !(effectType.b() instanceof BlockFireAbstract)) {
            this.c(2001, pos, Block.j(effectType));
        }
        if (drop) {
            TileEntity tileentity = iblockdata.x() ? this.c_(pos) : null;
            Block.dropResources(iblockdata, this, pos, tileentity, breakingEntity, ItemStack.j, false);
            iblockdata.b().popExperience((WorldServer)this, pos, xp, breakingEntity);
        }
        if (flag1 = this.a(pos, fluid.g(), 3, maxUpdateDepth)) {
            this.a(GameEvent.f, pos, GameEvent.a.a(breakingEntity, iblockdata));
        }
        return flag1;
    }

    public void a(BlockPosition pos, IBlockData state) {
    }

    public boolean b(BlockPosition pos, IBlockData state) {
        return this.a(pos, state, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition pos, IBlockData old, IBlockData updated) {
    }

    public void a(BlockPosition pos, Block block) {
    }

    public void a(BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation) {
    }

    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction, @Nullable Orientation orientation) {
    }

    public void b(BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation) {
    }

    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify) {
    }

    @Override
    public void a(EnumDirection direction, BlockPosition pos, BlockPosition neighborPos, IBlockData neighborState, int flags, int maxUpdateDepth) {
        this.t.a(direction, neighborState, pos, neighborPos, flags, maxUpdateDepth);
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        int k2 = x2 >= -30000000 && z2 >= -30000000 && x2 < 30000000 && z2 < 30000000 ? (this.b(SectionPosition.a(x2), SectionPosition.a(z2)) ? this.d(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmap, x2 & 0xF, z2 & 0xF) + 1 : this.L_()) : this.O() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine C_() {
        return this.R().p();
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.s(pos)) {
            return Blocks.nw.m();
        }
        IChunkAccess chunk = this.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.n, true);
        return chunk.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.s(pos)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.m(pos);
        return chunk.b_(pos);
    }

    public boolean U() {
        return !this.G_().a() && this.e < 4;
    }

    public boolean V() {
        return !this.G_().a() && !this.U();
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        EntityHuman entityhuman1;
        EntityHuman entityhuman = source instanceof EntityHuman ? (entityhuman1 = (EntityHuman)source) : null;
        this.a(entityhuman, pos, sound, category, volume, pitch);
    }

    @Override
    public void a(@Nullable EntityHuman source, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch);
    }

    public abstract void a(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch, long seed) {
        this.a(source, x2, y2, z2, BuiltInRegistries.b.e(sound), category, volume, pitch, seed);
    }

    public abstract void a(@Nullable EntityHuman var1, net.minecraft.world.entity.Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category) {
        this.a(source, x2, y2, z2, sound, category, 1.0f, 1.0f);
    }

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, x2, y2, z2, sound, category, volume, pitch, this.f.g());
    }

    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch) {
        this.a(source, x2, y2, z2, sound, category, volume, pitch, this.f.g());
    }

    public void a(@Nullable EntityHuman source, net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(source, entity, BuiltInRegistries.b.e(sound), category, volume, pitch, this.f.g());
    }

    public void a(BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch, boolean useDistance) {
        this.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch, useDistance);
    }

    public void a(net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    public void a(double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch, boolean useDistance) {
    }

    @Override
    public void a(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void a(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public float a(float tickDelta) {
        float f1 = this.f(tickDelta);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity ticker) {
        (this.b ? this.a : this.s).add(ticker);
    }

    protected void W() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("blockEntities");
        this.b = true;
        if (!this.a.isEmpty()) {
            this.s.addAll(this.a);
            this.a.clear();
        }
        boolean flag = this.t().i();
        int tickedEntities = 0;
        int tilesThisCycle = 0;
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.s.size()) {
            this.tileTickPosition = this.tileTickPosition < this.s.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.s.get(this.tileTickPosition);
            if (tickingblockentity.b()) {
                --tilesThisCycle;
                toRemove.add((Object)tickingblockentity);
            } else if (flag && this.n(tickingblockentity.c())) {
                tickingblockentity.a();
                if ((++tickedEntities & 7) == 0) {
                    this.moonrise$midTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.s.removeAll((Collection<?>)toRemove);
        this.b = false;
        gameprofilerfiller.c();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(Consumer<T> tickConsumer, T entity) {
        try {
            tickConsumer.accept(entity);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw throwable;
            }
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.dW().getWorld().getName(), entity.dB(), entity.dD(), entity.dH());
            MinecraftServer.l.error(msg, throwable);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
            entity.discard(EntityRemoveEvent.Cause.DISCARD);
        }
        this.moonrise$midTickTasks();
    }

    @Override
    public boolean a(@Nullable net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        int flags;
        if (entity instanceof EntityArmorStand && !entity.dW().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return false;
        }
        int n2 = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    public boolean h(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean a(long chunkPos) {
        return true;
    }

    public boolean n(BlockPosition pos) {
        return this.a(ChunkCoordIntPair.a(pos));
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, a explosionSourceType) {
        this.a(entity, Explosion.a(this, entity), null, x2, y2, z2, power, false, explosionSourceType, Particles.w, Particles.v, SoundEffects.ky);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType) {
        this.a(entity, Explosion.a(this, entity), null, x2, y2, z2, power, createFire, explosionSourceType, Particles.w, Particles.v, SoundEffects.ky);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, Vec3D pos, float power, boolean createFire, a explosionSourceType) {
        this.a(entity, damageSource, behavior, pos.a(), pos.b(), pos.c(), power, createFire, explosionSourceType, Particles.w, Particles.v, SoundEffects.ky);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, a explosionSourceType) {
        this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, Particles.w, Particles.v, SoundEffects.ky);
    }

    public abstract void a(@Nullable net.minecraft.world.entity.Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, Holder<SoundEffect> var15);

    public abstract String I();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.getBlockEntity(pos, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        TileEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(blockposition)) != null) {
            return blockEntity;
        }
        return this.s(blockposition) ? null : (!this.C && !TickThread.isTickThread() ? null : this.m(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity blockEntity) {
        BlockPosition blockposition = blockEntity.aB_();
        if (!this.s(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.j(), blockEntity);
                return;
            }
            this.m(blockposition).b(blockEntity);
        }
    }

    public void o(BlockPosition pos) {
        if (!this.s(pos)) {
            this.m(pos).d(pos);
        }
    }

    public boolean p(BlockPosition pos) {
        return this.s(pos) ? false : this.R().b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity, EnumDirection direction) {
        if (this.s(pos)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(pos).a((IBlockAccess)this, pos, entity, direction);
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return this.a(pos, entity, EnumDirection.b);
    }

    public void X() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.e = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void a(boolean spawnMonsters) {
        this.R().b(spawnMonsters);
    }

    public BlockPosition Y() {
        BlockPosition blockposition = this.B.a();
        if (!this.F_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, BlockPosition.a(this.F_().a(), 0.0, this.F_().b()));
        }
        return blockposition;
    }

    public float Z() {
        return this.B.b();
    }

    protected void aa() {
        if (this.B.i()) {
            this.x = 1.0f;
            if (this.B.g()) {
                this.z = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.R().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.n, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> a(@Nullable net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList list = Lists.newArrayList();
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getEntities(except, box, ret, predicate);
        PlatformHooks.get().addToGetEntities(this, except, box, predicate, ret);
        return ret;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, box, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, box, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AxisAlignedBB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        Profiler.a().f("getEntities");
        if (entityTypeTest instanceof EntityTypes) {
            EntityTypes byType = (EntityTypes)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class<net.minecraft.world.entity.Entity> base = entityTypeTest.a();
        Predicate<net.minecraft.world.entity.Entity> modifiedPredicate = predicate == null ? obj -> entityTypeTest.a((net.minecraft.world.entity.Entity)obj) != null : obj -> {
            net.minecraft.world.entity.Entity casted = (net.minecraft.world.entity.Entity)entityTypeTest.a((net.minecraft.world.entity.Entity)obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == net.minecraft.world.entity.Entity.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = ((WorldServer)this).moonrise$getEntityLookup().getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity entity : slices.getAllEntities()) {
            CraftEntity bukkit = entity.getBukkitEntity();
            if (bukkit == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(new Entity[0]);
    }

    @Nullable
    public abstract net.minecraft.world.entity.Entity a(int var1);

    public void q(BlockPosition pos) {
        if (this.B(pos)) {
            this.m(pos).i();
        }
    }

    public void ab() {
    }

    public long ac() {
        return this.B.c();
    }

    public long ad() {
        return this.B.d();
    }

    public boolean a(EntityHuman player, BlockPosition pos) {
        return true;
    }

    public void a(net.minecraft.world.entity.Entity entity, byte status) {
    }

    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
    }

    public void a(BlockPosition pos, Block block, int type, int data) {
        this.a_(pos).a(this, pos, type, data);
    }

    @Override
    public WorldData D_() {
        return this.B;
    }

    public abstract TickRateManager t();

    public float b(float delta) {
        return MathHelper.h(delta, this.y, this.z) * this.d(delta);
    }

    public void c(float thunderGradient) {
        float f1;
        this.y = f1 = MathHelper.a(thunderGradient, 0.0f, 1.0f);
        this.z = f1;
    }

    public float d(float delta) {
        return MathHelper.h(delta, this.w, this.x);
    }

    public void e(float rainGradient) {
        float f1;
        this.w = f1 = MathHelper.a(rainGradient, 0.0f, 1.0f);
        this.x = f1;
    }

    private boolean a() {
        return this.G_().g() && !this.G_().h();
    }

    public boolean ae() {
        return this.a() && (double)this.b(1.0f) > 0.9;
    }

    public boolean af() {
        return this.a() && (double)this.d(1.0f) > 0.2;
    }

    public boolean r(BlockPosition pos) {
        if (!this.af()) {
            return false;
        }
        if (!this.h(pos)) {
            return false;
        }
        if (this.a(HeightMap.Type.e, pos).v() > pos.v()) {
            return false;
        }
        BiomeBase biomebase = this.t(pos).a();
        return biomebase.a(pos, this.O()) == BiomeBase.Precipitation.b;
    }

    @Nullable
    public abstract WorldMap a(MapId var1);

    public abstract void a(MapId var1, WorldMap var2);

    public abstract MapId w();

    public void b(int eventId, BlockPosition pos, int data) {
    }

    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = report.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            int i2 = this.y().size();
            return i2 + " total; " + String.valueOf(this.y());
        });
        IChunkProvider ichunkprovider = this.R();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.ah().a().toString());
        try {
            this.B.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ, List<FireworkExplosion> explosions) {
    }

    public abstract Scoreboard Q();

    public void c(BlockPosition pos, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (!this.B(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.ho)) {
                this.a(iblockdata, blockposition1, block, (Orientation)null, false);
                continue;
            }
            if (!iblockdata.d(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.ho)) continue;
            this.a(iblockdata, blockposition1, block, (Orientation)null, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.B(pos)) {
            f2 = this.aq();
            i2 = this.m(pos).w();
        }
        return new DifficultyDamageScaler(this.al(), this.ad(), i2, f2);
    }

    @Override
    public int E_() {
        return this.e;
    }

    public void c(int lightningTicksLeft) {
    }

    @Override
    public WorldBorder F_() {
        return this.F;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager G_() {
        return this.E.a();
    }

    public Holder<DimensionManager> ag() {
        return this.E;
    }

    public ResourceKey<World> ah() {
        return this.H;
    }

    @Override
    public RandomSource H_() {
        return this.A;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    public abstract RecipeAccess P();

    public BlockPosition a(int x2, int y2, int z2, int l2) {
        this.u = this.u * 3 + 1013904223;
        int i1 = this.u >> 2;
        return new BlockPosition(x2 + (i1 & 0xF), y2 + (i1 >> 16 & l2), z2 + (i1 >> 8 & 0xF));
    }

    public boolean u() {
        return false;
    }

    @Override
    public BiomeManager I_() {
        return this.G;
    }

    public final boolean ai() {
        return this.d;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> G();

    @Override
    public long J_() {
        return this.K++;
    }

    @Override
    public IRegistryCustom K_() {
        return this.I;
    }

    public DamageSources aj() {
        return this.J;
    }

    public abstract PotionBrewer K();

    public abstract FuelValues L();

    public WireHandler getWireHandler() {
        return null;
    }

    static {
        AIR_FLUIDSTATE = FluidTypes.a.g();
    }

    public static enum a implements INamable
    {
        a("none"),
        b("block"),
        c("mob"),
        d("tnt"),
        e("trigger"),
        STANDARD("standard");

        public static final Codec<a> f;
        private final String g;

        private a(String s2) {
            this.g = s2;
        }

        @Override
        public String c() {
            return this.g;
        }

        static {
            f = INamable.a(a::values);
        }
    }
}

