/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.hash.Hashing;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.BiomeBase;

public class BiomeManager {
    public static final int a = QuartPos.a(8);
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 3;
    private final Provider e;
    private final long f;

    public BiomeManager(Provider storage, long seed) {
        this.e = storage;
        this.f = seed;
    }

    public static long a(long seed) {
        return Hashing.sha256().hashLong(seed).asLong();
    }

    public BiomeManager a(Provider storage) {
        return new BiomeManager(storage, this.f);
    }

    public Holder<BiomeBase> a(BlockPosition pos) {
        int i2 = pos.u() - 2;
        int j2 = pos.v() - 2;
        int k2 = pos.w() - 2;
        int l2 = i2 >> 2;
        int m2 = j2 >> 2;
        int n2 = k2 >> 2;
        double d2 = (double)(i2 & 3) / 4.0;
        double e2 = (double)(j2 & 3) / 4.0;
        double f2 = (double)(k2 & 3) / 4.0;
        int o2 = 0;
        double g2 = Double.POSITIVE_INFINITY;
        for (int p2 = 0; p2 < 8; ++p2) {
            double u2;
            double t2;
            double h2;
            boolean bl3;
            int s2;
            boolean bl2;
            int r2;
            boolean bl = (p2 & 4) == 0;
            int q2 = bl ? l2 : l2 + 1;
            double v2 = BiomeManager.a(this.f, q2, r2 = (bl2 = (p2 & 2) == 0) ? m2 : m2 + 1, s2 = (bl3 = (p2 & 1) == 0) ? n2 : n2 + 1, h2 = bl ? d2 : d2 - 1.0, t2 = bl2 ? e2 : e2 - 1.0, u2 = bl3 ? f2 : f2 - 1.0);
            if (!(g2 > v2)) continue;
            o2 = p2;
            g2 = v2;
        }
        int w2 = (o2 & 4) == 0 ? l2 : l2 + 1;
        int x2 = (o2 & 2) == 0 ? m2 : m2 + 1;
        int y2 = (o2 & 1) == 0 ? n2 : n2 + 1;
        return this.e.getNoiseBiome(w2, x2, y2);
    }

    public Holder<BiomeBase> a(double x2, double y2, double z2) {
        int i2 = QuartPos.a(MathHelper.a(x2));
        int j2 = QuartPos.a(MathHelper.a(y2));
        int k2 = QuartPos.a(MathHelper.a(z2));
        return this.a(i2, j2, k2);
    }

    public Holder<BiomeBase> b(BlockPosition pos) {
        int i2 = QuartPos.a(pos.u());
        int j2 = QuartPos.a(pos.v());
        int k2 = QuartPos.a(pos.w());
        return this.a(i2, j2, k2);
    }

    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.e.getNoiseBiome(biomeX, biomeY, biomeZ);
    }

    private static double a(long l2, int i2, int j2, int k2, double d2, double e2, double f2) {
        long m2 = LinearCongruentialGenerator.a(l2, i2);
        m2 = LinearCongruentialGenerator.a(m2, j2);
        m2 = LinearCongruentialGenerator.a(m2, k2);
        m2 = LinearCongruentialGenerator.a(m2, i2);
        m2 = LinearCongruentialGenerator.a(m2, j2);
        m2 = LinearCongruentialGenerator.a(m2, k2);
        double g2 = BiomeManager.b(m2);
        m2 = LinearCongruentialGenerator.a(m2, l2);
        double h2 = BiomeManager.b(m2);
        m2 = LinearCongruentialGenerator.a(m2, l2);
        double n2 = BiomeManager.b(m2);
        return MathHelper.k(f2 + n2) + MathHelper.k(e2 + h2) + MathHelper.k(d2 + g2);
    }

    private static double b(long l2) {
        return (double)((l2 >> 24 & 0x3FFL) - 512L) * 8.7890625E-4;
    }

    public static interface Provider {
        public Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3);
    }
}

