/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class Block
extends BlockBase
implements IMaterial {
    public static final MapCodec<Block> p = Block.b(Block::new);
    private static final Logger a = LogUtils.getLogger();
    private final Holder.c<Block> b = BuiltInRegistries.e.f(this);
    public static final RegistryBlockID<IBlockData> q = new RegistryBlockID();
    private static final LoadingCache<VoxelShape, Boolean> c = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean a(VoxelShape voxelshape) {
            return !VoxelShapes.c(VoxelShapes.b(), voxelshape, OperatorBoolean.g);
        }
    });
    public static final int r = 1;
    public static final int s = 2;
    public static final int t = 4;
    public static final int u = 8;
    public static final int v = 16;
    public static final int w = 32;
    public static final int x = 64;
    public static final int y = 128;
    public static final int z = 4;
    public static final int A = 3;
    public static final int B = 11;
    public static final float C = -1.0f;
    public static final float D = 0.0f;
    public static final int E = 512;
    protected final BlockStateList<Block, IBlockData> F;
    private IBlockData d;
    @Nullable
    private Item e;
    private static final int f = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> g = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<a>(256, 0.25f){

            protected void rehash(int i2) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public final boolean isDestroyable() {
        return GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || this != Blocks.in && this != Blocks.I && this != Blocks.fM && this != Blocks.fL && this != Blocks.la && this != Blocks.gb && this != Blocks.lb && this != Blocks.lc && this != Blocks.pv && this != Blocks.pw;
    }

    @Override
    protected MapCodec<? extends Block> a() {
        return p;
    }

    public static int j(@Nullable IBlockData state) {
        if (state == null) {
            return 0;
        }
        int i2 = q.a(state);
        return i2 == -1 ? 0 : i2;
    }

    public static IBlockData a(int stateId) {
        IBlockData iblockdata = q.a(stateId);
        return iblockdata == null ? Blocks.a.m() : iblockdata;
    }

    public static Block a(@Nullable Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).d() : Blocks.a;
    }

    public static IBlockData a(IBlockData from, IBlockData to, GeneratorAccess world, BlockPosition pos) {
        VoxelShape voxelshape = VoxelShapes.b(from.g(world, pos), to.g(world, pos), OperatorBoolean.c).a(pos.u(), (double)pos.v(), (double)pos.w());
        if (voxelshape.c()) {
            return to;
        }
        List<Entity> list = world.a_(null, voxelshape.a());
        for (Entity entity : list) {
            double d0 = VoxelShapes.a(EnumDirection.EnumAxis.b, entity.cR().d(0.0, 1.0, 0.0), List.of(voxelshape), -1.0);
            entity.d(0.0, 1.0 + d0, 0.0);
        }
        return to;
    }

    public static VoxelShape a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return VoxelShapes.a(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }

    public static IBlockData b(IBlockData state, GeneratorAccess world, BlockPosition pos) {
        IBlockData iblockdata1 = state;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : BlockBase.aG) {
            blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
            iblockdata1 = iblockdata1.a(world, world, pos, enumdirection, blockposition_mutableblockposition, world.a_(blockposition_mutableblockposition), world.H_());
        }
        return iblockdata1;
    }

    public static void a(IBlockData state, IBlockData newState, GeneratorAccess world, BlockPosition pos, int flags) {
        Block.a(state, newState, world, pos, flags, 512);
    }

    public static void a(IBlockData state, IBlockData newState, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
        if (newState != state) {
            if (newState.l()) {
                if (!world.B_()) {
                    world.a(pos, (flags & 0x20) == 0, (Entity)null, maxUpdateDepth);
                }
            } else {
                world.a(pos, newState, flags & 0xFFFFFFDF, maxUpdateDepth);
            }
        }
    }

    public Block(BlockBase.Info settings) {
        super(settings);
        String s2;
        BlockStateList.a<Block, IBlockData> blockstatelist_a = new BlockStateList.a<Block, IBlockData>(this);
        this.a(blockstatelist_a);
        this.F = blockstatelist_a.a(Block::m, IBlockData::new);
        this.l(this.F.b());
        if (SharedConstants.aU && !(s2 = this.getClass().getSimpleName()).endsWith("Block")) {
            a.error("Block classes should end with Block and {} doesn't.", (Object)s2);
        }
    }

    public static boolean k(IBlockData state) {
        return state.b() instanceof BlockLeaves || state.a(Blocks.in) || state.a(Blocks.er) || state.a(Blocks.es) || state.a(Blocks.fo) || state.a(Blocks.fn) || state.a(TagsBlock.am);
    }

    public static boolean a(IBlockData state, IBlockData otherState, EnumDirection side) {
        VoxelShape voxelshape = otherState.a(side.g());
        if (voxelshape == VoxelShapes.b()) {
            return false;
        }
        if (state.a(otherState, side)) {
            return false;
        }
        if (voxelshape == VoxelShapes.a()) {
            return true;
        }
        VoxelShape voxelshape1 = state.a(side);
        if (voxelshape1 == VoxelShapes.a()) {
            return true;
        }
        a block_a = new a(voxelshape1, voxelshape);
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = g.get();
        byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
        if (b0 != 127) {
            return b0 != 0;
        }
        boolean flag = VoxelShapes.c(voxelshape1, voxelshape, OperatorBoolean.e);
        if (object2bytelinkedopenhashmap.size() == 256) {
            object2bytelinkedopenhashmap.removeLastByte();
        }
        object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
        return flag;
    }

    public static boolean c(IBlockAccess world, BlockPosition pos) {
        return world.a_(pos).a(world, pos, EnumDirection.b, EnumBlockSupport.c);
    }

    public static boolean a(IWorldReader world, BlockPosition pos, EnumDirection side) {
        IBlockData iblockdata = world.a_(pos);
        return side == EnumDirection.a && iblockdata.a(TagsBlock.bb) ? false : iblockdata.a((IBlockAccess)world, pos, side, EnumBlockSupport.b);
    }

    public static boolean a(VoxelShape shape, EnumDirection side) {
        VoxelShape voxelshape1 = shape.a(side);
        return Block.a(voxelshape1);
    }

    public static boolean a(VoxelShape shape) {
        return shape.moonrise$isFullBlock();
    }

    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
    }

    public void a(GeneratorAccess world, BlockPosition pos, IBlockData state) {
    }

    public static List<net.minecraft.world.item.ItemStack> a(IBlockData state, WorldServer world, BlockPosition pos, @Nullable TileEntity blockEntity) {
        LootParams.a lootparams_a = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, net.minecraft.world.item.ItemStack.j).b(LootContextParameters.h, blockEntity);
        return state.a(lootparams_a);
    }

    public static List<net.minecraft.world.item.ItemStack> a(IBlockData state, WorldServer world, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack stack) {
        LootParams.a lootparams_a = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, stack).b(LootContextParameters.a, entity).b(LootContextParameters.h, blockEntity);
        return state.a(lootparams_a);
    }

    public static void c(IBlockData state, World world, BlockPosition pos) {
        if (world instanceof WorldServer) {
            Block.a(state, (WorldServer)world, pos, (TileEntity)null).forEach(itemstack -> Block.a(world, pos, itemstack));
            state.a((WorldServer)world, pos, net.minecraft.world.item.ItemStack.j, true);
        }
    }

    public static void a(IBlockData state, GeneratorAccess world, BlockPosition pos, @Nullable TileEntity blockEntity) {
        if (world instanceof WorldServer) {
            Block.a(state, (WorldServer)world, pos, blockEntity).forEach(itemstack -> Block.a((World)((WorldServer)world), pos, itemstack));
            state.a((WorldServer)world, pos, net.minecraft.world.item.ItemStack.j, true);
        }
    }

    public static boolean dropResources(IBlockData state, GeneratorAccess levelAccessor, BlockPosition pos, @Nullable TileEntity blockEntity, BlockPosition source) {
        if (levelAccessor instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)levelAccessor;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (net.minecraft.world.item.ItemStack drop : Block.a(state, serverLevel, pos, blockEntity)) {
                items.add(CraftItemStack.asBukkitCopy(drop));
            }
            Block block = state.b();
            BlockBreakBlockEvent event = new BlockBreakBlockEvent((org.bukkit.block.Block)CraftBlock.at(levelAccessor, pos), (org.bukkit.block.Block)CraftBlock.at(levelAccessor, source), items);
            event.setExpToDrop(block.getExpDrop(state, serverLevel, pos, net.minecraft.world.item.ItemStack.j, true));
            event.callEvent();
            for (ItemStack drop : event.getDrops()) {
                Block.a((World)serverLevel, pos, CraftItemStack.asNMSCopy(drop));
            }
            state.a(serverLevel, pos, net.minecraft.world.item.ItemStack.j, false);
            block.a(serverLevel, pos, event.getExpToDrop());
        }
        return true;
    }

    public static void a(IBlockData state, World world, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        Block.dropResources(state, world, pos, blockEntity, entity, tool, true);
    }

    public static void dropResources(IBlockData state, World world, BlockPosition pos, @Nullable TileEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool, boolean dropExperience) {
        if (world instanceof WorldServer) {
            Block.a(state, (WorldServer)world, pos, blockEntity, entity, tool).forEach(itemstack1 -> Block.a(world, pos, itemstack1));
            state.a((WorldServer)world, pos, tool, dropExperience);
        }
    }

    public static void a(World world, BlockPosition pos, net.minecraft.world.item.ItemStack stack) {
        double d0 = (double)EntityTypes.ar.m() / 2.0;
        double d1 = (double)pos.u() + 0.5 + MathHelper.a(world.A, -0.25, 0.25);
        double d2 = (double)pos.v() + 0.5 + MathHelper.a(world.A, -0.25, 0.25) - d0;
        double d3 = (double)pos.w() + 0.5 + MathHelper.a(world.A, -0.25, 0.25);
        Block.a(world, () -> new EntityItem(world, d1, d2, d3, stack), stack);
    }

    public static void a(World world, BlockPosition pos, EnumDirection direction, net.minecraft.world.item.ItemStack stack) {
        int i2 = direction.j();
        int j2 = direction.k();
        int k2 = direction.l();
        double d0 = (double)EntityTypes.ar.l() / 2.0;
        double d1 = (double)EntityTypes.ar.m() / 2.0;
        double d2 = (double)pos.u() + 0.5 + (i2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)i2 * (0.5 + d0));
        double d3 = (double)pos.v() + 0.5 + (j2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)j2 * (0.5 + d1)) - d1;
        double d4 = (double)pos.w() + 0.5 + (k2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)k2 * (0.5 + d0));
        double d5 = i2 == 0 ? MathHelper.a(world.A, -0.1, 0.1) : (double)i2 * 0.1;
        double d6 = j2 == 0 ? MathHelper.a(world.A, 0.0, 0.1) : (double)j2 * 0.1 + 0.1;
        double d7 = k2 == 0 ? MathHelper.a(world.A, -0.1, 0.1) : (double)k2 * 0.1;
        Block.a(world, () -> new EntityItem(world, d2, d3, d4, stack, d5, d6, d7), stack);
    }

    private static void a(World world, Supplier<EntityItem> itemEntitySupplier, net.minecraft.world.item.ItemStack stack) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!stack.f() && worldserver.N().b(GameRules.h)) {
                EntityItem entityitem = itemEntitySupplier.get();
                entityitem.s();
                if (world.captureDrops != null) {
                    world.captureDrops.add(entityitem);
                } else {
                    world.b(entityitem);
                }
                return;
            }
        }
    }

    public void a(WorldServer world, BlockPosition pos, int size) {
        this.popExperience(world, pos, size, null);
    }

    public void popExperience(WorldServer world, BlockPosition pos, int size, Entity entity) {
        if (world.N().b(GameRules.h)) {
            EntityExperienceOrb.award(world, Vec3D.b(pos), size, ExperienceOrb.SpawnReason.BLOCK_BREAK, entity);
        }
    }

    public float e() {
        return this.aI;
    }

    public void a(WorldServer world, BlockPosition pos, Explosion explosion) {
    }

    public void a(World world, BlockPosition pos, IBlockData state, Entity entity) {
    }

    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        return this.m();
    }

    @DoNotUse
    @Deprecated
    public void a(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, net.minecraft.world.item.ItemStack tool) {
        this.playerDestroy(world, player, pos, state, blockEntity, tool, true, true);
    }

    public void playerDestroy(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        player.b(StatisticList.a.b(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        if (includeDrops) {
            Block.dropResources(state, world, pos, blockEntity, player, tool, dropExp);
        }
    }

    public void a(World world, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, net.minecraft.world.item.ItemStack itemStack) {
    }

    public boolean a(IBlockData state) {
        return !state.e() && !state.n();
    }

    public IChatMutableComponent f() {
        return IChatBaseComponent.c(this.v());
    }

    public void a(World world, IBlockData state, BlockPosition pos, Entity entity, float fallDistance) {
        entity.a(fallDistance, 1.0f, entity.dX().l());
    }

    public void a(IBlockAccess world, Entity entity) {
        entity.h(entity.dz().d(1.0, 0.0, 1.0));
    }

    public net.minecraft.world.item.ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return new net.minecraft.world.item.ItemStack(this);
    }

    public float g() {
        return this.aL;
    }

    public float h() {
        return this.aM;
    }

    public float k() {
        return this.aN;
    }

    protected void a(World world, EntityHuman player, BlockPosition pos, IBlockData state) {
        world.a(player, 2001, pos, Block.j(state));
    }

    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        this.a(world, player, pos, state);
        if (state.a(TagsBlock.aY) && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            PiglinAI.a(worldserver, player, false);
        }
        world.a(GameEvent.f, pos, GameEvent.a.a(player, state));
        return state;
    }

    public void a(IBlockData state, World world, BlockPosition pos, BiomeBase.Precipitation precipitation) {
    }

    public boolean a(Explosion explosion) {
        return true;
    }

    protected void a(BlockStateList.a<Block, IBlockData> builder) {
    }

    public BlockStateList<Block, IBlockData> l() {
        return this.F;
    }

    protected final void l(IBlockData state) {
        this.d = state;
    }

    public final IBlockData m() {
        return this.d;
    }

    public final IBlockData m(IBlockData state) {
        IBlockData iblockdata1 = this.m();
        for (IBlockState<?> iblockstate : state.b().l().d()) {
            if (!iblockdata1.b(iblockstate)) continue;
            iblockdata1 = Block.a(state, iblockdata1, iblockstate);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData source, IBlockData target, IBlockState<T> property) {
        return (IBlockData)target.b(property, source.c(property));
    }

    @Override
    public Item j() {
        if (this.e == null) {
            this.e = Item.a(this);
        }
        return this.e;
    }

    public boolean n() {
        return this.aO;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.e.e(this).g() + "}";
    }

    public void a(net.minecraft.world.item.ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag options) {
    }

    @Override
    protected Block o() {
        return this;
    }

    protected ImmutableMap<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> stateToShape) {
        return (ImmutableMap)this.F.a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), stateToShape));
    }

    @Deprecated
    public Holder.c<Block> p() {
        return this.b;
    }

    protected int tryDropExperience(WorldServer worldserver, BlockPosition blockposition, net.minecraft.world.item.ItemStack itemstack, IntProvider intprovider) {
        int i2 = EnchantmentManager.b(worldserver, itemstack, intprovider.a(worldserver.H_()));
        if (i2 > 0) {
            return i2;
        }
        return 0;
    }

    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        return 0;
    }

    public static float range(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private record a(VoxelShape a, VoxelShape b) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof a) {
                a block_a = (a)object;
                if (this.a == block_a.a && this.b == block_a.b) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.a) * 31 + System.identityHashCode(this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "first;second", "a", "b"}, this);
        }
    }
}

