/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBamboo> a = BlockBamboo.b(BlockBamboo::new);
    protected static final float b = 3.0f;
    protected static final float c = 5.0f;
    protected static final float d = 1.5f;
    protected static final VoxelShape e = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape f = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape g = Block.a(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final BlockStateInteger h = BlockProperties.ar;
    public static final BlockStateEnum<BlockPropertyBambooSize> i = BlockProperties.bl;
    public static final BlockStateInteger j = BlockProperties.aV;
    public static final int k = 16;
    public static final int l = 0;
    public static final int m = 1;
    public static final int n = 0;
    public static final int o = 1;

    public MapCodec<BlockBamboo> a() {
        return a;
    }

    public BlockBamboo(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(h, 0)).b(i, BlockPropertyBambooSize.a)).b(j, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(h, i, j);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelshape = state.c(i) == BlockPropertyBambooSize.c ? f : e;
        Vec3D vec3d = state.a(pos);
        return voxelshape.a(vec3d.d, vec3d.e, vec3d.f);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        Vec3D vec3d = state.a(pos);
        return g.a(vec3d.d, vec3d.e, vec3d.f);
    }

    @Override
    protected boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluid = ctx.q().b_(ctx.a());
        if (!fluid.c()) {
            return null;
        }
        IBlockData iblockdata = ctx.q().a_(ctx.a().e());
        if (iblockdata.a(TagsBlock.ax)) {
            if (iblockdata.a(Blocks.nt)) {
                return (IBlockData)this.m().b(h, 0);
            }
            if (iblockdata.a(Blocks.nu)) {
                int i2 = iblockdata.c(h) > 0 ? 1 : 0;
                return (IBlockData)this.m().b(h, i2);
            }
            IBlockData iblockdata1 = ctx.q().a_(ctx.a().d());
            return iblockdata1.a(Blocks.nu) ? (IBlockData)this.m().b(h, iblockdata1.c(h)) : Blocks.nt.m();
        }
        return null;
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)world, pos)) {
            world.b(pos, true);
        }
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(j) == 0;
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2;
        if (state.c(j) == 0 && random.i() < (float)world.spigotConfig.bambooModifier / 300.0f && world.u(pos.d()) && world.b(pos.d(), 0) >= 9 && (i2 = this.b(world, pos) + 1) < world.paperConfig().maxGrowthHeight.bamboo.max) {
            this.a(state, (World)world, pos, random, i2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return world.a_(pos.e()).a(TagsBlock.ax);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(world, pos)) {
            tickView.a(pos, this, 1);
        }
        return direction == EnumDirection.b && neighborState.a(Blocks.nu) && neighborState.c(h) > state.c(h) ? (IBlockData)state.a(h) : super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        int j2;
        int i2 = this.a((IBlockAccess)world, pos);
        return i2 + (j2 = this.b(world, pos)) + 1 < ((World)world).paperConfig().maxGrowthHeight.bamboo.max && world.a_(pos.b(i2)).c(j) != 1;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int i2 = this.a((IBlockAccess)world, pos);
        int j2 = this.b(world, pos);
        int k2 = i2 + j2 + 1;
        int l2 = 1 + random.a(2);
        for (int i1 = 0; i1 < l2; ++i1) {
            BlockPosition blockposition1 = pos.b(i2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            if (k2 >= world.paperConfig().maxGrowthHeight.bamboo.max || !iblockdata1.a(Blocks.nu) || iblockdata1.c(j) == 1 || !world.u(blockposition1.d())) {
                return;
            }
            this.a(iblockdata1, (World)world, blockposition1, random, k2);
            ++i2;
            ++k2;
        }
    }

    @Override
    protected float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        return player.eZ().h() instanceof ItemSword ? 1.0f : super.a(state, player, world, pos);
    }

    protected void a(IBlockData state, World world, BlockPosition pos, RandomSource random, int height) {
        int k2;
        IBlockData iblockdata1 = world.a_(pos.e());
        BlockPosition blockposition1 = pos.c(2);
        IBlockData iblockdata2 = world.a_(blockposition1);
        BlockPropertyBambooSize blockpropertybamboosize = BlockPropertyBambooSize.a;
        boolean shouldUpdateOthers = false;
        if (height >= 1) {
            if (iblockdata1.a(Blocks.nu) && iblockdata1.c(i) != BlockPropertyBambooSize.a) {
                if (iblockdata1.a(Blocks.nu) && iblockdata1.c(i) != BlockPropertyBambooSize.a) {
                    blockpropertybamboosize = BlockPropertyBambooSize.c;
                    if (iblockdata2.a(Blocks.nu)) {
                        shouldUpdateOthers = true;
                    }
                }
            } else {
                blockpropertybamboosize = BlockPropertyBambooSize.b;
            }
        }
        int j2 = state.c(h) != 1 && !iblockdata2.a(Blocks.nu) ? 0 : 1;
        int n2 = k2 = (height < world.paperConfig().maxGrowthHeight.bamboo.min || random.i() >= 0.25f) && height != world.paperConfig().maxGrowthHeight.bamboo.max - 1 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(world, pos, pos.d(), (IBlockData)((IBlockData)((IBlockData)this.m().b(h, j2)).b(i, blockpropertybamboosize)).b(j, k2), 3) && shouldUpdateOthers) {
            world.a(pos.e(), (IBlockData)iblockdata1.b(i, BlockPropertyBambooSize.b), 3);
            world.a(blockposition1, (IBlockData)iblockdata2.b(i, BlockPropertyBambooSize.a), 3);
        }
    }

    protected int a(IBlockAccess world, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)world).paperConfig().maxGrowthHeight.bamboo.max && world.a_(pos.b(i2 + 1)).a(Blocks.nu); ++i2) {
        }
        return i2;
    }

    protected int b(IBlockAccess world, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)world).paperConfig().maxGrowthHeight.bamboo.max && world.a_(pos.c(i2 + 1)).a(Blocks.nu); ++i2) {
        }
        return i2;
    }
}

