/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.PlayerShearBlockEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;

public class BlockBeehive
extends BlockTileEntity {
    public static final MapCodec<BlockBeehive> a = BlockBeehive.b(BlockBeehive::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateInteger c = BlockProperties.aO;
    public static final int d = 5;
    private static final int e = 3;

    public MapCodec<BlockBeehive> a() {
        return a;
    }

    public BlockBeehive(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)this.F.b().b(c, 0)).b(b, EnumDirection.c));
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return state.c(c);
    }

    @Override
    public void playerDestroy(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool, includeDrops, dropExp);
        if (!world.C && blockEntity instanceof TileEntityBeehive) {
            TileEntityBeehive tileentitybeehive = (TileEntityBeehive)blockEntity;
            if (!EnchantmentManager.a(tool, EnchantmentTags.q)) {
                tileentitybeehive.a(player, state, TileEntityBeehive.ReleaseStatus.c);
                world.c(pos, this);
                this.b(world, pos);
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, Explosion explosion, BiConsumer<net.minecraft.world.item.ItemStack, BlockPosition> stackMerger) {
        super.a(state, world, pos, explosion, stackMerger);
        this.b(world, pos);
    }

    private void b(World world, BlockPosition pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).c(8.0, 6.0, 8.0);
        List<EntityBee> list = world.a(EntityBee.class, axisalignedbb);
        if (!list.isEmpty()) {
            List<EntityHuman> list1 = world.a(EntityHuman.class, axisalignedbb);
            if (list1.isEmpty()) {
                return;
            }
            for (EntityBee entitybee : list) {
                if (entitybee.O_() != null) continue;
                EntityHuman entityhuman = SystemUtils.a(list1, world.A);
                entitybee.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
            }
        }
    }

    public static void a(World world, BlockPosition pos) {
        BlockBeehive.a(world, pos, new net.minecraft.world.item.ItemStack(Items.xq, 3));
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        int i2 = state.c(c);
        boolean flag = false;
        if (i2 >= 5) {
            Item item = stack.h();
            if (stack.a(Items.sJ)) {
                PlayerShearBlockEvent event = new PlayerShearBlockEvent((Player)player.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos), (ItemStack)CraftItemStack.asCraftMirror(stack), CraftEquipmentSlot.getHand(hand), new ArrayList());
                event.getDrops().add(CraftItemStack.asCraftMirror(new net.minecraft.world.item.ItemStack(Items.xq, 3)));
                if (!event.callEvent()) {
                    return EnumInteractionResult.e;
                }
                world.a(player, player.dB(), player.dD(), player.dH(), SoundEffects.bX, SoundCategory.e, 1.0f, 1.0f);
                for (ItemStack itemDrop : event.getDrops()) {
                    BlockBeehive.a(world, pos, CraftItemStack.asNMSCopy(itemDrop));
                }
                stack.a(1, (EntityLiving)player, EntityLiving.d(hand));
                flag = true;
                world.a((Entity)player, GameEvent.M, pos);
            } else if (stack.a(Items.sY)) {
                stack.h(1);
                world.a(player, player.dB(), player.dD(), player.dH(), SoundEffects.cC, SoundCategory.e, 1.0f, 1.0f);
                if (stack.f()) {
                    player.a(hand, new net.minecraft.world.item.ItemStack(Items.xt));
                } else if (!player.gi().f(new net.minecraft.world.item.ItemStack(Items.xt))) {
                    player.a(new net.minecraft.world.item.ItemStack(Items.xt), false);
                }
                flag = true;
                world.a((Entity)player, GameEvent.y, pos);
            }
            if (!world.B_() && flag) {
                player.b(StatisticList.c.b(item));
            }
        }
        if (flag) {
            if (!BlockCampfire.a(world, pos)) {
                if (this.c(world, pos)) {
                    this.b(world, pos);
                }
                this.a(world, state, pos, player, TileEntityBeehive.ReleaseStatus.c);
            } else {
                this.a(world, state, pos);
            }
            return EnumInteractionResult.a;
        }
        return super.a(stack, state, world, pos, player, hand, hit);
    }

    private boolean c(World world, BlockPosition pos) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityBeehive) {
            TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
            return !tileentitybeehive.c();
        }
        return false;
    }

    public void a(World world, IBlockData state, BlockPosition pos, @Nullable EntityHuman player, TileEntityBeehive.ReleaseStatus beeState) {
        this.a(world, state, pos);
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityBeehive) {
            TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
            tileentitybeehive.a(player, state, beeState);
        }
    }

    public void a(World world, IBlockData state, BlockPosition pos) {
        world.a(pos, (IBlockData)state.b(c, 0), 3);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (state.c(c) >= 5) {
            for (int i2 = 0; i2 < random.a(1) + 1; ++i2) {
                this.a(world, pos, state);
            }
        }
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape;
        double d0;
        if (state.y().c() && world.A.i() >= 0.3f && (d0 = (voxelshape = state.g(world, pos)).c(EnumDirection.EnumAxis.b)) >= 1.0 && !state.a(TagsBlock.ar)) {
            double d1 = voxelshape.b(EnumDirection.EnumAxis.b);
            if (d1 > 0.0) {
                this.a(world, pos, voxelshape, (double)pos.v() + d1 - 0.05);
            } else {
                BlockPosition blockposition1 = pos.e();
                IBlockData iblockdata1 = world.a_(blockposition1);
                VoxelShape voxelshape1 = iblockdata1.g(world, blockposition1);
                double d2 = voxelshape1.c(EnumDirection.EnumAxis.b);
                if ((d2 < 1.0 || !iblockdata1.m(world, blockposition1)) && iblockdata1.y().c()) {
                    this.a(world, pos, voxelshape, (double)pos.v() - 0.05);
                }
            }
        }
    }

    private void a(World world, BlockPosition pos, VoxelShape shape, double height) {
        this.a(world, (double)pos.u() + shape.b(EnumDirection.EnumAxis.a), (double)pos.u() + shape.c(EnumDirection.EnumAxis.a), (double)pos.w() + shape.b(EnumDirection.EnumAxis.c), (double)pos.w() + shape.c(EnumDirection.EnumAxis.c), height);
    }

    private void a(World world, double minX, double maxX, double minZ, double maxZ, double height) {
        world.a(Particles.aw, MathHelper.d(world.A.j(), minX, maxX), height, MathHelper.d(world.A.j(), minZ, maxZ), 0.0, 0.0, 0.0);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.m().b(b, ctx.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, b);
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBeehive(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.C ? null : BlockBeehive.a(type, TileEntityTypes.I, TileEntityBeehive::a);
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (world instanceof WorldServer) {
            TileEntity tileentity;
            WorldServer worldserver = (WorldServer)world;
            if (player.b() && worldserver.N().b(GameRules.h) && (tileentity = world.c_(pos)) instanceof TileEntityBeehive) {
                boolean flag;
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                int i2 = state.c(c);
                boolean bl = flag = !tileentitybeehive.c();
                if (flag || i2 > 0) {
                    net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(this);
                    itemstack.b(tileentitybeehive.r());
                    itemstack.b(DataComponents.am, BlockItemStateProperties.a.a(c, i2));
                    EntityItem entityitem = new EntityItem(world, pos.u(), pos.v(), pos.w(), itemstack);
                    entityitem.s();
                    world.b(entityitem);
                }
            }
        }
        return super.a(world, pos, state, player);
    }

    @Override
    protected List<net.minecraft.world.item.ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity tileentity;
        Entity entity = builder.b(LootContextParameters.a);
        if ((entity instanceof EntityTNTPrimed || entity instanceof EntityCreeper || entity instanceof EntityWitherSkull || entity instanceof EntityWither || entity instanceof EntityMinecartTNT) && (tileentity = builder.b(LootContextParameters.h)) instanceof TileEntityBeehive) {
            TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
            tileentitybeehive.a(null, state, TileEntityBeehive.ReleaseStatus.c);
        }
        return super.a(state, builder);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        TileEntity tileentity;
        if (world.a_(neighborPos).b() instanceof BlockFire && (tileentity = world.c_(pos)) instanceof TileEntityBeehive) {
            TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
            tileentitybeehive.a(null, state, TileEntityBeehive.ReleaseStatus.c);
        }
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    public void a(net.minecraft.world.item.ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, context, tooltip, options);
        BlockItemStateProperties blockitemstateproperties = stack.a(DataComponents.am, BlockItemStateProperties.a);
        int i2 = Objects.requireNonNullElse(blockitemstateproperties.a(c), 0);
        int j2 = stack.a(DataComponents.an, List.of()).size();
        tooltip.add(IChatBaseComponent.a("container.beehive.bees", j2, 3).a(EnumChatFormat.h));
        tooltip.add(IChatBaseComponent.a("container.beehive.honey", i2, 5).a(EnumChatFormat.h));
    }
}

