/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class BlockBell
extends BlockTileEntity {
    public static final MapCodec<BlockBell> a = BlockBell.b(BlockBell::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateEnum<BlockPropertyBellAttach> c = BlockProperties.W;
    public static final BlockStateBoolean d = BlockProperties.x;
    private static final VoxelShape f = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape g = Block.a(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape h = Block.a(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape i = Block.a(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape j = VoxelShapes.a(i, h);
    private static final VoxelShape k = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape l = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape m = VoxelShapes.a(j, Block.a(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape n = VoxelShapes.a(j, Block.a(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape o = VoxelShapes.a(j, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape G = VoxelShapes.a(j, Block.a(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape H = VoxelShapes.a(j, Block.a(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int e = 1;

    public MapCodec<BlockBell> a() {
        return a;
    }

    public BlockBell(BlockBase.Info settings) {
        super(settings);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, BlockPropertyBellAttach.a)).b(d, false));
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        boolean flag1 = world.C(pos);
        if (flag1 != state.c(d)) {
            if (flag1) {
                this.a(world, pos, (EnumDirection)null);
            }
            world.a(pos, (IBlockData)state.b(d, flag1), 3);
        }
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        Entity entity = projectile.p();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (EntityHuman)entity : null;
        this.a(world, state, hit, entityhuman, true);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        return (EnumInteractionResult)((Object)(this.a(world, state, hit, player, true) ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    public boolean a(World world, IBlockData state, MovingObjectPositionBlock hitResult, @Nullable EntityHuman player, boolean checkHitPos) {
        boolean flag1;
        EnumDirection enumdirection = hitResult.c();
        BlockPosition blockposition = hitResult.b();
        boolean bl = flag1 = !checkHitPos || this.a(state, enumdirection, hitResult.g().e - (double)blockposition.v());
        if (flag1) {
            boolean flag2 = this.a(player, world, blockposition, enumdirection);
            if (flag2 && player != null) {
                player.a(StatisticList.az);
            }
            return true;
        }
        return false;
    }

    private boolean a(IBlockData state, EnumDirection side, double y2) {
        if (side.o() != EnumDirection.EnumAxis.b && y2 <= (double)0.8124f) {
            EnumDirection enumdirection1 = state.c(b);
            BlockPropertyBellAttach blockpropertybellattach = state.c(c);
            switch (blockpropertybellattach) {
                case a: {
                    return enumdirection1.o() == side.o();
                }
                case c: 
                case d: {
                    return enumdirection1.o() != side.o();
                }
                case b: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean a(World world, BlockPosition pos, @Nullable EnumDirection direction) {
        return this.a((Entity)null, world, pos, direction);
    }

    public boolean a(@Nullable Entity entity, World world, BlockPosition pos, @Nullable EnumDirection direction) {
        TileEntity tileentity = world.c_(pos);
        if (!world.C && tileentity instanceof TileEntityBell) {
            if (direction == null) {
                direction = world.a_(pos).c(b);
            }
            if (!CraftEventFactory.handleBellRingEvent(world, pos, direction, entity)) {
                return false;
            }
            ((TileEntityBell)tileentity).a(direction);
            world.a((EntityHuman)null, pos, SoundEffects.bZ, SoundCategory.e, 2.0f, 1.0f);
            world.a(entity, GameEvent.c, pos);
            return true;
        }
        return false;
    }

    private VoxelShape o(IBlockData state) {
        EnumDirection enumdirection = state.c(b);
        BlockPropertyBellAttach blockpropertybellattach = state.c(c);
        return blockpropertybellattach == BlockPropertyBellAttach.a ? (enumdirection != EnumDirection.c && enumdirection != EnumDirection.d ? g : f) : (blockpropertybellattach == BlockPropertyBellAttach.b ? H : (blockpropertybellattach == BlockPropertyBellAttach.d ? (enumdirection != EnumDirection.c && enumdirection != EnumDirection.d ? l : k) : (enumdirection == EnumDirection.c ? o : (enumdirection == EnumDirection.d ? G : (enumdirection == EnumDirection.f ? n : m)))));
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.o(state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.o(state);
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection = ctx.k();
        BlockPosition blockposition = ctx.a();
        World world = ctx.q();
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        if (enumdirection_enumaxis == EnumDirection.EnumAxis.b) {
            IBlockData iblockdata = (IBlockData)((IBlockData)this.m().b(c, enumdirection == EnumDirection.a ? BlockPropertyBellAttach.b : BlockPropertyBellAttach.a)).b(b, ctx.g());
            if (iblockdata.a((IWorldReader)ctx.q(), blockposition)) {
                return iblockdata;
            }
        } else {
            boolean flag = enumdirection_enumaxis == EnumDirection.EnumAxis.a && world.a_(blockposition.h()).c((IBlockAccess)world, blockposition.h(), EnumDirection.f) && world.a_(blockposition.i()).c((IBlockAccess)world, blockposition.i(), EnumDirection.e) || enumdirection_enumaxis == EnumDirection.EnumAxis.c && world.a_(blockposition.f()).c((IBlockAccess)world, blockposition.f(), EnumDirection.d) && world.a_(blockposition.g()).c((IBlockAccess)world, blockposition.g(), EnumDirection.c);
            IBlockData iblockdata = (IBlockData)((IBlockData)this.m().b(b, enumdirection.g())).b(c, flag ? BlockPropertyBellAttach.d : BlockPropertyBellAttach.c);
            if (iblockdata.a((IWorldReader)ctx.q(), ctx.a())) {
                return iblockdata;
            }
            boolean flag1 = world.a_(blockposition.e()).c((IBlockAccess)world, blockposition.e(), EnumDirection.b);
            if ((iblockdata = (IBlockData)iblockdata.b(c, flag1 ? BlockPropertyBellAttach.a : BlockPropertyBellAttach.b)).a((IWorldReader)ctx.q(), ctx.a())) {
                return iblockdata;
            }
        }
        return null;
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (explosion.g()) {
            this.a((World)world, pos, (EnumDirection)null);
        }
        super.a(state, world, pos, explosion, stackMerger);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader world, ScheduledTickAccess tickView, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyBellAttach blockpropertybellattach = state.c(c);
        EnumDirection enumdirection1 = BlockBell.q(state).g();
        if (enumdirection1 == direction && !state.a(world, pos) && blockpropertybellattach != BlockPropertyBellAttach.d) {
            return Blocks.a.m();
        }
        if (direction.o() == state.c(b).o()) {
            if (blockpropertybellattach == BlockPropertyBellAttach.d && !neighborState.c((IBlockAccess)world, neighborPos, direction)) {
                return (IBlockData)((IBlockData)state.b(c, BlockPropertyBellAttach.c)).b(b, direction.g());
            }
            if (blockpropertybellattach == BlockPropertyBellAttach.c && enumdirection1.g() == direction && neighborState.c((IBlockAccess)world, neighborPos, state.c(b))) {
                return (IBlockData)state.b(c, BlockPropertyBellAttach.d);
            }
        }
        return super.a(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection enumdirection = BlockBell.q(state).g();
        return enumdirection == EnumDirection.b ? Block.a(world, pos.d(), EnumDirection.a) : BlockAttachable.b(world, pos, enumdirection);
    }

    private static EnumDirection q(IBlockData state) {
        switch (state.c(c)) {
            case a: {
                return EnumDirection.b;
            }
            case b: {
                return EnumDirection.a;
            }
        }
        return state.c(b).g();
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBell(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockBell.a(type, TileEntityTypes.F, world.C ? TileEntityBell::a : TileEntityBell::b);
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }
}

